/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import java.util.TimeZone;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonFormat {
    public static final String DEFAULT_LOCALE = "##default";
    public static final String DEFAULT_TIMEZONE = "##default";

    public String pattern() default "";

    public Shape shape() default Shape.ANY;

    public String locale() default "##default";

    public String timezone() default "##default";

    public Feature[] with() default {};

    public Feature[] without() default {};

    public static class Value
    implements JacksonAnnotationValue<JsonFormat> {
        private final String pattern;
        private final Shape shape;
        private final Locale locale;
        private final String timezoneStr;
        private final Features features;
        private TimeZone _timezone;

        public Value() {
            this("", Shape.ANY, "", "", Features.empty());
        }

        public Value(JsonFormat ann) {
            this(ann.pattern(), ann.shape(), ann.locale(), ann.timezone(), Features.construct(ann));
        }

        public Value(String p, Shape sh, String localeStr, String tzStr, Features f2) {
            this(p, sh, localeStr == null || localeStr.length() == 0 || "##default".equals(localeStr) ? null : new Locale(localeStr), tzStr == null || tzStr.length() == 0 || "##default".equals(tzStr) ? null : tzStr, null, f2);
        }

        public Value(String p, Shape sh, Locale l2, TimeZone tz, Features f2) {
            this.pattern = p;
            this.shape = sh == null ? Shape.ANY : sh;
            this.locale = l2;
            this._timezone = tz;
            this.timezoneStr = null;
            this.features = f2 == null ? Features.empty() : f2;
        }

        public Value(String p, Shape sh, Locale l2, String tzStr, TimeZone tz, Features f2) {
            this.pattern = p;
            this.shape = sh == null ? Shape.ANY : sh;
            this.locale = l2;
            this._timezone = tz;
            this.timezoneStr = tzStr;
            this.features = f2 == null ? Features.empty() : f2;
        }

        @Deprecated
        public Value(String p, Shape sh, Locale l2, TimeZone tz) {
            this(p, sh, l2, tz, Features.empty());
        }

        @Deprecated
        public Value(String p, Shape sh, String localeStr, String tzStr) {
            this(p, sh, localeStr, tzStr, Features.empty());
        }

        @Deprecated
        public Value(String p, Shape sh, Locale l2, String tzStr, TimeZone tz) {
            this(p, sh, l2, tzStr, tz, Features.empty());
        }

        public static Value forPattern(String p) {
            return new Value(p, null, null, null, null, Features.empty());
        }

        public Value withPattern(String p) {
            return new Value(p, this.shape, this.locale, this.timezoneStr, this._timezone, this.features);
        }

        public Value withShape(Shape s) {
            return new Value(this.pattern, s, this.locale, this.timezoneStr, this._timezone, this.features);
        }

        public Value withLocale(Locale l2) {
            return new Value(this.pattern, this.shape, l2, this.timezoneStr, this._timezone, this.features);
        }

        public Value withTimeZone(TimeZone tz) {
            return new Value(this.pattern, this.shape, this.locale, null, tz, this.features);
        }

        public Value withFeature(Feature f2) {
            Features newFeats = this.features.with(f2);
            return newFeats == this.features ? this : new Value(this.pattern, this.shape, this.locale, this.timezoneStr, this._timezone, newFeats);
        }

        public Value withoutFeature(Feature f2) {
            Features newFeats = this.features.without(f2);
            return newFeats == this.features ? this : new Value(this.pattern, this.shape, this.locale, this.timezoneStr, this._timezone, newFeats);
        }

        @Override
        public Class<JsonFormat> valueFor() {
            return JsonFormat.class;
        }

        public String getPattern() {
            return this.pattern;
        }

        public Shape getShape() {
            return this.shape;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String timeZoneAsString() {
            if (this._timezone != null) {
                return this._timezone.getID();
            }
            return this.timezoneStr;
        }

        public TimeZone getTimeZone() {
            TimeZone tz = this._timezone;
            if (tz == null) {
                if (this.timezoneStr == null) {
                    return null;
                }
                this._timezone = tz = TimeZone.getTimeZone(this.timezoneStr);
            }
            return tz;
        }

        public boolean hasShape() {
            return this.shape != Shape.ANY;
        }

        public boolean hasPattern() {
            return this.pattern != null && this.pattern.length() > 0;
        }

        public boolean hasLocale() {
            return this.locale != null;
        }

        public boolean hasTimeZone() {
            return this._timezone != null || this.timezoneStr != null && !this.timezoneStr.isEmpty();
        }

        public Boolean getFeature(Feature f2) {
            return this.features.get(f2);
        }
    }

    public static class Features {
        private final int enabled;
        private final int disabled;
        private static final Features EMPTY = new Features(0, 0);

        private Features(int e2, int d2) {
            this.enabled = e2;
            this.disabled = d2;
        }

        public static Features empty() {
            return EMPTY;
        }

        public static Features construct(JsonFormat f2) {
            return Features.construct(f2.with(), f2.without());
        }

        public static Features construct(Feature[] enabled, Feature[] disabled) {
            int e2 = 0;
            for (Feature f2 : enabled) {
                e2 |= 1 << f2.ordinal();
            }
            int d2 = 0;
            for (Feature f3 : disabled) {
                d2 |= 1 << f3.ordinal();
            }
            return new Features(e2, d2);
        }

        public Features with(Feature ... features) {
            int e2 = this.enabled;
            for (Feature f2 : features) {
                e2 |= 1 << f2.ordinal();
            }
            return e2 == this.enabled ? this : new Features(e2, this.disabled);
        }

        public Features without(Feature ... features) {
            int d2 = this.disabled;
            for (Feature f2 : features) {
                d2 |= 1 << f2.ordinal();
            }
            return d2 == this.disabled ? this : new Features(this.enabled, d2);
        }

        public Boolean get(Feature f2) {
            int mask = 1 << f2.ordinal();
            if ((this.disabled & mask) != 0) {
                return Boolean.FALSE;
            }
            if ((this.enabled & mask) != 0) {
                return Boolean.TRUE;
            }
            return null;
        }
    }

    public static enum Feature {
        ACCEPT_SINGLE_VALUE_AS_ARRAY,
        WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS,
        WRITE_DATES_WITH_ZONE_ID,
        WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED,
        WRITE_SORTED_MAP_ENTRIES;

    }

    public static enum Shape {
        ANY,
        SCALAR,
        ARRAY,
        OBJECT,
        NUMBER,
        NUMBER_FLOAT,
        NUMBER_INT,
        STRING,
        BOOLEAN;


        public boolean isNumeric() {
            return this == NUMBER || this == NUMBER_INT || this == NUMBER_FLOAT;
        }

        public boolean isStructured() {
            return this == OBJECT || this == ARRAY;
        }
    }
}

