/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variants;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.FormatSchema;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonLocation;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser$NumberType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonStreamContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.TreeNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Version;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Versioned;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.type.TypeReference;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;

public abstract class JsonParser
implements Versioned,
Closeable {
    private static final int MIN_BYTE_I = -128;
    private static final int MAX_BYTE_I = 255;
    private static final int MIN_SHORT_I = Short.MIN_VALUE;
    private static final int MAX_SHORT_I = Short.MAX_VALUE;
    protected int _features;

    protected JsonParser() {
    }

    protected JsonParser(int n2) {
        this._features = n2;
    }

    public abstract ObjectCodec getCodec();

    public abstract void setCodec(ObjectCodec var1);

    public Object getInputSource() {
        return null;
    }

    public Object getCurrentValue() {
        JsonStreamContext jsonStreamContext = this.getParsingContext();
        if (jsonStreamContext == null) {
            return null;
        }
        return jsonStreamContext.getCurrentValue();
    }

    public void setCurrentValue(Object object) {
        JsonStreamContext jsonStreamContext = this.getParsingContext();
        if (jsonStreamContext != null) {
            jsonStreamContext.setCurrentValue(object);
        }
    }

    public void setSchema(FormatSchema formatSchema) {
        throw new UnsupportedOperationException("Parser of type " + this.getClass().getName() + " does not support schema of type '" + formatSchema.getSchemaType() + "'");
    }

    public FormatSchema getSchema() {
        return null;
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    @Override
    public abstract Version version();

    @Override
    public abstract void close();

    public int releaseBuffered(OutputStream outputStream) {
        return -1;
    }

    public int releaseBuffered(Writer writer) {
        return -1;
    }

    public JsonParser enable(JsonParser$Feature jsonParser$Feature) {
        this._features |= jsonParser$Feature.getMask();
        return this;
    }

    public JsonParser disable(JsonParser$Feature jsonParser$Feature) {
        this._features &= ~jsonParser$Feature.getMask();
        return this;
    }

    public JsonParser configure(JsonParser$Feature jsonParser$Feature, boolean bl) {
        if (bl) {
            this.enable(jsonParser$Feature);
        } else {
            this.disable(jsonParser$Feature);
        }
        return this;
    }

    public boolean isEnabled(JsonParser$Feature jsonParser$Feature) {
        return jsonParser$Feature.enabledIn(this._features);
    }

    public int getFeatureMask() {
        return this._features;
    }

    public JsonParser setFeatureMask(int n2) {
        this._features = n2;
        return this;
    }

    public JsonParser overrideStdFeatures(int n2, int n3) {
        this._features = this._features & ~n3 | n2 & n3;
        return this;
    }

    public int getFormatFeatures() {
        return 0;
    }

    public JsonParser overrideFormatFeatures(int n2, int n3) {
        throw new IllegalArgumentException("No FormatFeatures defined for parser of type " + this.getClass().getName());
    }

    public abstract JsonToken nextToken();

    public abstract JsonToken nextValue();

    public boolean nextFieldName(SerializableString serializableString) {
        return this.nextToken() == JsonToken.FIELD_NAME && serializableString.getValue().equals(this.getCurrentName());
    }

    public String nextFieldName() {
        if (this.nextToken() == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return null;
    }

    public String nextTextValue() {
        if (this.nextToken() == JsonToken.VALUE_STRING) {
            return this.getText();
        }
        return null;
    }

    public int nextIntValue(int n2) {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getIntValue();
        }
        return n2;
    }

    public long nextLongValue(long l2) {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getLongValue();
        }
        return l2;
    }

    public Boolean nextBooleanValue() {
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    public abstract JsonParser skipChildren();

    public abstract boolean isClosed();

    public abstract JsonToken getCurrentToken();

    public abstract int getCurrentTokenId();

    public abstract boolean hasCurrentToken();

    public abstract boolean hasTokenId(int var1);

    public abstract boolean hasToken(JsonToken var1);

    public abstract String getCurrentName();

    public abstract JsonStreamContext getParsingContext();

    public abstract JsonLocation getTokenLocation();

    public abstract JsonLocation getCurrentLocation();

    public boolean isExpectedStartArrayToken() {
        return this.getCurrentToken() == JsonToken.START_ARRAY;
    }

    public boolean isExpectedStartObjectToken() {
        return this.getCurrentToken() == JsonToken.START_OBJECT;
    }

    public abstract void clearCurrentToken();

    public abstract JsonToken getLastClearedToken();

    public abstract void overrideCurrentName(String var1);

    public abstract String getText();

    public abstract char[] getTextCharacters();

    public abstract int getTextLength();

    public abstract int getTextOffset();

    public abstract boolean hasTextCharacters();

    public abstract Number getNumberValue();

    public abstract JsonParser$NumberType getNumberType();

    public byte getByteValue() {
        int n2 = this.getIntValue();
        if (n2 < -128 || n2 > 255) {
            throw this._constructError("Numeric value (" + this.getText() + ") out of range of Java byte");
        }
        return (byte)n2;
    }

    public short getShortValue() {
        int n2 = this.getIntValue();
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw this._constructError("Numeric value (" + this.getText() + ") out of range of Java short");
        }
        return (short)n2;
    }

    public abstract int getIntValue();

    public abstract long getLongValue();

    public abstract BigInteger getBigIntegerValue();

    public abstract float getFloatValue();

    public abstract double getDoubleValue();

    public abstract BigDecimal getDecimalValue();

    public boolean getBooleanValue() {
        JsonToken jsonToken = this.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return false;
        }
        throw new JsonParseException("Current token (" + (Object)((Object)jsonToken) + ") not of boolean type", this.getCurrentLocation());
    }

    public abstract Object getEmbeddedObject();

    public abstract byte[] getBinaryValue(Base64Variant var1);

    public byte[] getBinaryValue() {
        return this.getBinaryValue(Base64Variants.getDefaultVariant());
    }

    public int readBinaryValue(OutputStream outputStream) {
        return this.readBinaryValue(Base64Variants.getDefaultVariant(), outputStream);
    }

    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) {
        this._reportUnsupportedOperation();
        return 0;
    }

    public int getValueAsInt() {
        return this.getValueAsInt(0);
    }

    public int getValueAsInt(int n2) {
        return n2;
    }

    public long getValueAsLong() {
        return this.getValueAsLong(0L);
    }

    public long getValueAsLong(long l2) {
        return l2;
    }

    public double getValueAsDouble() {
        return this.getValueAsDouble(0.0);
    }

    public double getValueAsDouble(double d2) {
        return d2;
    }

    public boolean getValueAsBoolean() {
        return this.getValueAsBoolean(false);
    }

    public boolean getValueAsBoolean(boolean bl) {
        return bl;
    }

    public String getValueAsString() {
        return this.getValueAsString(null);
    }

    public abstract String getValueAsString(String var1);

    public boolean canReadObjectId() {
        return false;
    }

    public boolean canReadTypeId() {
        return false;
    }

    public Object getObjectId() {
        return null;
    }

    public Object getTypeId() {
        return null;
    }

    public <T> T readValueAs(Class<T> clazz) {
        return this._codec().readValue(this, clazz);
    }

    public <T> T readValueAs(TypeReference<?> typeReference) {
        return this._codec().readValue(this, typeReference);
    }

    public <T> Iterator<T> readValuesAs(Class<T> clazz) {
        return this._codec().readValues(this, clazz);
    }

    public <T> Iterator<T> readValuesAs(TypeReference<?> typeReference) {
        return this._codec().readValues(this, typeReference);
    }

    public <T extends TreeNode> T readValueAsTree() {
        return this._codec().readTree(this);
    }

    protected ObjectCodec _codec() {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for parser, needed for deserialization");
        }
        return objectCodec;
    }

    protected JsonParseException _constructError(String string) {
        return new JsonParseException(string, this.getCurrentLocation());
    }

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Operation not supported by parser of type " + this.getClass().getName());
    }
}

