/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonEncoding;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.BufferRecycler;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.TextBuffer;

public class IOContext {
    protected final Object _sourceRef;
    protected JsonEncoding _encoding;
    protected final boolean _managedResource;
    protected final BufferRecycler _bufferRecycler;
    protected byte[] _readIOBuffer = null;
    protected byte[] _writeEncodingBuffer = null;
    protected byte[] _base64Buffer = null;
    protected char[] _tokenCBuffer = null;
    protected char[] _concatCBuffer = null;
    protected char[] _nameCopyBuffer = null;

    public IOContext(BufferRecycler bufferRecycler, Object object, boolean bl) {
        this._bufferRecycler = bufferRecycler;
        this._sourceRef = object;
        this._managedResource = bl;
    }

    public void setEncoding(JsonEncoding jsonEncoding) {
        this._encoding = jsonEncoding;
    }

    public IOContext withEncoding(JsonEncoding jsonEncoding) {
        this._encoding = jsonEncoding;
        return this;
    }

    public Object getSourceReference() {
        return this._sourceRef;
    }

    public JsonEncoding getEncoding() {
        return this._encoding;
    }

    public boolean isResourceManaged() {
        return this._managedResource;
    }

    public TextBuffer constructTextBuffer() {
        return new TextBuffer(this._bufferRecycler);
    }

    public byte[] allocReadIOBuffer() {
        this._verifyAlloc(this._readIOBuffer);
        this._readIOBuffer = this._bufferRecycler.allocByteBuffer(0);
        return this._readIOBuffer;
    }

    public byte[] allocReadIOBuffer(int n2) {
        this._verifyAlloc(this._readIOBuffer);
        this._readIOBuffer = this._bufferRecycler.allocByteBuffer(0, n2);
        return this._readIOBuffer;
    }

    public byte[] allocWriteEncodingBuffer() {
        this._verifyAlloc(this._writeEncodingBuffer);
        this._writeEncodingBuffer = this._bufferRecycler.allocByteBuffer(1);
        return this._writeEncodingBuffer;
    }

    public byte[] allocWriteEncodingBuffer(int n2) {
        this._verifyAlloc(this._writeEncodingBuffer);
        this._writeEncodingBuffer = this._bufferRecycler.allocByteBuffer(1, n2);
        return this._writeEncodingBuffer;
    }

    public byte[] allocBase64Buffer() {
        this._verifyAlloc(this._base64Buffer);
        this._base64Buffer = this._bufferRecycler.allocByteBuffer(3);
        return this._base64Buffer;
    }

    public char[] allocTokenBuffer() {
        this._verifyAlloc(this._tokenCBuffer);
        this._tokenCBuffer = this._bufferRecycler.allocCharBuffer(0);
        return this._tokenCBuffer;
    }

    public char[] allocTokenBuffer(int n2) {
        this._verifyAlloc(this._tokenCBuffer);
        this._tokenCBuffer = this._bufferRecycler.allocCharBuffer(0, n2);
        return this._tokenCBuffer;
    }

    public char[] allocConcatBuffer() {
        this._verifyAlloc(this._concatCBuffer);
        this._concatCBuffer = this._bufferRecycler.allocCharBuffer(1);
        return this._concatCBuffer;
    }

    public char[] allocNameCopyBuffer(int n2) {
        this._verifyAlloc(this._nameCopyBuffer);
        this._nameCopyBuffer = this._bufferRecycler.allocCharBuffer(3, n2);
        return this._nameCopyBuffer;
    }

    public void releaseReadIOBuffer(byte[] byArray) {
        if (byArray != null) {
            this._verifyRelease(byArray, this._readIOBuffer);
            this._readIOBuffer = null;
            this._bufferRecycler.releaseByteBuffer(0, byArray);
        }
    }

    public void releaseWriteEncodingBuffer(byte[] byArray) {
        if (byArray != null) {
            this._verifyRelease(byArray, this._writeEncodingBuffer);
            this._writeEncodingBuffer = null;
            this._bufferRecycler.releaseByteBuffer(1, byArray);
        }
    }

    public void releaseBase64Buffer(byte[] byArray) {
        if (byArray != null) {
            this._verifyRelease(byArray, this._base64Buffer);
            this._base64Buffer = null;
            this._bufferRecycler.releaseByteBuffer(3, byArray);
        }
    }

    public void releaseTokenBuffer(char[] cArray) {
        if (cArray != null) {
            this._verifyRelease(cArray, this._tokenCBuffer);
            this._tokenCBuffer = null;
            this._bufferRecycler.releaseCharBuffer(0, cArray);
        }
    }

    public void releaseConcatBuffer(char[] cArray) {
        if (cArray != null) {
            this._verifyRelease(cArray, this._concatCBuffer);
            this._concatCBuffer = null;
            this._bufferRecycler.releaseCharBuffer(1, cArray);
        }
    }

    public void releaseNameCopyBuffer(char[] cArray) {
        if (cArray != null) {
            this._verifyRelease(cArray, this._nameCopyBuffer);
            this._nameCopyBuffer = null;
            this._bufferRecycler.releaseCharBuffer(3, cArray);
        }
    }

    protected final void _verifyAlloc(Object object) {
        if (object != null) {
            throw new IllegalStateException("Trying to call same allocXxx() method second time");
        }
    }

    protected final void _verifyRelease(byte[] byArray, byte[] byArray2) {
        if (byArray != byArray2 && byArray.length <= byArray2.length) {
            throw this.wrongBuf();
        }
    }

    protected final void _verifyRelease(char[] cArray, char[] cArray2) {
        if (cArray != cArray2 && cArray.length <= cArray2.length) {
            throw this.wrongBuf();
        }
    }

    private IllegalArgumentException wrongBuf() {
        return new IllegalArgumentException("Trying to release buffer not owned by the context");
    }
}

