/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.filter;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonStreamContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.filter.TokenFilter;

public class TokenFilterContext
extends JsonStreamContext {
    protected final TokenFilterContext _parent;
    protected TokenFilterContext _child = null;
    protected String _currentName;
    protected TokenFilter _filter;
    protected boolean _startHandled;
    protected boolean _needToHandleName;

    protected TokenFilterContext(int n2, TokenFilterContext tokenFilterContext, TokenFilter tokenFilter, boolean bl) {
        this._type = n2;
        this._parent = tokenFilterContext;
        this._filter = tokenFilter;
        this._index = -1;
        this._startHandled = bl;
        this._needToHandleName = false;
    }

    protected TokenFilterContext reset(int n2, TokenFilter tokenFilter, boolean bl) {
        this._type = n2;
        this._filter = tokenFilter;
        this._index = -1;
        this._currentName = null;
        this._startHandled = bl;
        this._needToHandleName = false;
        return this;
    }

    public static TokenFilterContext createRootContext(TokenFilter tokenFilter) {
        return new TokenFilterContext(0, null, tokenFilter, true);
    }

    public TokenFilterContext createChildArrayContext(TokenFilter tokenFilter, boolean bl) {
        TokenFilterContext tokenFilterContext = this._child;
        if (tokenFilterContext == null) {
            this._child = tokenFilterContext = new TokenFilterContext(1, this, tokenFilter, bl);
            return tokenFilterContext;
        }
        return tokenFilterContext.reset(1, tokenFilter, bl);
    }

    public TokenFilterContext createChildObjectContext(TokenFilter tokenFilter, boolean bl) {
        TokenFilterContext tokenFilterContext = this._child;
        if (tokenFilterContext == null) {
            this._child = tokenFilterContext = new TokenFilterContext(2, this, tokenFilter, bl);
            return tokenFilterContext;
        }
        return tokenFilterContext.reset(2, tokenFilter, bl);
    }

    public TokenFilter setFieldName(String string) {
        this._currentName = string;
        this._needToHandleName = true;
        return this._filter;
    }

    public TokenFilter checkValue(TokenFilter tokenFilter) {
        if (this._type == 2) {
            return tokenFilter;
        }
        int n2 = ++this._index;
        if (this._type == 1) {
            return tokenFilter.includeElement(n2);
        }
        return tokenFilter.includeRootValue(n2);
    }

    public void writePath(JsonGenerator jsonGenerator) {
        if (this._filter == null || this._filter == TokenFilter.INCLUDE_ALL) {
            return;
        }
        if (this._parent != null) {
            this._parent._writePath(jsonGenerator);
        }
        if (this._startHandled) {
            if (this._needToHandleName) {
                jsonGenerator.writeFieldName(this._currentName);
                return;
            }
        } else {
            this._startHandled = true;
            if (this._type == 2) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeFieldName(this._currentName);
                return;
            }
            if (this._type == 1) {
                jsonGenerator.writeStartArray();
            }
        }
    }

    public void writeImmediatePath(JsonGenerator jsonGenerator) {
        if (this._filter == null || this._filter == TokenFilter.INCLUDE_ALL) {
            return;
        }
        if (this._startHandled) {
            if (this._needToHandleName) {
                jsonGenerator.writeFieldName(this._currentName);
                return;
            }
        } else {
            this._startHandled = true;
            if (this._type == 2) {
                jsonGenerator.writeStartObject();
                if (this._needToHandleName) {
                    jsonGenerator.writeFieldName(this._currentName);
                    return;
                }
            } else if (this._type == 1) {
                jsonGenerator.writeStartArray();
            }
        }
    }

    private void _writePath(JsonGenerator jsonGenerator) {
        if (this._filter == null || this._filter == TokenFilter.INCLUDE_ALL) {
            return;
        }
        if (this._parent != null) {
            this._parent._writePath(jsonGenerator);
        }
        if (this._startHandled) {
            if (this._needToHandleName) {
                this._needToHandleName = false;
                jsonGenerator.writeFieldName(this._currentName);
                return;
            }
        } else {
            this._startHandled = true;
            if (this._type == 2) {
                jsonGenerator.writeStartObject();
                if (this._needToHandleName) {
                    this._needToHandleName = false;
                    jsonGenerator.writeFieldName(this._currentName);
                    return;
                }
            } else if (this._type == 1) {
                jsonGenerator.writeStartArray();
            }
        }
    }

    public TokenFilterContext closeArray(JsonGenerator jsonGenerator) {
        if (this._startHandled) {
            jsonGenerator.writeEndArray();
        }
        if (this._filter != null && this._filter != TokenFilter.INCLUDE_ALL) {
            this._filter.filterFinishArray();
        }
        return this._parent;
    }

    public TokenFilterContext closeObject(JsonGenerator jsonGenerator) {
        if (this._startHandled) {
            jsonGenerator.writeEndObject();
        }
        if (this._filter != null && this._filter != TokenFilter.INCLUDE_ALL) {
            this._filter.filterFinishObject();
        }
        return this._parent;
    }

    public void skipParentChecks() {
        this._filter = null;
        TokenFilterContext tokenFilterContext = this._parent;
        while (tokenFilterContext != null) {
            this._parent._filter = null;
            tokenFilterContext = tokenFilterContext._parent;
        }
    }

    @Override
    public Object getCurrentValue() {
        return null;
    }

    @Override
    public void setCurrentValue(Object object) {
    }

    @Override
    public final TokenFilterContext getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    public TokenFilter getFilter() {
        return this._filter;
    }

    public boolean isStartHandled() {
        return this._startHandled;
    }

    public JsonToken nextTokenToRead() {
        if (!this._startHandled) {
            this._startHandled = true;
            if (this._type == 2) {
                return JsonToken.START_OBJECT;
            }
            return JsonToken.START_ARRAY;
        }
        if (this._needToHandleName && this._type == 2) {
            this._needToHandleName = false;
            return JsonToken.FIELD_NAME;
        }
        return null;
    }

    public TokenFilterContext findChildOf(TokenFilterContext tokenFilterContext) {
        if (this._parent == tokenFilterContext) {
            return this;
        }
        TokenFilterContext tokenFilterContext2 = this._parent;
        while (tokenFilterContext2 != null) {
            TokenFilterContext tokenFilterContext3 = tokenFilterContext2._parent;
            if (tokenFilterContext3 == tokenFilterContext) {
                return tokenFilterContext2;
            }
            tokenFilterContext2 = tokenFilterContext3;
        }
        return null;
    }

    protected void appendDesc(StringBuilder stringBuilder) {
        if (this._parent != null) {
            this._parent.appendDesc(stringBuilder);
        }
        if (this._type == 2) {
            stringBuilder.append('{');
            if (this._currentName != null) {
                stringBuilder.append('\"');
                stringBuilder.append(this._currentName);
                stringBuilder.append('\"');
            } else {
                stringBuilder.append('?');
            }
            stringBuilder.append('}');
            return;
        }
        if (this._type == 1) {
            stringBuilder.append('[');
            stringBuilder.append(this.getCurrentIndex());
            stringBuilder.append(']');
            return;
        }
        stringBuilder.append("/");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        this.appendDesc(stringBuilder);
        return stringBuilder.toString();
    }
}

