/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io;

public final class NumberOutput {
    private static final char NC = '\u0000';
    private static int MILLION = 1000000;
    private static int BILLION = 1000000000;
    private static long TEN_BILLION_L = 10000000000L;
    private static long THOUSAND_L = 1000L;
    private static long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    private static long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    static final String SMALLEST_LONG = "-9223372036854775808";
    static final char[] LEAD_3 = new char[4000];
    static final char[] FULL_3 = new char[4000];
    static final byte[] FULL_TRIPLETS_B;
    static final String[] sSmallIntStrs;
    static final String[] sSmallIntStrs2;

    public static int outputInt(int n, char[] cArray, int n2) {
        if (n < 0) {
            if (n == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)n, cArray, n2);
            }
            cArray[n2++] = 45;
            n = -n;
        }
        if (n < MILLION) {
            if (n < 1000) {
                if (n < 10) {
                    cArray[n2++] = (char)(n + 48);
                } else {
                    n2 = NumberOutput.leading3(n, cArray, n2);
                }
            } else {
                int n3 = n / 1000;
                n2 = NumberOutput.leading3(n3, cArray, n2);
                n2 = NumberOutput.full3(n -= n3 * 1000, cArray, n2);
            }
            return n2;
        }
        boolean bl = n >= BILLION;
        if (bl) {
            if ((n -= BILLION) >= BILLION) {
                n -= BILLION;
                cArray[n2++] = 50;
            } else {
                cArray[n2++] = 49;
            }
        }
        int n4 = n / 1000;
        int n5 = n - n4 * 1000;
        n = n4;
        n2 = bl ? NumberOutput.full3(n4, cArray, n2) : NumberOutput.leading3(n4, cArray, n2);
        n2 = NumberOutput.full3(n -= (n4 /= 1000) * 1000, cArray, n2);
        return NumberOutput.full3(n5, cArray, n2);
    }

    public static int outputInt(int n, byte[] byArray, int n2) {
        if (n < 0) {
            if (n == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)n, byArray, n2);
            }
            byArray[n2++] = 45;
            n = -n;
        }
        if (n < MILLION) {
            if (n < 1000) {
                if (n < 10) {
                    byArray[n2++] = (byte)(n + 48);
                } else {
                    n2 = NumberOutput.leading3(n, byArray, n2);
                }
            } else {
                int n3 = n / 1000;
                n2 = NumberOutput.leading3(n3, byArray, n2);
                n2 = NumberOutput.full3(n -= n3 * 1000, byArray, n2);
            }
            return n2;
        }
        boolean bl = n >= BILLION;
        if (bl) {
            if ((n -= BILLION) >= BILLION) {
                n -= BILLION;
                byArray[n2++] = 50;
            } else {
                byArray[n2++] = 49;
            }
        }
        int n4 = n / 1000;
        int n5 = n - n4 * 1000;
        n = n4;
        n2 = bl ? NumberOutput.full3(n4, byArray, n2) : NumberOutput.leading3(n4, byArray, n2);
        n2 = NumberOutput.full3(n -= (n4 /= 1000) * 1000, byArray, n2);
        return NumberOutput.full3(n5, byArray, n2);
    }

    public static int outputLong(long l, char[] cArray, int n) {
        if (l < 0L) {
            if (l > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)l, cArray, n);
            }
            if (l == Long.MIN_VALUE) {
                int n2 = SMALLEST_LONG.length();
                SMALLEST_LONG.getChars(0, n2, cArray, n);
                return n + n2;
            }
            cArray[n++] = 45;
            l = -l;
        } else if (l <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)l, cArray, n);
        }
        int n3 = n;
        int n4 = n += NumberOutput.calcLongStrLength(l);
        while (l > MAX_INT_AS_LONG) {
            long l2 = l / THOUSAND_L;
            NumberOutput.full3((int)(l - l2 * THOUSAND_L), cArray, n4 -= 3);
            l = l2;
        }
        int n5 = (int)l;
        while (n5 >= 1000) {
            int n6 = n5 / 1000;
            NumberOutput.full3(n5 - n6 * 1000, cArray, n4 -= 3);
            n5 = n6;
        }
        NumberOutput.leading3(n5, cArray, n3);
        return n;
    }

    public static int outputLong(long l, byte[] byArray, int n) {
        if (l < 0L) {
            if (l > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)l, byArray, n);
            }
            if (l == Long.MIN_VALUE) {
                int n2 = SMALLEST_LONG.length();
                for (int k = 0; k < n2; ++k) {
                    byArray[n++] = (byte)SMALLEST_LONG.charAt(k);
                }
                return n;
            }
            byArray[n++] = 45;
            l = -l;
        } else if (l <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)l, byArray, n);
        }
        int n3 = n;
        int n4 = n += NumberOutput.calcLongStrLength(l);
        while (l > MAX_INT_AS_LONG) {
            long l2 = l / THOUSAND_L;
            NumberOutput.full3((int)(l - l2 * THOUSAND_L), byArray, n4 -= 3);
            l = l2;
        }
        int n5 = (int)l;
        while (n5 >= 1000) {
            int n6 = n5 / 1000;
            NumberOutput.full3(n5 - n6 * 1000, byArray, n4 -= 3);
            n5 = n6;
        }
        NumberOutput.leading3(n5, byArray, n3);
        return n;
    }

    public static String toString(int n) {
        if (n < sSmallIntStrs.length) {
            if (n >= 0) {
                return sSmallIntStrs[n];
            }
            int n2 = -n - 1;
            if (n2 < sSmallIntStrs2.length) {
                return sSmallIntStrs2[n2];
            }
        }
        return Integer.toString(n);
    }

    public static String toString(long l) {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            return NumberOutput.toString((int)l);
        }
        return Long.toString(l);
    }

    public static String toString(double d2) {
        return Double.toString(d2);
    }

    public static String toString(float f2) {
        return Float.toString(f2);
    }

    private static int leading3(int n, char[] cArray, int n2) {
        char c2;
        n <<= 2;
        if ((c2 = LEAD_3[n++]) != '\u0000') {
            cArray[n2++] = c2;
        }
        if ((c2 = LEAD_3[n++]) != '\u0000') {
            cArray[n2++] = c2;
        }
        cArray[n2++] = LEAD_3[n];
        return n2;
    }

    private static int leading3(int n, byte[] byArray, int n2) {
        char c2;
        n <<= 2;
        if ((c2 = LEAD_3[n++]) != '\u0000') {
            byArray[n2++] = (byte)c2;
        }
        if ((c2 = LEAD_3[n++]) != '\u0000') {
            byArray[n2++] = (byte)c2;
        }
        byArray[n2++] = (byte)LEAD_3[n];
        return n2;
    }

    private static int full3(int n, char[] cArray, int n2) {
        n <<= 2;
        cArray[n2++] = FULL_3[n++];
        cArray[n2++] = FULL_3[n++];
        cArray[n2++] = FULL_3[n];
        return n2;
    }

    private static int full3(int n, byte[] byArray, int n2) {
        n <<= 2;
        byArray[n2++] = FULL_TRIPLETS_B[n++];
        byArray[n2++] = FULL_TRIPLETS_B[n++];
        byArray[n2++] = FULL_TRIPLETS_B[n];
        return n2;
    }

    private static int calcLongStrLength(long l) {
        int n;
        long l2 = TEN_BILLION_L;
        for (n = 10; l >= l2 && n != 19; ++n) {
            l2 = (l2 << 3) + (l2 << 1);
        }
        return n;
    }

    static {
        int n = 0;
        for (int k = 0; k < 10; ++k) {
            char c2 = (char)(k + 48);
            char c3 = k == 0 ? (char)'\u0000' : c2;
            for (int i2 = 0; i2 < 10; ++i2) {
                char c4 = (char)(i2 + 48);
                char c5 = k == 0 && i2 == 0 ? (char)'\u0000' : c4;
                for (int i3 = 0; i3 < 10; ++i3) {
                    char c6 = (char)(i3 + 48);
                    NumberOutput.LEAD_3[n] = c3;
                    NumberOutput.LEAD_3[n + 1] = c5;
                    NumberOutput.LEAD_3[n + 2] = c6;
                    NumberOutput.FULL_3[n] = c2;
                    NumberOutput.FULL_3[n + 1] = c4;
                    NumberOutput.FULL_3[n + 2] = c6;
                    n += 4;
                }
            }
        }
        FULL_TRIPLETS_B = new byte[4000];
        for (n = 0; n < 4000; ++n) {
            NumberOutput.FULL_TRIPLETS_B[n] = (byte)FULL_3[n];
        }
        sSmallIntStrs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        sSmallIntStrs2 = new String[]{"-1", "-2", "-3", "-4", "-5", "-6", "-7", "-8", "-9", "-10"};
    }
}

