/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variants;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import java.io.Serializable;
import java.util.Arrays;

public final class Base64Variant
implements Serializable {
    private static final int INT_SPACE = 32;
    private static final long serialVersionUID = 1L;
    static final char PADDING_CHAR_NONE = '\u0000';
    public static final int BASE64_VALUE_INVALID = -1;
    public static final int BASE64_VALUE_PADDING = -2;
    private final transient int[] _asciiToBase64 = new int[128];
    private final transient char[] _base64ToAsciiC = new char[64];
    private final transient byte[] _base64ToAsciiB = new byte[64];
    protected final String _name;
    protected final transient boolean _usesPadding;
    protected final transient char _paddingChar;
    protected final transient int _maxLineLength;

    public Base64Variant(String string, String string2, boolean bl, char c2, int n) {
        this._name = string;
        this._usesPadding = bl;
        this._paddingChar = c2;
        this._maxLineLength = n;
        int n2 = string2.length();
        if (n2 != 64) {
            throw new IllegalArgumentException("Base64Alphabet length must be exactly 64 (was " + n2 + ")");
        }
        string2.getChars(0, n2, this._base64ToAsciiC, 0);
        Arrays.fill(this._asciiToBase64, -1);
        int n3 = 0;
        while (n3 < n2) {
            n = this._base64ToAsciiC[n3];
            this._base64ToAsciiB[n3] = (byte)n;
            this._asciiToBase64[n] = n3++;
        }
        if (bl) {
            this._asciiToBase64[c2] = -2;
        }
    }

    public Base64Variant(Base64Variant base64Variant, String string, int n) {
        this(base64Variant, string, base64Variant._usesPadding, base64Variant._paddingChar, n);
    }

    public Base64Variant(Base64Variant object, String object2, boolean bl, char c2, int n) {
        this._name = object2;
        object2 = ((Base64Variant)object)._base64ToAsciiB;
        System.arraycopy(((Base64Variant)object)._base64ToAsciiB, 0, this._base64ToAsciiB, 0, ((Object)object2).length);
        object2 = ((Base64Variant)object)._base64ToAsciiC;
        System.arraycopy(((Base64Variant)object)._base64ToAsciiC, 0, this._base64ToAsciiC, 0, ((Object)object2).length);
        object = ((Base64Variant)object)._asciiToBase64;
        System.arraycopy(((Base64Variant)object)._asciiToBase64, 0, this._asciiToBase64, 0, ((Object)object).length);
        this._usesPadding = bl;
        this._paddingChar = c2;
        this._maxLineLength = n;
    }

    protected final Object readResolve() {
        return Base64Variants.valueOf(this._name);
    }

    public final String getName() {
        return this._name;
    }

    public final boolean usesPadding() {
        return this._usesPadding;
    }

    public final boolean usesPaddingChar(char c2) {
        return c2 == this._paddingChar;
    }

    public final boolean usesPaddingChar(int n) {
        return n == this._paddingChar;
    }

    public final char getPaddingChar() {
        return this._paddingChar;
    }

    public final byte getPaddingByte() {
        return (byte)this._paddingChar;
    }

    public final int getMaxLineLength() {
        return this._maxLineLength;
    }

    public final int decodeBase64Char(char c2) {
        if (c2 <= '\u007f') {
            return this._asciiToBase64[c2];
        }
        return -1;
    }

    public final int decodeBase64Char(int n) {
        if (n <= 127) {
            return this._asciiToBase64[n];
        }
        return -1;
    }

    public final int decodeBase64Byte(byte by) {
        if (by <= 127) {
            return this._asciiToBase64[by];
        }
        return -1;
    }

    public final char encodeBase64BitsAsChar(int n) {
        return this._base64ToAsciiC[n];
    }

    public final int encodeBase64Chunk(int n, char[] cArray, int n2) {
        cArray[n2++] = this._base64ToAsciiC[n >> 18 & 0x3F];
        cArray[n2++] = this._base64ToAsciiC[n >> 12 & 0x3F];
        cArray[n2++] = this._base64ToAsciiC[n >> 6 & 0x3F];
        cArray[n2++] = this._base64ToAsciiC[n & 0x3F];
        return n2;
    }

    public final void encodeBase64Chunk(StringBuilder stringBuilder, int n) {
        stringBuilder.append(this._base64ToAsciiC[n >> 18 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n >> 12 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n >> 6 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n & 0x3F]);
    }

    public final int encodeBase64Partial(int n, int n2, char[] cArray, int n3) {
        cArray[n3++] = this._base64ToAsciiC[n >> 18 & 0x3F];
        cArray[n3++] = this._base64ToAsciiC[n >> 12 & 0x3F];
        if (this._usesPadding) {
            cArray[n3++] = n2 == 2 ? this._base64ToAsciiC[n >> 6 & 0x3F] : this._paddingChar;
            cArray[n3++] = this._paddingChar;
        } else if (n2 == 2) {
            cArray[n3++] = this._base64ToAsciiC[n >> 6 & 0x3F];
        }
        return n3;
    }

    public final void encodeBase64Partial(StringBuilder stringBuilder, int n, int n2) {
        stringBuilder.append(this._base64ToAsciiC[n >> 18 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n >> 12 & 0x3F]);
        if (this._usesPadding) {
            stringBuilder.append(n2 == 2 ? this._base64ToAsciiC[n >> 6 & 0x3F] : this._paddingChar);
            stringBuilder.append(this._paddingChar);
            return;
        }
        if (n2 == 2) {
            stringBuilder.append(this._base64ToAsciiC[n >> 6 & 0x3F]);
        }
    }

    public final byte encodeBase64BitsAsByte(int n) {
        return this._base64ToAsciiB[n];
    }

    public final int encodeBase64Chunk(int n, byte[] byArray, int n2) {
        byArray[n2++] = this._base64ToAsciiB[n >> 18 & 0x3F];
        byArray[n2++] = this._base64ToAsciiB[n >> 12 & 0x3F];
        byArray[n2++] = this._base64ToAsciiB[n >> 6 & 0x3F];
        byArray[n2++] = this._base64ToAsciiB[n & 0x3F];
        return n2;
    }

    public final int encodeBase64Partial(int n, int n2, byte[] byArray, int n3) {
        byArray[n3++] = this._base64ToAsciiB[n >> 18 & 0x3F];
        byArray[n3++] = this._base64ToAsciiB[n >> 12 & 0x3F];
        if (this._usesPadding) {
            byte by = (byte)this._paddingChar;
            byArray[n3++] = n2 == 2 ? this._base64ToAsciiB[n >> 6 & 0x3F] : by;
            byArray[n3++] = by;
        } else if (n2 == 2) {
            byArray[n3++] = this._base64ToAsciiB[n >> 6 & 0x3F];
        }
        return n3;
    }

    public final String encode(byte[] byArray) {
        return this.encode(byArray, false);
    }

    public final String encode(byte[] byArray, boolean bl) {
        int n;
        int n2 = byArray.length;
        int n3 = n2 + (n2 >> 2) + (n2 >> 3);
        StringBuilder stringBuilder = new StringBuilder(n3);
        if (bl) {
            stringBuilder.append('\"');
        }
        n3 = this.getMaxLineLength() >> 2;
        int n4 = 0;
        int n5 = n2 - 3;
        while (n4 <= n5) {
            n = (byArray[n4++] << 8 | byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
            this.encodeBase64Chunk(stringBuilder, n);
            if (--n3 > 0) continue;
            stringBuilder.append('\\');
            stringBuilder.append('n');
            n3 = this.getMaxLineLength() >> 2;
        }
        n = n2 - n4;
        if (n > 0) {
            n2 = byArray[n4++] << 16;
            if (n == 2) {
                n2 |= (byArray[n4] & 0xFF) << 8;
            }
            this.encodeBase64Partial(stringBuilder, n2, n);
        }
        if (bl) {
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    public final byte[] decode(String string) {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder();
        this.decode(string, byteArrayBuilder);
        return byteArrayBuilder.toByteArray();
    }

    public final void decode(String string, ByteArrayBuilder byteArrayBuilder) {
        int n = 0;
        int n2 = string.length();
        block0: while (n < n2) {
            char c2;
            do {
                c2 = string.charAt(n++);
                if (n >= n2) break block0;
            } while (c2 <= ' ');
            int n3 = this.decodeBase64Char(c2);
            if (n3 < 0) {
                this._reportInvalidBase64(c2, 0, null);
            }
            int n4 = n3;
            if (n >= n2) {
                this._reportBase64EOF();
            }
            if ((n3 = this.decodeBase64Char(c2 = string.charAt(n++))) < 0) {
                this._reportInvalidBase64(c2, 1, null);
            }
            n4 = n4 << 6 | n3;
            if (n >= n2) {
                if (!this.usesPadding()) {
                    byteArrayBuilder.append(n4 >>= 4);
                    return;
                }
                this._reportBase64EOF();
            }
            if ((n3 = this.decodeBase64Char(c2 = string.charAt(n++))) < 0) {
                if (n3 != -2) {
                    this._reportInvalidBase64(c2, 2, null);
                }
                if (n >= n2) {
                    this._reportBase64EOF();
                }
                if (!this.usesPaddingChar(c2 = string.charAt(n++))) {
                    this._reportInvalidBase64(c2, 3, "expected padding character '" + this.getPaddingChar() + "'");
                }
                byteArrayBuilder.append(n4 >>= 4);
                continue;
            }
            n4 = n4 << 6 | n3;
            if (n >= n2) {
                if (!this.usesPadding()) {
                    byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                    return;
                }
                this._reportBase64EOF();
            }
            if ((n3 = this.decodeBase64Char(c2 = string.charAt(n++))) < 0) {
                if (n3 != -2) {
                    this._reportInvalidBase64(c2, 3, null);
                }
                byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                continue;
            }
            n4 = n4 << 6 | n3;
            byteArrayBuilder.appendThreeBytes(n4);
        }
    }

    public final String toString() {
        return this._name;
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return this._name.hashCode();
    }

    protected final void _reportInvalidBase64(char c2, int n, String string) {
        String string2 = c2 <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(c2) + ") as character #" + (n + 1) + " of 4-char base64 unit: can only used between units" : (this.usesPaddingChar(c2) ? "Unexpected padding character ('" + this.getPaddingChar() + "') as character #" + (n + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(c2) || Character.isISOControl(c2) ? "Illegal character (code 0x" + Integer.toHexString(c2) + ") in base64 content" : "Illegal character '" + c2 + "' (code 0x" + Integer.toHexString(c2) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        throw new IllegalArgumentException(string2);
    }

    protected final void _reportBase64EOF() {
        throw new IllegalArgumentException("Unexpected end-of-String in base64 content");
    }
}

