/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin;

import com.gradle.scan.plugin.BuildScanException;
import com.gradle.scan.plugin.UnsupportedGradleVersionException;
import com.gradle.scan.plugin.internal.a.d.a;
import com.gradle.scan.plugin.internal.a.d.b;
import com.gradle.scan.plugin.internal.api.h;
import com.gradle.scan.plugin.internal.b;
import com.gradle.scan.plugin.internal.c;
import com.gradle.scan.plugin.internal.e.f;
import com.gradle.scan.plugin.internal.e.g;
import com.gradle.scan.plugin.internal.g.f;
import com.gradle.scan.plugin.internal.i.d;
import com.gradle.scan.plugin.internal.i.e;
import com.gradle.scan.plugin.internal.i.i;
import com.gradle.scan.plugin.internal.j;
import com.gradle.scan.plugin.internal.k;
import com.gradle.scan.plugin.internal.l;
import com.gradle.scan.plugin.internal.meta.CurrentPluginVersion;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.specs.Specs;

public final class BuildScanPlugin
implements Plugin<Project> {
    public static final String a = "buildScan";
    public static final String b = "buildScanPublishPrevious";
    public static final String c = "A build scan will not be published due to this build running offline.";
    private static final String d = "scan.publishKey";
    private static final String e = "scan.dump";
    private static final String f = "scan.quiet";
    private static final String g = "scan.quiet.error";

    public void apply(@Nonnull Project project) {
        com.gradle.scan.plugin.internal.a.t.b userDataCapturer;
        com.gradle.scan.plugin.internal.a.t.d userDataExclusionTracker;
        Gradle gradle = project.getGradle();
        boolean isTopLevelBuild = gradle.getParent() == null;
        com.gradle.scan.plugin.internal.l.a gradleVersion = com.gradle.scan.plugin.internal.l.a.a(gradle.getGradleVersion());
        com.gradle.scan.plugin.internal.l.c pluginVersion = com.gradle.scan.plugin.internal.l.c.a(CurrentPluginVersion.get());
        k.a();
        BuildScanPlugin.b(project);
        BuildScanPlugin.c(project);
        BuildScanPlugin.a(gradleVersion);
        if (BuildScanPlugin.a(project)) {
            return;
        }
        com.gradle.scan.plugin.internal.a.j.a memoryMonitor = com.gradle.scan.plugin.internal.a.j.a.a();
        j problemReporter = j.a(gradle, gradleVersion);
        com.gradle.scan.plugin.internal.a.h.b systemInfo = com.gradle.scan.plugin.internal.a.h.b.g();
        com.gradle.scan.plugin.internal.a.g.a fileRefFactory = com.gradle.scan.plugin.internal.a.g.a.a(gradle);
        com.gradle.scan.plugin.internal.g.c loggingClassProvider = com.gradle.scan.plugin.internal.g.c.a(gradle, gradleVersion);
        final com.gradle.scan.plugin.internal.g.d logging = BuildScanPlugin.a(gradle, project, loggingClassProvider, problemReporter);
        com.gradle.scan.plugin.internal.b.b checkInResult = com.gradle.scan.plugin.internal.b.a.a(gradle, gradleVersion, pluginVersion, isTopLevelBuild);
        com.gradle.scan.plugin.internal.k.a scanRequest = isTopLevelBuild ? com.gradle.scan.plugin.internal.k.a.a(gradle, gradleVersion, checkInResult, problemReporter) : null;
        boolean recording = isTopLevelBuild && BuildScanPlugin.a(project, gradleVersion, pluginVersion, checkInResult, problemReporter);
        com.gradle.scan.plugin.internal.d.b eventSink = null;
        if (recording) {
            eventSink = BuildScanPlugin.a(project.getGradle(), gradleVersion, pluginVersion);
            userDataExclusionTracker = new com.gradle.scan.plugin.internal.a.t.a(problemReporter);
            userDataCapturer = com.gradle.scan.plugin.internal.a.t.c.a(eventSink, userDataExclusionTracker);
        } else {
            userDataCapturer = com.gradle.scan.plugin.internal.a.t.c.a();
            userDataExclusionTracker = com.gradle.scan.plugin.internal.a.t.d.a;
        }
        final c buildFinishedWatcher = new c();
        com.gradle.scan.plugin.internal.api.b buildFinishedActions = new com.gradle.scan.plugin.internal.api.b(problemReporter);
        com.gradle.scan.plugin.internal.api.d buildScanPublishedActions = new com.gradle.scan.plugin.internal.api.d(problemReporter);
        com.gradle.scan.plugin.internal.api.c buildScanErrorActions = new com.gradle.scan.plugin.internal.api.c(problemReporter);
        final com.gradle.scan.plugin.internal.api.k termsOfServiceAgreement = com.gradle.scan.plugin.internal.api.k.a(gradle, gradleVersion, logging);
        final com.gradle.scan.plugin.internal.api.e buildScanServer = new com.gradle.scan.plugin.internal.api.e();
        com.gradle.scan.plugin.internal.api.j publishKey = new com.gradle.scan.plugin.internal.api.j(systemInfo.a(d));
        final com.gradle.scan.plugin.internal.api.i publishArbiter = new com.gradle.scan.plugin.internal.api.i();
        com.gradle.scan.plugin.internal.api.f rawExtension = new com.gradle.scan.plugin.internal.api.f(userDataCapturer, buildFinishedActions, buildScanPublishedActions, buildScanErrorActions, termsOfServiceAgreement, buildScanServer, publishKey, publishArbiter);
        final h extensionController = new h(rawExtension, problemReporter);
        project.getExtensions().create(a, com.gradle.scan.plugin.internal.api.g.class, new Object[]{extensionController.a});
        com.gradle.scan.plugin.internal.d.b.a store = new com.gradle.scan.plugin.internal.d.b.a(BuildScanPlugin.b(gradle, pluginVersion));
        com.gradle.scan.plugin.internal.c.a dumpController = new com.gradle.scan.plugin.internal.c.a(project.getRootDir(), logging, gradleVersion, pluginVersion);
        e rawController = com.gradle.scan.plugin.internal.i.b.a(logging, buildScanServer, gradleVersion, pluginVersion, publishKey);
        i publishController = new i(rawController, new i.a(){

            @Override
            public boolean a() {
                return BuildScanPlugin.b(termsOfServiceAgreement, buildScanServer, logging);
            }
        });
        final com.gradle.scan.plugin.internal.i.a publishPreviousTask = BuildScanPlugin.a(project, store, dumpController, publishController, buildScanPublishedActions, problemReporter);
        gradle.getTaskGraph().addTaskExecutionGraphListener(new TaskExecutionGraphListener(){

            public void graphPopulated(@Nonnull TaskExecutionGraph taskExecutionGraph) {
                if (taskExecutionGraph.hasTask((Task)publishPreviousTask)) {
                    publishArbiter.a();
                }
            }
        });
        if (recording) {
            com.gradle.scan.plugin.internal.a.f.a exceptionSerializer = new com.gradle.scan.plugin.internal.a.f.a(gradleVersion);
            BuildScanPlugin.a(scanRequest, publishArbiter);
            this.a(project, gradleVersion, problemReporter, systemInfo, fileRefFactory, eventSink, store, userDataCapturer, userDataExclusionTracker, memoryMonitor, buildFinishedWatcher, buildFinishedActions, buildScanPublishedActions, buildScanErrorActions, dumpController, publishController, publishArbiter, extensionController, loggingClassProvider, logging, exceptionSerializer);
        } else {
            gradle.addBuildListener((BuildListener)new BuildAdapter(){

                public void buildFinished(BuildResult result) {
                    extensionController.a();
                    buildFinishedWatcher.a();
                }
            });
        }
    }

    private static boolean a(Project project) {
        for (Plugin plugin : project.getPlugins()) {
            if (!plugin.getClass().getName().equals(BuildScanPlugin.class.getName())) continue;
            return true;
        }
        return false;
    }

    private static com.gradle.scan.plugin.internal.g.d a(Gradle gradle, Project project, com.gradle.scan.plugin.internal.g.c loggingClassProvider, j problemReporter) {
        if (BuildScanPlugin.b(f, project, problemReporter)) {
            return new com.gradle.scan.plugin.internal.g.e();
        }
        boolean suppressError = BuildScanPlugin.b(g, project, problemReporter);
        return new com.gradle.scan.plugin.internal.g.a(com.gradle.scan.plugin.internal.g.b.a(loggingClassProvider, gradle), !suppressError);
    }

    private static boolean a(Project project, com.gradle.scan.plugin.internal.l.a gradleVersion, com.gradle.scan.plugin.internal.l.c pluginVersion, com.gradle.scan.plugin.internal.b.b checkInResult, j problemReporter) {
        Gradle gradle = project.getGradle();
        if (BuildScanPlugin.a(checkInResult)) {
            problemReporter.a(l.a("Build scan data will not be captured due to version " + pluginVersion.b() + " of the build scan plugin being incompatible with Gradle " + gradleVersion.a() + ".", "Please refer to https://gradle.com/scans/help/plugin-version-compatibility."));
            return false;
        }
        if (BuildScanPlugin.a(gradle, gradleVersion)) {
            problemReporter.a("Build scan data will not be captured due to this build being part of a Continuous Build.");
            return false;
        }
        if (BuildScanPlugin.b(gradle, gradleVersion) && gradleVersion.b(com.gradle.scan.plugin.internal.l.b.q)) {
            problemReporter.a("Build scan data will not be captured due to this build being a Composite Build (composite build support requires Gradle 4.5 or later).");
            return false;
        }
        if (BuildScanPlugin.a(checkInResult, gradleVersion)) {
            problemReporter.a("Build scan data will not be captured due to this build containing VCS mappings.");
            return false;
        }
        return true;
    }

    private static void a(com.gradle.scan.plugin.internal.k.a scanRequest, com.gradle.scan.plugin.internal.api.i publishArbiter) {
        switch (scanRequest) {
            case ENABLED: {
                publishArbiter.b();
                break;
            }
            case DISABLED: {
                publishArbiter.d();
            }
        }
    }

    private static boolean a(Gradle gradle, com.gradle.scan.plugin.internal.l.a gradleVersion) {
        if (gradleVersion.a(com.gradle.scan.plugin.internal.l.b.c)) {
            return gradle.getStartParameter().isContinuous();
        }
        return false;
    }

    private static boolean b(Gradle gradle, com.gradle.scan.plugin.internal.l.a gradleVersion) {
        if (gradleVersion.a(com.gradle.scan.plugin.internal.l.b.g)) {
            Collection includedBuilds = gradle.getIncludedBuilds();
            return includedBuilds != null && !includedBuilds.isEmpty();
        }
        return false;
    }

    private static boolean a(com.gradle.scan.plugin.internal.b.b checkInResult, com.gradle.scan.plugin.internal.l.a gradleVersion) {
        return gradleVersion.a(com.gradle.scan.plugin.internal.l.b.p) && checkInResult.d();
    }

    private static com.gradle.scan.plugin.internal.d.b a(Gradle gradle, com.gradle.scan.plugin.internal.l.a gradleVersion, com.gradle.scan.plugin.internal.l.c pluginVersion) {
        com.gradle.scan.plugin.internal.d.c.a spooler;
        try {
            spooler = BuildScanPlugin.a(gradle, pluginVersion);
        }
        catch (IOException e2) {
            throw new BuildScanException("Failed to create build scan data file.", e2);
        }
        com.gradle.scan.plugin.internal.d.a.a eventClock = com.gradle.scan.plugin.internal.d.a.b.a(gradle, gradleVersion);
        return new com.gradle.scan.plugin.internal.d.b(eventClock, spooler);
    }

    private static com.gradle.scan.plugin.internal.d.c.a a(Gradle gradle, com.gradle.scan.plugin.internal.l.c pluginVersion) throws IOException {
        String id = UUID.randomUUID().toString();
        File scanFile = new File(BuildScanPlugin.b(gradle, pluginVersion), String.format("spool/%s.scan", id));
        return new com.gradle.scan.plugin.internal.d.c.c(scanFile);
    }

    private static File b(Gradle gradle, com.gradle.scan.plugin.internal.l.c pluginVersion) {
        return new File(gradle.getGradleUserHomeDir(), "build-scan-data/" + pluginVersion.a().b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Project project, com.gradle.scan.plugin.internal.l.a gradleVersion, j problemReporter, com.gradle.scan.plugin.internal.a.h.b systemInfo, com.gradle.scan.plugin.internal.a.g.a fileRefFactory, com.gradle.scan.plugin.internal.d.b eventSink, com.gradle.scan.plugin.internal.d.b.b store, com.gradle.scan.plugin.internal.a.t.b userDataCapturer, com.gradle.scan.plugin.internal.a.t.d userDataExclusionTracker, com.gradle.scan.plugin.internal.a.j.a memoryMonitor, c buildFinishedWatcher, com.gradle.scan.plugin.internal.api.b buildFinishedActions, com.gradle.scan.plugin.internal.api.d buildScanPublishedActions, com.gradle.scan.plugin.internal.api.c buildScanErrorActions, com.gradle.scan.plugin.internal.c.b dumpController, e publishController, com.gradle.scan.plugin.internal.api.i publishArbiter, h extensionController, com.gradle.scan.plugin.internal.g.c loggingClassProvider, com.gradle.scan.plugin.internal.g.f styledLogger, com.gradle.scan.plugin.internal.a.f.a exceptionSerializer) {
        com.gradle.scan.plugin.internal.a.m.a.e pluginMetadataExtractor = com.gradle.scan.plugin.internal.a.m.a.e.a(project, gradleVersion);
        com.gradle.scan.plugin.internal.d buildScanPluginsTracker = new com.gradle.scan.plugin.internal.d(pluginMetadataExtractor);
        com.gradle.scan.plugin.internal.a appliedPlugins = com.gradle.scan.plugin.internal.a.a(project, gradleVersion);
        com.gradle.scan.plugin.internal.a.e.j configurationResolutionDataStore = new com.gradle.scan.plugin.internal.a.e.j(gradleVersion);
        try {
            this.a(project, gradleVersion, systemInfo, fileRefFactory, eventSink, userDataCapturer, buildFinishedWatcher, pluginMetadataExtractor, buildScanPluginsTracker, configurationResolutionDataStore, loggingClassProvider, problemReporter, exceptionSerializer);
        }
        finally {
            this.a(project, gradleVersion, problemReporter, eventSink, store, memoryMonitor, userDataExclusionTracker, buildFinishedWatcher, buildFinishedActions, buildScanPublishedActions, buildScanErrorActions, dumpController, publishController, publishArbiter, extensionController, appliedPlugins, buildScanPluginsTracker, configurationResolutionDataStore, styledLogger, exceptionSerializer);
        }
    }

    private void a(final Project project, final com.gradle.scan.plugin.internal.l.a gradleVersion, final com.gradle.scan.plugin.internal.a.h.b systemInfo, final com.gradle.scan.plugin.internal.a.g.a fileRefFactory, final com.gradle.scan.plugin.internal.d.b eventSink, final com.gradle.scan.plugin.internal.a.t.b userDataCapturer, final c buildFinishedWatcher, final com.gradle.scan.plugin.internal.a.m.a.e pluginMetadataExtractor, final com.gradle.scan.plugin.internal.d buildScanPluginsTracker, final com.gradle.scan.plugin.internal.a.e.j configurationResolutionDataStore, final com.gradle.scan.plugin.internal.g.c loggingClassProvider, final j problemReporter, final com.gradle.scan.plugin.internal.a.f.a exceptionSerializer) {
        final Gradle gradle = project.getGradle();
        com.gradle.scan.plugin.internal.d.a.a eventClock = eventSink.a();
        final com.gradle.scan.plugin.internal.d.a.h buildStartTime = com.gradle.scan.plugin.internal.a.c.a.a(gradle, gradleVersion, eventClock);
        com.gradle.scan.plugin.internal.h.f.a(eventSink, gradle, gradleVersion, (Action<? super com.gradle.scan.plugin.internal.h.e>)new Action<com.gradle.scan.plugin.internal.h.e>(){

            public void a(@Nonnull com.gradle.scan.plugin.internal.h.e operations) {
                f taskIdStore = BuildScanPlugin.b();
                b daemonScanInfoService = com.gradle.scan.plugin.internal.a.d.b.a(gradleVersion, gradle, gradle.getClass().getClassLoader());
                com.gradle.scan.plugin.internal.f.a.a(eventSink, gradleVersion, problemReporter, operations);
                com.gradle.scan.plugin.internal.a.g.b.a(eventSink, buildStartTime, fileRefFactory.a());
                com.gradle.scan.plugin.internal.a.h.a.a(eventSink, buildStartTime, project, systemInfo, daemonScanInfoService, gradleVersion);
                com.gradle.scan.plugin.internal.a.o.a.a(eventSink, buildStartTime, project, fileRefFactory, gradleVersion, operations);
                com.gradle.scan.plugin.internal.a.d.a.a(eventSink, buildStartTime, daemonScanInfoService);
                com.gradle.scan.plugin.internal.a.p.a.a(eventSink, buildStartTime, gradle, gradleVersion);
                com.gradle.scan.plugin.internal.a.i.a.a(eventSink, gradle);
                com.gradle.scan.plugin.internal.a.h.c.a(systemInfo.b(), userDataCapturer);
                com.gradle.scan.plugin.internal.a.k.a.a(eventSink, gradle, gradleVersion, operations, buildFinishedWatcher, exceptionSerializer);
                com.gradle.scan.plugin.internal.a.r.d.a(eventSink, gradleVersion, operations);
                com.gradle.scan.plugin.internal.a.r.a.a(eventSink, gradle, gradleVersion, taskIdStore, operations);
                com.gradle.scan.plugin.internal.a.r.j.a(eventSink, gradleVersion, operations);
                com.gradle.scan.plugin.internal.a.s.f.a(eventSink, gradle, gradleVersion, taskIdStore, operations, exceptionSerializer);
                com.gradle.scan.plugin.internal.a.l.a.a(eventSink, gradle, loggingClassProvider, buildFinishedWatcher, exceptionSerializer);
                com.gradle.scan.plugin.internal.a.a.a.a(eventSink, project, gradleVersion, operations);
                com.gradle.scan.plugin.internal.a.m.a.a(eventSink, project, gradleVersion, pluginMetadataExtractor, buildScanPluginsTracker, BuildScanPlugin.this, operations);
                com.gradle.scan.plugin.internal.a.q.a.a(eventSink, gradleVersion, fileRefFactory, operations);
                com.gradle.scan.plugin.internal.a.n.a.a(eventSink, gradle, gradleVersion, operations, exceptionSerializer);
                com.gradle.scan.plugin.internal.a.e.f.a(eventSink, project, gradleVersion, configurationResolutionDataStore, operations, exceptionSerializer);
                com.gradle.scan.plugin.internal.a.b.c.a(eventSink, gradleVersion, operations);
                com.gradle.scan.plugin.internal.a.b.a.a(eventSink, gradleVersion, operations, exceptionSerializer);
            }

            public /* synthetic */ void execute(@Nonnull Object object) {
                this.a((com.gradle.scan.plugin.internal.h.e)object);
            }
        });
    }

    private static f<com.gradle.scan.plugin.internal.a.r.l, Long> b() {
        return com.gradle.scan.plugin.internal.e.g.a(com.gradle.scan.plugin.internal.e.a.a(com.gradle.scan.plugin.internal.a.r.h.a));
    }

    private void a(final Project project, final com.gradle.scan.plugin.internal.l.a gradleVersion, final j problemReporter, final com.gradle.scan.plugin.internal.d.b eventSink, final com.gradle.scan.plugin.internal.d.b.b store, final com.gradle.scan.plugin.internal.a.j.a memoryMonitor, final com.gradle.scan.plugin.internal.a.t.d userDataExclusionTracker, final c buildFinishedWatcher, final com.gradle.scan.plugin.internal.api.b buildFinishedActions, final com.gradle.scan.plugin.internal.api.d buildScanPublishedActions, final com.gradle.scan.plugin.internal.api.c buildScanErrorActions, final com.gradle.scan.plugin.internal.c.b dumpController, final e publishController, final com.gradle.scan.plugin.internal.api.i publishArbiter, final h extensionController, final com.gradle.scan.plugin.internal.a appliedPlugins, final com.gradle.scan.plugin.internal.d buildScanPluginsTracker, final com.gradle.scan.plugin.internal.a.e.j configurationResolutionDataStore, final com.gradle.scan.plugin.internal.g.f styledLogger, final com.gradle.scan.plugin.internal.a.f.a exceptionSerializer) {
        final Gradle gradle = project.getGradle();
        gradle.addBuildListener((BuildListener)new BuildAdapter(){

            public void buildFinished(BuildResult result) {
                buildFinishedActions.a(new com.gradle.scan.plugin.internal.f(result.getFailure()));
                long buildFinishedTimestamp = eventSink.a().a().a;
                extensionController.a();
                if (eventSink.e()) {
                    publishArbiter.a();
                }
                if (!publishArbiter.e()) {
                    if (BuildScanPlugin.b(result, gradleVersion)) {
                        if (gradle.getStartParameter().isOffline()) {
                            problemReporter.a(BuildScanPlugin.c);
                            publishArbiter.d();
                        }
                    } else {
                        publishArbiter.a();
                    }
                }
                if (!publishArbiter.e()) {
                    com.gradle.scan.plugin.internal.a.e.i.a(eventSink, configurationResolutionDataStore);
                    com.gradle.scan.plugin.internal.a.a.a(eventSink, result, memoryMonitor, exceptionSerializer);
                    BuildScanPlugin.b(appliedPlugins, problemReporter, gradleVersion);
                    BuildScanPlugin.b(buildScanPluginsTracker, problemReporter);
                    userDataExclusionTracker.a();
                }
                buildFinishedWatcher.a();
                if (!eventSink.c()) {
                    com.gradle.scan.plugin.internal.d.c.b spooling = eventSink.d();
                    if (publishArbiter.e()) {
                        BuildScanPlugin.b(spooling.c());
                    } else {
                        boolean shouldPromote = true;
                        if (BuildScanPlugin.b(BuildScanPlugin.e, project, problemReporter)) {
                            dumpController.a(buildFinishedTimestamp, spooling.c());
                        } else if (publishArbiter.a(result)) {
                            com.gradle.scan.plugin.internal.i.g publishResult = publishController.a(spooling);
                            if (publishResult.b()) {
                                shouldPromote = false;
                                buildScanPublishedActions.a(publishResult.a);
                            } else if (publishResult.c()) {
                                String errorMessage;
                                try {
                                    errorMessage = publishResult.b.a();
                                }
                                catch (IOException e2) {
                                    errorMessage = e2.getMessage();
                                }
                                buildScanErrorActions.a(errorMessage);
                            }
                            styledLogger.a("");
                        }
                        if (shouldPromote) {
                            BuildScanPlugin.b(buildFinishedTimestamp, spooling.c(), store);
                        }
                    }
                }
            }
        });
    }

    private static void b(com.gradle.scan.plugin.internal.d.e events) {
        if (events != null) {
            try {
                events.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void b(long timestamp, com.gradle.scan.plugin.internal.d.e events, com.gradle.scan.plugin.internal.d.b.b store) {
        if (events != null) {
            try {
                store.a(timestamp, events);
                events.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean b(BuildResult result, com.gradle.scan.plugin.internal.l.a gradleVersion) {
        if (gradleVersion.a(com.gradle.scan.plugin.internal.l.b.e)) {
            return result.getAction().toUpperCase().equals("BUILD");
        }
        return true;
    }

    private static boolean b(com.gradle.scan.plugin.internal.api.k termsOfServiceAgreement, com.gradle.scan.plugin.internal.api.e buildScanServer, com.gradle.scan.plugin.internal.g.f logger) {
        String errorMsg = buildScanServer.a();
        if (errorMsg == null && buildScanServer.e()) {
            termsOfServiceAgreement.b();
            errorMsg = termsOfServiceAgreement.a();
        }
        if (errorMsg == null) {
            return true;
        }
        logger.a("");
        logger.a(f.a.Failure, "The build scan was not published due to a configuration problem.");
        logger.a("");
        logger.a(errorMsg);
        return false;
    }

    private static com.gradle.scan.plugin.internal.i.a a(Project project, com.gradle.scan.plugin.internal.d.b.b store, com.gradle.scan.plugin.internal.c.b dumpController, e publishController, com.gradle.scan.plugin.internal.api.d buildScanPublishedActions, j problemReporter) {
        com.gradle.scan.plugin.internal.i previousBuildHandler = BuildScanPlugin.b(e, project, problemReporter) ? new com.gradle.scan.plugin.internal.c.c(store, dumpController) : new d(store, publishController, buildScanPublishedActions);
        com.gradle.scan.plugin.internal.i.a task = (com.gradle.scan.plugin.internal.i.a)project.getTasks().create(b, com.gradle.scan.plugin.internal.i.a.class);
        task.setGroup("Build scan");
        task.setDescription("Publishes the data captured by the last build to the build scan server.");
        task.getOutputs().upToDateWhen(Specs.SATISFIES_NONE);
        task.getExtensions().add(com.gradle.scan.plugin.internal.i.class.getName(), (Object)previousBuildHandler);
        return task;
    }

    private static boolean b(String propName, Project project, j problemReporter) {
        return BuildScanPlugin.c((String)propName, (Project)project, (j)problemReporter).c.a();
    }

    private static com.gradle.scan.plugin.internal.b c(String propName, Project project, j problemReporter) {
        Map sysPropsArgs = project.getGradle().getStartParameter().getSystemPropertiesArgs();
        com.gradle.scan.plugin.internal.b sysPropFlag = com.gradle.scan.plugin.internal.b.a(propName, sysPropsArgs);
        if (sysPropFlag.c == b.a.VALUE_UNRECOGNIZED) {
            problemReporter.a(String.format("Unrecognized value of '%s' system property: %s.\n", sysPropFlag.a, sysPropFlag.b));
        }
        return sysPropFlag;
    }

    private static void b(Project project) {
        if (!project.equals(project.getRootProject())) {
            throw new BuildScanException("The build scan plugin can only be applied to the root project.");
        }
    }

    private static void c(Project rootProject) {
        if (rootProject.getState().getExecuted()) {
            throw new BuildScanException(l.a("The build scan plugin must be applied early in the build lifecycle.", "Fixing this problem requires changing how you are applying the build scan plugin to your build.", "", "Please see https://gradle.com/scans/help/plugin-late-apply for how to resolve this problem."));
        }
    }

    private static void a(com.gradle.scan.plugin.internal.l.a gradleVersion) {
        if (!gradleVersion.a(com.gradle.scan.plugin.internal.l.b.a)) {
            throw new UnsupportedGradleVersionException(l.a("The build scan plugin requires Gradle 2.0 or later.", "You are currently using Gradle " + gradleVersion.a() + ".", "Please upgrade to a later version of Gradle (see: https://gradle.org/download)."));
        }
    }

    private static boolean a(com.gradle.scan.plugin.internal.b.b checkInResult) {
        return checkInResult.c() != null;
    }

    private static void b(com.gradle.scan.plugin.internal.a appliedPlugins, j problemReporter, com.gradle.scan.plugin.internal.l.a gradleVersion) {
        if (!gradleVersion.a(com.gradle.scan.plugin.internal.l.b.o) && appliedPlugins.a()) {
            problemReporter.a(l.a("", "WARNING: The build scan plugin was applied after other plugins.", "The captured data is more comprehensive when the build scan plugin is applied first.", "", "Please see https://gradle.com/scans/help/plugin-late-apply for how to resolve this problem."));
        }
    }

    private static void b(com.gradle.scan.plugin.internal.d tracker, j problemReporter) {
        Set<String> allVersions = tracker.a();
        if (allVersions.size() > 1) {
            problemReporter.a(l.a("", "WARNING: Several versions of the build scan plugin were applied: [" + l.b(allVersions, ", ") + "].", "The build scan data was captured by version [" + tracker.b() + "].", "This is often caused by multiple init scripts and/or build scripts applying the plugin."));
        }
    }
}

