/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.CharTypes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.CharacterEscapes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberOutput;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.JsonGeneratorImpl;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.JsonWriteContext;
import java.io.InputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class WriterBasedJsonGenerator
extends JsonGeneratorImpl {
    protected static final int SHORT_WRITE = 32;
    protected static final char[] HEX_CHARS = CharTypes.copyHexChars();
    protected final Writer _writer;
    protected char[] _outputBuffer;
    protected int _outputHead = 0;
    protected int _outputTail = 0;
    protected int _outputEnd;
    protected char[] _entityBuffer;
    protected SerializableString _currentEscape;

    public WriterBasedJsonGenerator(IOContext iOContext, int n, ObjectCodec objectCodec, Writer writer) {
        super(iOContext, n, objectCodec);
        this._writer = writer;
        this._outputBuffer = iOContext.allocConcatBuffer();
        this._outputEnd = this._outputBuffer.length;
    }

    @Override
    public final Object getOutputTarget() {
        return this._writer;
    }

    @Override
    public final int getOutputBuffered() {
        int n = this._outputTail - this._outputHead;
        return Math.max(0, n);
    }

    @Override
    public final void writeFieldName(String string) {
        int n = this._writeContext.writeFieldName(string);
        if (n == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string, n == 1);
    }

    @Override
    public final void writeFieldName(SerializableString serializableString) {
        int n = this._writeContext.writeFieldName(serializableString.getValue());
        if (n == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString, n == 1);
    }

    @Override
    public final void writeStartArray() {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 91;
    }

    @Override
    public final void writeEndArray() {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndArray(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 93;
        }
        this._writeContext = this._writeContext.getParent();
    }

    @Override
    public final void writeStartObject() {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 123;
    }

    @Override
    public final void writeEndObject() {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndObject(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 125;
        }
        this._writeContext = this._writeContext.getParent();
    }

    protected final void _writeFieldName(String string, boolean bl) {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(string, bl);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (!this.isEnabled(JsonGenerator$Feature.QUOTE_FIELD_NAMES)) {
            this._writeString(string);
            return;
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    protected final void _writeFieldName(SerializableString object, boolean bl) {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName((SerializableString)object, bl);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        object = object.asQuotedChars();
        if (!this.isEnabled(JsonGenerator$Feature.QUOTE_FIELD_NAMES)) {
            this.writeRaw((char[])object, 0, ((Object)object).length);
            return;
        }
        this._outputBuffer[this._outputTail++] = 34;
        int n = ((Object)object).length;
        if (this._outputTail + n + 1 >= this._outputEnd) {
            this.writeRaw((char[])object, 0, n);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
            return;
        }
        System.arraycopy(object, 0, this._outputBuffer, this._outputTail, n);
        this._outputTail += n;
        this._outputBuffer[this._outputTail++] = 34;
    }

    protected final void _writePPFieldName(String string, boolean bl) {
        if (bl) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this.isEnabled(JsonGenerator$Feature.QUOTE_FIELD_NAMES)) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
            this._writeString(string);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
            return;
        }
        this._writeString(string);
    }

    protected final void _writePPFieldName(SerializableString object, boolean bl) {
        if (bl) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        object = object.asQuotedChars();
        if (this.isEnabled(JsonGenerator$Feature.QUOTE_FIELD_NAMES)) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
            this.writeRaw((char[])object, 0, ((Object)object).length);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
            return;
        }
        this.writeRaw((char[])object, 0, ((Object)object).length);
    }

    @Override
    public final void writeString(String string) {
        this._verifyValueWrite("write a string");
        if (string == null) {
            this._writeNull();
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public final void writeString(char[] cArray, int n, int n2) {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(cArray, n, n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public final void writeString(SerializableString object) {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        char[] cArray = object.asQuotedChars();
        object = cArray;
        int n = cArray.length;
        if (n < 32) {
            int n2 = this._outputEnd - this._outputTail;
            if (n > n2) {
                this._flushBuffer();
            }
            System.arraycopy(object, 0, this._outputBuffer, this._outputTail, n);
            this._outputTail += n;
        } else {
            this._flushBuffer();
            this._writer.write((char[])object, 0, n);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public final void writeRawUTF8String(byte[] byArray, int n, int n2) {
        this._reportUnsupportedOperation();
    }

    @Override
    public final void writeUTF8String(byte[] byArray, int n, int n2) {
        this._reportUnsupportedOperation();
    }

    @Override
    public final void writeRaw(String string) {
        int n = string.length();
        int n2 = this._outputEnd - this._outputTail;
        if (n2 == 0) {
            this._flushBuffer();
            n2 = this._outputEnd - this._outputTail;
        }
        if (n2 >= n) {
            string.getChars(0, n, this._outputBuffer, this._outputTail);
            this._outputTail += n;
            return;
        }
        this.writeRawLong(string);
    }

    @Override
    public final void writeRaw(String string, int n, int n2) {
        int n3 = this._outputEnd - this._outputTail;
        if (n3 < n2) {
            this._flushBuffer();
            n3 = this._outputEnd - this._outputTail;
        }
        if (n3 >= n2) {
            string.getChars(n, n + n2, this._outputBuffer, this._outputTail);
            this._outputTail += n2;
            return;
        }
        this.writeRawLong(string.substring(n, n + n2));
    }

    @Override
    public final void writeRaw(SerializableString serializableString) {
        this.writeRaw(serializableString.getValue());
    }

    @Override
    public final void writeRaw(char[] cArray, int n, int n2) {
        if (n2 < 32) {
            int n3 = this._outputEnd - this._outputTail;
            if (n2 > n3) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, n, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
            return;
        }
        this._flushBuffer();
        this._writer.write(cArray, n, n2);
    }

    @Override
    public final void writeRaw(char c2) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c2;
    }

    private void writeRawLong(String string) {
        int n;
        int n2 = this._outputEnd - this._outputTail;
        string.getChars(0, n2, this._outputBuffer, this._outputTail);
        this._outputTail += n2;
        this._flushBuffer();
        int n3 = n2;
        for (n2 = string.length() - n2; n2 > this._outputEnd; n2 -= n) {
            n = this._outputEnd;
            string.getChars(n3, n3 + n, this._outputBuffer, 0);
            this._outputHead = 0;
            this._outputTail = n;
            this._flushBuffer();
            n3 += n;
        }
        string.getChars(n3, n3 + n2, this._outputBuffer, 0);
        this._outputHead = 0;
        this._outputTail = n2;
    }

    @Override
    public final void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) {
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeBinary(base64Variant, byArray, n, n + n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public final int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n) {
        int n2;
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            if (n < 0) {
                n2 = this._writeBinary(base64Variant, inputStream, byArray);
            } else {
                n2 = this._writeBinary(base64Variant, inputStream, byArray, n);
                if (n2 > 0) {
                    this._reportError("Too few bytes available: missing " + n2 + " bytes (out of " + n + ")");
                }
                n2 = n;
            }
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        return n2;
    }

    @Override
    public final void writeNumber(short s) {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedShort(s);
            return;
        }
        if (this._outputTail + 6 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputInt((int)s, this._outputBuffer, this._outputTail);
    }

    private void _writeQuotedShort(short s) {
        if (this._outputTail + 8 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputInt((int)s, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public final void writeNumber(int n) {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedInt(n);
            return;
        }
        if (this._outputTail + 11 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputInt(n, this._outputBuffer, this._outputTail);
    }

    private void _writeQuotedInt(int n) {
        if (this._outputTail + 13 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputInt(n, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public final void writeNumber(long l) {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedLong(l);
            return;
        }
        if (this._outputTail + 21 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
    }

    private void _writeQuotedLong(long l) {
        if (this._outputTail + 23 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public final void writeNumber(BigInteger bigInteger) {
        this._verifyValueWrite("write a number");
        if (bigInteger == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger.toString());
            return;
        }
        this.writeRaw(bigInteger.toString());
    }

    @Override
    public final void writeNumber(double d2) {
        if (this._cfgNumbersAsStrings || this.isEnabled(JsonGenerator$Feature.QUOTE_NON_NUMERIC_NUMBERS) && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            this.writeString(String.valueOf(d2));
            return;
        }
        this._verifyValueWrite("write a number");
        this.writeRaw(String.valueOf(d2));
    }

    @Override
    public final void writeNumber(float f2) {
        if (this._cfgNumbersAsStrings || this.isEnabled(JsonGenerator$Feature.QUOTE_NON_NUMERIC_NUMBERS) && (Float.isNaN(f2) || Float.isInfinite(f2))) {
            this.writeString(String.valueOf(f2));
            return;
        }
        this._verifyValueWrite("write a number");
        this.writeRaw(String.valueOf(f2));
    }

    @Override
    public final void writeNumber(BigDecimal object) {
        this._verifyValueWrite("write a number");
        if (object == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            object = this.isEnabled(JsonGenerator$Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? ((BigDecimal)object).toPlainString() : ((BigDecimal)object).toString();
            this._writeQuotedRaw((String)object);
            return;
        }
        if (this.isEnabled(JsonGenerator$Feature.WRITE_BIGDECIMAL_AS_PLAIN)) {
            this.writeRaw(((BigDecimal)object).toPlainString());
            return;
        }
        this.writeRaw(((BigDecimal)object).toString());
    }

    @Override
    public final void writeNumber(String string) {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string);
            return;
        }
        this.writeRaw(string);
    }

    private void _writeQuotedRaw(String string) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this.writeRaw(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public final void writeBoolean(boolean bl) {
        this._verifyValueWrite("write a boolean value");
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n = this._outputTail;
        char[] cArray = this._outputBuffer;
        if (bl) {
            cArray[n] = 116;
            cArray[++n] = 114;
            cArray[++n] = 117;
            cArray[++n] = 101;
        } else {
            cArray[n] = 102;
            cArray[++n] = 97;
            cArray[++n] = 108;
            cArray[++n] = 115;
            cArray[++n] = 101;
        }
        this._outputTail = n + 1;
    }

    @Override
    public final void writeNull() {
        this._verifyValueWrite("write a null");
        this._writeNull();
    }

    @Override
    protected final void _verifyValueWrite(String string) {
        int n;
        if (this._cfgPrettyPrinter != null) {
            this._verifyPrettyValueWrite(string);
            return;
        }
        int n2 = this._writeContext.writeValue();
        if (n2 == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
        switch (n2) {
            case 1: {
                n = 44;
                break;
            }
            case 2: {
                n = 58;
                break;
            }
            case 3: {
                if (this._rootValueSeparator != null) {
                    this.writeRaw(this._rootValueSeparator.getValue());
                }
                return;
            }
            default: {
                return;
            }
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail] = n;
        ++this._outputTail;
    }

    protected final void _verifyPrettyValueWrite(String string) {
        int n = this._writeContext.writeValue();
        if (n == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
        switch (n) {
            case 1: {
                this._cfgPrettyPrinter.writeArrayValueSeparator(this);
                return;
            }
            case 2: {
                this._cfgPrettyPrinter.writeObjectFieldValueSeparator(this);
                return;
            }
            case 3: {
                this._cfgPrettyPrinter.writeRootValueSeparator(this);
                return;
            }
            case 0: {
                if (this._writeContext.inArray()) {
                    this._cfgPrettyPrinter.beforeArrayValues(this);
                    return;
                }
                if (!this._writeContext.inObject()) break;
                this._cfgPrettyPrinter.beforeObjectEntries(this);
                return;
            }
            default: {
                this._throwInternal();
            }
        }
    }

    @Override
    public final void flush() {
        this._flushBuffer();
        if (this._writer != null && this.isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
            this._writer.flush();
        }
    }

    @Override
    public final void close() {
        super.close();
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator$Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonWriteContext jsonWriteContext;
                if ((jsonWriteContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonWriteContext.inObject()) break;
                this.writeEndObject();
            }
        }
        this._flushBuffer();
        this._outputHead = 0;
        this._outputTail = 0;
        if (this._writer != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator$Feature.AUTO_CLOSE_TARGET)) {
                this._writer.close();
            } else if (this.isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
                this._writer.flush();
            }
        }
        this._releaseBuffers();
    }

    @Override
    protected final void _releaseBuffers() {
        char[] cArray = this._outputBuffer;
        if (this._outputBuffer != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
    }

    private void _writeString(String string) {
        int n = string.length();
        if (n > this._outputEnd) {
            this._writeLongString(string);
            return;
        }
        if (this._outputTail + n > this._outputEnd) {
            this._flushBuffer();
        }
        string.getChars(0, n, this._outputBuffer, this._outputTail);
        if (this._characterEscapes != null) {
            this._writeStringCustom(n);
            return;
        }
        if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(n, this._maximumNonEscapedChar);
            return;
        }
        this._writeString2(n);
    }

    private void _writeString2(int n) {
        n = this._outputTail + n;
        int[] nArray = this._outputEscapes;
        int n2 = this._outputEscapes.length;
        block0: while (this._outputTail < n) {
            char c2;
            while ((c2 = this._outputBuffer[this._outputTail]) >= n2 || nArray[c2] == 0) {
                if (++this._outputTail >= n) break block0;
            }
            c2 = this._outputTail - this._outputHead;
            if (c2 > '\u0000') {
                this._writer.write(this._outputBuffer, this._outputHead, (int)c2);
            }
            c2 = this._outputBuffer[this._outputTail++];
            this._prependOrWriteCharacterEscape(c2, nArray[c2]);
        }
    }

    private void _writeLongString(String string) {
        int n;
        this._flushBuffer();
        int n2 = string.length();
        int n3 = 0;
        do {
            n = n3 + (n = this._outputEnd) > n2 ? n2 - n3 : n;
            string.getChars(n3, n3 + n, this._outputBuffer, 0);
            if (this._characterEscapes != null) {
                this._writeSegmentCustom(n);
                continue;
            }
            if (this._maximumNonEscapedChar != 0) {
                this._writeSegmentASCII(n, this._maximumNonEscapedChar);
                continue;
            }
            this._writeSegment(n);
        } while ((n3 += n) < n2);
    }

    private void _writeSegment(int n) {
        int[] nArray = this._outputEscapes;
        int n2 = this._outputEscapes.length;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            char c2;
            while (((c2 = this._outputBuffer[n3]) >= n2 || nArray[c2] == 0) && ++n3 < n) {
            }
            int n5 = n3 - n4;
            if (n5 > 0) {
                this._writer.write(this._outputBuffer, n4, n5);
                if (n3 >= n) break;
            }
            n4 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n3, n, c2, nArray[c2]);
        }
    }

    private void _writeString(char[] cArray, int n, int n2) {
        if (this._characterEscapes != null) {
            this._writeStringCustom(cArray, n, n2);
            return;
        }
        if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(cArray, n, n2, this._maximumNonEscapedChar);
            return;
        }
        n2 += n;
        int[] nArray = this._outputEscapes;
        int n3 = this._outputEscapes.length;
        while (n < n2) {
            int n4;
            char c2 = n;
            while (((n4 = cArray[n]) >= n3 || nArray[n4] == 0) && ++n < n2) {
            }
            n4 = n - c2;
            if (n4 < 32) {
                if (this._outputTail + n4 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n4 > 0) {
                    System.arraycopy(cArray, c2, this._outputBuffer, this._outputTail, n4);
                    this._outputTail += n4;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, (int)c2, n4);
            }
            if (n >= n2) break;
            c2 = cArray[n++];
            this._appendCharacterEscape(c2, nArray[c2]);
        }
    }

    private void _writeStringASCII(int n, int n2) {
        n = this._outputTail + n;
        int[] nArray = this._outputEscapes;
        int n3 = Math.min(this._outputEscapes.length, n2 + 1);
        while (this._outputTail < n) {
            int n4;
            char c2;
            block5: {
                do {
                    if ((c2 = this._outputBuffer[this._outputTail]) < n3) {
                        n4 = nArray[c2];
                        if (n4 == 0) continue;
                    } else {
                        if (c2 <= n2) continue;
                        n4 = -1;
                    }
                    break block5;
                } while (++this._outputTail < n);
                return;
            }
            int n5 = this._outputTail - this._outputHead;
            if (n5 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n5);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape(c2, n4);
        }
    }

    private void _writeSegmentASCII(int n, int n2) {
        int[] nArray = this._outputEscapes;
        int n3 = Math.min(this._outputEscapes.length, n2 + 1);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < n) {
            char c2;
            do {
                if ((c2 = this._outputBuffer[n4]) < n3) {
                    n5 = nArray[c2];
                    if (n5 == 0) continue;
                    break;
                }
                if (c2 <= n2) continue;
                n5 = -1;
                break;
            } while (++n4 < n);
            int n7 = n4 - n6;
            if (n7 > 0) {
                this._writer.write(this._outputBuffer, n6, n7);
                if (n4 >= n) break;
            }
            n6 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n4, n, c2, n5);
        }
    }

    private void _writeStringASCII(char[] cArray, int n, int n2, int n3) {
        n2 += n;
        int[] nArray = this._outputEscapes;
        int n4 = Math.min(this._outputEscapes.length, n3 + 1);
        int n5 = 0;
        while (n < n2) {
            char c2;
            int n6 = n;
            do {
                if ((c2 = cArray[n]) < n4) {
                    n5 = nArray[c2];
                    if (n5 == 0) continue;
                    break;
                }
                if (c2 <= n3) continue;
                n5 = -1;
                break;
            } while (++n < n2);
            int n7 = n - n6;
            if (n7 < 32) {
                if (this._outputTail + n7 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n7 > 0) {
                    System.arraycopy(cArray, n6, this._outputBuffer, this._outputTail, n7);
                    this._outputTail += n7;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n6, n7);
            }
            if (n >= n2) break;
            ++n;
            this._appendCharacterEscape(c2, n5);
        }
    }

    private void _writeStringCustom(int n) {
        n = this._outputTail + n;
        int[] nArray = this._outputEscapes;
        int n2 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        int n3 = Math.min(nArray.length, n2 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (this._outputTail < n) {
            int n4;
            int n5;
            block7: {
                do {
                    if ((n5 = this._outputBuffer[this._outputTail]) < n3) {
                        n4 = nArray[n5];
                        if (n4 == 0) continue;
                    } else if (n5 > n2) {
                        n4 = -1;
                    } else {
                        this._currentEscape = characterEscapes.getEscapeSequence(n5);
                        if (this._currentEscape == null) continue;
                        n4 = -2;
                    }
                    break block7;
                } while (++this._outputTail < n);
                return;
            }
            int n6 = this._outputTail - this._outputHead;
            if (n6 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n6);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape((char)n5, n4);
        }
    }

    private void _writeSegmentCustom(int n) {
        int[] nArray = this._outputEscapes;
        int n2 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        int n3 = Math.min(nArray.length, n2 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < n) {
            int n7;
            do {
                if ((n7 = this._outputBuffer[n4]) < n3) {
                    n5 = nArray[n7];
                    if (n5 == 0) continue;
                    break;
                }
                if (n7 > n2) {
                    n5 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(n7);
                if (this._currentEscape == null) continue;
                n5 = -2;
                break;
            } while (++n4 < n);
            int n8 = n4 - n6;
            if (n8 > 0) {
                this._writer.write(this._outputBuffer, n6, n8);
                if (n4 >= n) break;
            }
            n6 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n4, n, (char)n7, n5);
        }
    }

    private void _writeStringCustom(char[] cArray, int n, int n2) {
        n2 += n;
        int[] nArray = this._outputEscapes;
        int n3 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        int n4 = Math.min(nArray.length, n3 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n5 = 0;
        while (n < n2) {
            int n6;
            int n7 = n;
            do {
                if ((n6 = cArray[n]) < n4) {
                    n5 = nArray[n6];
                    if (n5 == 0) continue;
                    break;
                }
                if (n6 > n3) {
                    n5 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(n6);
                if (this._currentEscape == null) continue;
                n5 = -2;
                break;
            } while (++n < n2);
            int n8 = n - n7;
            if (n8 < 32) {
                if (this._outputTail + n8 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n8 > 0) {
                    System.arraycopy(cArray, n7, this._outputBuffer, this._outputTail, n8);
                    this._outputTail += n8;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n7, n8);
            }
            if (n >= n2) break;
            ++n;
            this._appendCharacterEscape((char)n6, n5);
        }
    }

    protected final void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n2 - 3;
        int n5 = this._outputEnd - 6;
        int n6 = base64Variant.getMaxLineLength() >> 2;
        while (n <= n4) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            n3 = (byArray[n++] << 8 | byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
            this._outputTail = base64Variant.encodeBase64Chunk(n3, this._outputBuffer, this._outputTail);
            if (--n6 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n6 = base64Variant.getMaxLineLength() >> 2;
        }
        n3 = n2 - n;
        if (n3 > 0) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            n2 = byArray[n++] << 16;
            if (n3 == 2) {
                n2 |= (byArray[n] & 0xFF) << 8;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n2, n3, this._outputBuffer, this._outputTail);
        }
    }

    protected final int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -3;
        int n6 = this._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (n > 2) {
            if (n3 > n5) {
                n4 = this._readMore(inputStream, byArray, n3, n4, n);
                n3 = 0;
                if (n4 < 3) break;
                n5 = n4 - 3;
            }
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n2 = (byArray[n3++] << 8 | byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
            n -= 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n2, this._outputBuffer, this._outputTail);
            if (--n7 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n > 0 && (n4 = this._readMore(inputStream, byArray, n3, n4, n)) > 0) {
            int n8;
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n2 = byArray[0] << 16;
            if (1 < n4) {
                n2 |= (byArray[1] & 0xFF) << 8;
                n8 = 2;
            } else {
                n8 = 1;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n2, n8, this._outputBuffer, this._outputTail);
            n -= n8;
        }
        return n;
    }

    protected final int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = -3;
        int n5 = 0;
        int n6 = this._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            if (n2 > n4) {
                n3 = this._readMore(inputStream, byArray, n2, n3, byArray.length);
                n2 = 0;
                if (n3 < 3) break;
                n4 = n3 - 3;
            }
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n = (byArray[n2++] << 8 | byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            n5 += 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n, this._outputBuffer, this._outputTail);
            if (--n7 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n3 > 0) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n = byArray[0] << 16;
            int n8 = 1;
            if (1 < n3) {
                n |= (byArray[1] & 0xFF) << 8;
                n8 = 2;
            }
            n5 += n8;
            this._outputTail = base64Variant.encodeBase64Partial(n, n8, this._outputBuffer, this._outputTail);
        }
        return n5;
    }

    private int _readMore(InputStream inputStream, byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n < n2) {
            byArray[n4++] = byArray[n++];
        }
        n2 = n4;
        n3 = Math.min(n3, byArray.length);
        while ((n = n3 - n2) != 0) {
            if ((n = inputStream.read(byArray, n2, n)) < 0) {
                return n2;
            }
            if ((n2 += n) < 3) continue;
        }
        return n2;
    }

    private final void _writeNull() {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n = this._outputTail;
        char[] cArray = this._outputBuffer;
        this._outputBuffer[n] = 110;
        cArray[++n] = 117;
        cArray[++n] = 108;
        cArray[++n] = 108;
        this._outputTail = n + 1;
    }

    private void _prependOrWriteCharacterEscape(char c2, int n) {
        String string;
        if (n >= 0) {
            if (this._outputTail >= 2) {
                int n2;
                this._outputHead = n2 = this._outputTail - 2;
                this._outputBuffer[n2++] = 92;
                this._outputBuffer[n2] = (char)n;
                return;
            }
            char[] cArray = this._entityBuffer;
            if (this._entityBuffer == null) {
                cArray = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            cArray[1] = (char)n;
            this._writer.write(cArray, 0, 2);
            return;
        }
        if (n != -2) {
            if (this._outputTail >= 6) {
                char[] cArray = this._outputBuffer;
                this._outputHead = n = this._outputTail - 6;
                cArray[n] = 92;
                cArray[++n] = 117;
                if (c2 > '\u00ff') {
                    int n3 = c2 >> 8 & 0xFF;
                    cArray[++n] = HEX_CHARS[n3 >> 4];
                    cArray[++n] = HEX_CHARS[n3 & 0xF];
                    c2 = (char)(c2 & 0xFF);
                } else {
                    cArray[++n] = 48;
                    cArray[++n] = 48;
                }
                cArray[++n] = HEX_CHARS[c2 >> 4];
                cArray[++n] = HEX_CHARS[c2 & 0xF];
                return;
            }
            char[] cArray = this._entityBuffer;
            if (this._entityBuffer == null) {
                cArray = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            if (c2 > '\u00ff') {
                n = c2 >> 8 & 0xFF;
                int n4 = c2 & 0xFF;
                cArray[10] = HEX_CHARS[n >> 4];
                cArray[11] = HEX_CHARS[n & 0xF];
                cArray[12] = HEX_CHARS[n4 >> 4];
                cArray[13] = HEX_CHARS[n4 & 0xF];
                this._writer.write(cArray, 8, 6);
                return;
            }
            cArray[6] = HEX_CHARS[c2 >> 4];
            cArray[7] = HEX_CHARS[c2 & 0xF];
            this._writer.write(cArray, 2, 6);
            return;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        n = string.length();
        if (this._outputTail >= n) {
            int n5;
            this._outputHead = n5 = this._outputTail - n;
            string.getChars(0, n, this._outputBuffer, n5);
            return;
        }
        this._outputHead = this._outputTail;
        this._writer.write(string);
    }

    private int _prependOrWriteCharacterEscape(char[] cArray, int n, int n2, char c2, int n3) {
        String string;
        if (n3 >= 0) {
            if (n > 1 && n < n2) {
                cArray[n -= 2] = 92;
                cArray[n + 1] = (char)n3;
            } else {
                char[] cArray2 = this._entityBuffer;
                if (this._entityBuffer == null) {
                    cArray2 = this._allocateEntityBuffer();
                }
                cArray2[1] = (char)n3;
                this._writer.write(cArray2, 0, 2);
            }
            return n;
        }
        if (n3 != -2) {
            if (n > 5 && n < n2) {
                n -= 6;
                cArray[n++] = 92;
                cArray[n++] = 117;
                if (c2 > '\u00ff') {
                    int n4 = c2 >> 8 & 0xFF;
                    cArray[n++] = HEX_CHARS[n4 >> 4];
                    cArray[n++] = HEX_CHARS[n4 & 0xF];
                    c2 = (char)(c2 & 0xFF);
                } else {
                    cArray[n++] = 48;
                    cArray[n++] = 48;
                }
                cArray[n++] = HEX_CHARS[c2 >> 4];
                cArray[n] = HEX_CHARS[c2 & 0xF];
                n -= 5;
            } else {
                char[] cArray3 = this._entityBuffer;
                if (this._entityBuffer == null) {
                    cArray3 = this._allocateEntityBuffer();
                }
                this._outputHead = this._outputTail;
                if (c2 > '\u00ff') {
                    n3 = c2 >> 8 & 0xFF;
                    int n5 = c2 & 0xFF;
                    cArray3[10] = HEX_CHARS[n3 >> 4];
                    cArray3[11] = HEX_CHARS[n3 & 0xF];
                    cArray3[12] = HEX_CHARS[n5 >> 4];
                    cArray3[13] = HEX_CHARS[n5 & 0xF];
                    this._writer.write(cArray3, 8, 6);
                } else {
                    cArray3[6] = HEX_CHARS[c2 >> 4];
                    cArray3[7] = HEX_CHARS[c2 & 0xF];
                    this._writer.write(cArray3, 2, 6);
                }
            }
            return n;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        n3 = string.length();
        if (n >= n3 && n < n2) {
            string.getChars(0, n3, cArray, n -= n3);
        } else {
            this._writer.write(string);
        }
        return n;
    }

    private void _appendCharacterEscape(char c2, int n) {
        String string;
        if (n >= 0) {
            if (this._outputTail + 2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = (char)n;
            return;
        }
        if (n != -2) {
            if (this._outputTail + 5 >= this._outputEnd) {
                this._flushBuffer();
            }
            n = this._outputTail;
            char[] cArray = this._outputBuffer;
            this._outputBuffer[n++] = 92;
            cArray[n++] = 117;
            if (c2 > '\u00ff') {
                int n2 = c2 >> 8 & 0xFF;
                cArray[n++] = HEX_CHARS[n2 >> 4];
                cArray[n++] = HEX_CHARS[n2 & 0xF];
                c2 = (char)(c2 & 0xFF);
            } else {
                cArray[n++] = 48;
                cArray[n++] = 48;
            }
            cArray[n++] = HEX_CHARS[c2 >> 4];
            cArray[n++] = HEX_CHARS[c2 & 0xF];
            this._outputTail = n;
            return;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n3 = string.length();
        if (this._outputTail + n3 > this._outputEnd) {
            this._flushBuffer();
            if (n3 > this._outputEnd) {
                this._writer.write(string);
                return;
            }
        }
        string.getChars(0, n3, this._outputBuffer, this._outputTail);
        this._outputTail += n3;
    }

    private char[] _allocateEntityBuffer() {
        char[] cArray = new char[14];
        char[] cArray2 = cArray;
        cArray[0] = 92;
        cArray2[2] = 92;
        cArray2[3] = 117;
        cArray2[4] = 48;
        cArray2[5] = 48;
        cArray2[8] = 92;
        cArray2[9] = 117;
        this._entityBuffer = cArray2;
        return cArray2;
    }

    protected final void _flushBuffer() {
        int n = this._outputTail - this._outputHead;
        if (n > 0) {
            int n2 = this._outputHead;
            this._outputHead = 0;
            this._outputTail = 0;
            this._writer.write(this._outputBuffer, n2, n);
        }
    }
}

