/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerationException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.PrettyPrinter;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Version;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.base.GeneratorBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.JsonWriteContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.PackageVersion;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileBufferRecycler;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileGenerator$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileGenerator$SharedStringNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class SmileGenerator
extends GeneratorBase {
    private static final int MIN_BUFFER_LENGTH = 770;
    protected static final byte TOKEN_BYTE_LONG_STRING_ASCII = -32;
    protected static final byte TOKEN_BYTE_INT_32 = 36;
    protected static final byte TOKEN_BYTE_INT_64 = 37;
    protected static final byte TOKEN_BYTE_BIG_INTEGER = 38;
    protected static final byte TOKEN_BYTE_FLOAT_32 = 40;
    protected static final byte TOKEN_BYTE_FLOAT_64 = 41;
    protected static final byte TOKEN_BYTE_BIG_DECIMAL = 42;
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    protected final IOContext _ioContext;
    protected final OutputStream _out;
    protected int _formatFeatures;
    protected final SmileBufferRecycler<SmileGenerator$SharedStringNode> _smileBufferRecycler;
    protected byte[] _outputBuffer;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected int _bytesWritten;
    protected SmileGenerator$SharedStringNode[] _seenNames;
    protected int _seenNameCount;
    protected SmileGenerator$SharedStringNode[] _seenStringValues;
    protected int _seenStringValueCount;
    protected boolean _bufferRecyclable;
    protected static final ThreadLocal<SoftReference<SmileBufferRecycler<SmileGenerator$SharedStringNode>>> _smileRecyclerRef = new ThreadLocal();

    public SmileGenerator(IOContext iOContext, int n2, int n3, ObjectCodec objectCodec, OutputStream outputStream) {
        super(n2, objectCodec);
        this._formatFeatures = n3;
        this._ioContext = iOContext;
        this._smileBufferRecycler = SmileGenerator._smileBufferRecycler();
        this._out = outputStream;
        this._bufferRecyclable = true;
        this._outputBuffer = iOContext.allocWriteEncodingBuffer();
        this._outputEnd = this._outputBuffer.length;
        if (this._outputEnd < 770) {
            throw new IllegalStateException("Internal encoding buffer length (" + this._outputEnd + ") too short, must be at least 770");
        }
        if ((n3 & SmileGenerator$Feature.CHECK_SHARED_NAMES.getMask()) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        } else {
            this._seenNames = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (this._seenNames == null) {
                this._seenNames = new SmileGenerator$SharedStringNode[64];
            }
            this._seenNameCount = 0;
        }
        if ((n3 & SmileGenerator$Feature.CHECK_SHARED_STRING_VALUES.getMask()) == 0) {
            this._seenStringValues = null;
            this._seenStringValueCount = -1;
            return;
        }
        this._seenStringValues = this._smileBufferRecycler.allocSeenStringValuesBuffer();
        if (this._seenStringValues == null) {
            this._seenStringValues = new SmileGenerator$SharedStringNode[64];
        }
        this._seenStringValueCount = 0;
    }

    public SmileGenerator(IOContext iOContext, int n2, int n3, ObjectCodec objectCodec, OutputStream outputStream, byte[] byArray, int n4, boolean bl) {
        super(n2, objectCodec);
        this._formatFeatures = n3;
        this._ioContext = iOContext;
        this._smileBufferRecycler = SmileGenerator._smileBufferRecycler();
        this._out = outputStream;
        this._bufferRecyclable = bl;
        this._outputTail = n4;
        this._outputBuffer = byArray;
        this._outputEnd = this._outputBuffer.length;
        if (this._outputEnd < 770) {
            throw new IllegalStateException("Internal encoding buffer length (" + this._outputEnd + ") too short, must be at least 770");
        }
        if ((n3 & SmileGenerator$Feature.CHECK_SHARED_NAMES.getMask()) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        } else {
            this._seenNames = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (this._seenNames == null) {
                this._seenNames = new SmileGenerator$SharedStringNode[64];
            }
            this._seenNameCount = 0;
        }
        if ((n3 & SmileGenerator$Feature.CHECK_SHARED_STRING_VALUES.getMask()) == 0) {
            this._seenStringValues = null;
            this._seenStringValueCount = -1;
            return;
        }
        this._seenStringValues = this._smileBufferRecycler.allocSeenStringValuesBuffer();
        if (this._seenStringValues == null) {
            this._seenStringValues = new SmileGenerator$SharedStringNode[64];
        }
        this._seenStringValueCount = 0;
    }

    public void writeHeader() {
        int n2 = 0;
        if (SmileGenerator$Feature.CHECK_SHARED_NAMES.enabledIn(this._formatFeatures)) {
            n2 = 1;
        }
        if (SmileGenerator$Feature.CHECK_SHARED_STRING_VALUES.enabledIn(this._formatFeatures)) {
            n2 |= 2;
        }
        if (!SmileGenerator$Feature.ENCODE_BINARY_AS_7BIT.enabledIn(this._formatFeatures)) {
            n2 |= 4;
        }
        this._writeBytes((byte)58, (byte)41, (byte)10, (byte)n2);
    }

    protected static final SmileBufferRecycler<SmileGenerator$SharedStringNode> _smileBufferRecycler() {
        Object object = _smileRecyclerRef.get();
        object = object == null ? null : ((SoftReference)object).get();
        if (object == null) {
            object = new SmileBufferRecycler();
            _smileRecyclerRef.set(new SoftReference(object));
        }
        return object;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean canWriteBinaryNatively() {
        return true;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this;
    }

    @Override
    public Object getOutputTarget() {
        return this._out;
    }

    @Override
    public int getOutputBuffered() {
        return this._outputTail;
    }

    @Override
    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public JsonGenerator overrideFormatFeatures(int n2, int n3) {
        this._formatFeatures = this._formatFeatures & ~n3 | n2 & n3;
        return this;
    }

    @Override
    public final void writeFieldName(String string) {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
    }

    @Override
    public final void writeFieldName(SerializableString serializableString) {
        if (this._writeContext.writeFieldName(serializableString.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString);
    }

    @Override
    public final void writeStringField(String string, String string2) {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
        this.writeString(string2);
    }

    public SmileGenerator enable(SmileGenerator$Feature smileGenerator$Feature) {
        this._formatFeatures |= smileGenerator$Feature.getMask();
        return this;
    }

    public SmileGenerator disable(SmileGenerator$Feature smileGenerator$Feature) {
        this._formatFeatures &= ~smileGenerator$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(SmileGenerator$Feature smileGenerator$Feature) {
        return (this._formatFeatures & smileGenerator$Feature.getMask()) != 0;
    }

    public SmileGenerator configure(SmileGenerator$Feature smileGenerator$Feature, boolean bl) {
        if (bl) {
            this.enable(smileGenerator$Feature);
        } else {
            this.disable(smileGenerator$Feature);
        }
        return this;
    }

    public void writeRaw(byte by) {
        this._writeByte(by);
    }

    public void writeBytes(byte[] byArray, int n2, int n3) {
        this._writeBytes(byArray, n2, n3);
    }

    @Override
    public final void writeStartArray() {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this._writeByte((byte)-8);
    }

    @Override
    public final void writeStartArray(int n2) {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this._writeByte((byte)-8);
    }

    @Override
    public final void writeEndArray() {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        this._writeByte((byte)-7);
        this._writeContext = this._writeContext.getParent();
    }

    @Override
    public final void writeStartObject() {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        this._writeByte((byte)-6);
    }

    @Override
    public final void writeEndObject() {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this._writeByte((byte)-5);
    }

    private final void _writeFieldName(String string) {
        int n2;
        int n3 = string.length();
        if (n3 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenNameCount >= 0 && (n2 = this._findSeenName(string)) >= 0) {
            this._writeSharedNameReference(n2);
            return;
        }
        if (n3 > 56) {
            this._writeNonShortFieldName(string, n3);
            return;
        }
        if (this._outputTail + 196 >= this._outputEnd) {
            this._flushBuffer();
        }
        n2 = this._outputTail++;
        int n4 = this._shortUTF8Encode(string, 0, n3);
        if (n4 == n3) {
            if (n4 <= 64) {
                n3 = (byte)(n4 + 127);
            } else {
                n3 = 52;
                this._outputBuffer[this._outputTail++] = -4;
            }
        } else if (n4 <= 56) {
            n3 = (byte)(n4 + 190);
        } else {
            n3 = 52;
            this._outputBuffer[this._outputTail++] = -4;
        }
        this._outputBuffer[n2] = n3;
        if (this._seenNameCount >= 0) {
            this._addSeenName(string);
        }
    }

    private final void _writeNonShortFieldName(String string, int n2) {
        this._writeByte((byte)52);
        int n3 = n2 + n2 + n2;
        if (n3 <= this._outputBuffer.length) {
            if (this._outputTail + n3 >= this._outputEnd) {
                this._flushBuffer();
            }
            this._shortUTF8Encode(string, 0, n2);
        } else {
            this._mediumUTF8Encode(string, 0, n2);
        }
        if (this._seenNameCount >= 0) {
            this._addSeenName(string);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    protected final void _writeFieldName(SerializableString serializableString) {
        int n2;
        int n3 = serializableString.charLength();
        if (n3 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenNameCount >= 0 && (n2 = this._findSeenName(serializableString.getValue())) >= 0) {
            this._writeSharedNameReference(n2);
            return;
        }
        byte[] byArray = serializableString.asUnquotedUTF8();
        int n4 = byArray.length;
        if (n4 != n3) {
            this._writeFieldNameUnicode(serializableString, byArray);
            return;
        }
        if (n4 <= 64) {
            if (this._outputTail + n4 >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = (byte)(n4 + 127);
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n4);
            this._outputTail += n4;
        } else {
            this._writeLongAsciiFieldName(byArray);
        }
        if (this._seenNameCount >= 0) {
            this._addSeenName(serializableString.getValue());
        }
    }

    private final void _writeLongAsciiFieldName(byte[] byArray) {
        int n2 = byArray.length;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 52;
        if (this._outputTail + n2 + 1 < this._outputEnd) {
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
        } else {
            this._flushBuffer();
            if (n2 < 770) {
                System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
                this._outputTail += n2;
            } else {
                if (this._outputTail > 0) {
                    this._flushBuffer();
                }
                this._out.write(byArray, 0, n2);
            }
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    protected final void _writeFieldNameUnicode(SerializableString serializableString, byte[] byArray) {
        int n2 = byArray.length;
        if (n2 <= 56) {
            if (this._outputTail + n2 >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = (byte)(n2 + 190);
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
            if (this._seenNameCount >= 0) {
                this._addSeenName(serializableString.getValue());
            }
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 52;
        if (this._outputTail + n2 + 1 < this._outputEnd) {
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
        } else {
            this._flushBuffer();
            if (n2 < 770) {
                System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
                this._outputTail += n2;
            } else {
                if (this._outputTail > 0) {
                    this._flushBuffer();
                }
                this._out.write(byArray, 0, n2);
            }
        }
        this._outputBuffer[this._outputTail++] = -4;
        if (this._seenNameCount >= 0) {
            this._addSeenName(serializableString.getValue());
        }
    }

    private final void _writeSharedNameReference(int n2) {
        if (n2 >= this._seenNameCount) {
            throw new IllegalArgumentException("Internal error: trying to write shared name with index " + n2 + "; but have only seen " + this._seenNameCount + " so far!");
        }
        if (n2 < 64) {
            this._writeByte((byte)(n2 + 64));
            return;
        }
        this._writeBytes((byte)(48 + (n2 >> 8)), (byte)n2);
    }

    @Override
    public void writeString(String string) {
        int n2;
        if (string == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        int n3 = string.length();
        if (n3 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (n3 > 65) {
            this._writeNonSharedString(string, n3);
            return;
        }
        if (this._seenStringValueCount >= 0 && (n2 = this._findSeenStringValue(string)) >= 0) {
            this._writeSharedStringValueReference(n2);
            return;
        }
        if (this._outputTail + 196 >= this._outputEnd) {
            this._flushBuffer();
        }
        n2 = this._outputTail++;
        int n4 = this._shortUTF8Encode(string, 0, n3);
        if (n4 <= 64) {
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(string);
            }
            if (n4 == n3) {
                this._outputBuffer[n2] = (byte)(n4 + 63);
                return;
            }
            this._outputBuffer[n2] = (byte)(n4 + 126);
            return;
        }
        this._outputBuffer[n2] = n4 == n3 ? -32 : -28;
        this._outputBuffer[this._outputTail++] = -4;
    }

    private final void _writeSharedStringValueReference(int n2) {
        if (n2 >= this._seenStringValueCount) {
            throw new IllegalArgumentException("Internal error: trying to write shared String value with index " + n2 + "; but have only seen " + this._seenStringValueCount + " so far!");
        }
        if (n2 < 31) {
            this._writeByte((byte)(n2 + 1));
            return;
        }
        this._writeBytes((byte)(236 + (n2 >> 8)), (byte)n2);
    }

    private final void _writeNonSharedString(String string, int n2) {
        int n3 = n2 + n2 + n2 + 2;
        if (n3 > this._outputBuffer.length) {
            this._writeByte((byte)-28);
            this._mediumUTF8Encode(string, 0, n2);
            this._writeByte((byte)-4);
            return;
        }
        if (this._outputTail + n3 >= this._outputEnd) {
            this._flushBuffer();
        }
        n3 = this._outputTail;
        this._writeByte((byte)-32);
        if (this._shortUTF8Encode(string, 0, n2) > n2) {
            this._outputBuffer[n3] = -28;
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) {
        if (n3 <= 65 && this._seenStringValueCount >= 0 && n3 > 0) {
            this.writeString(new String(cArray, n2, n3));
            return;
        }
        this._verifyValueWrite("write String value");
        if (n3 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (n3 <= 64) {
            int n4;
            if (this._outputTail + 196 >= this._outputEnd) {
                this._flushBuffer();
            }
            int n5 = this._outputTail++;
            int n6 = this._shortUTF8Encode(cArray, n2, n2 + n3);
            if (n6 <= 64) {
                n4 = n6 == n3 ? (int)((byte)(n6 + 63)) : (int)((byte)(n6 + 126));
            } else {
                n4 = -28;
                this._outputBuffer[this._outputTail++] = -4;
            }
            this._outputBuffer[n5] = n4;
            return;
        }
        int n7 = n3 + n3 + n3 + 2;
        if (n7 <= this._outputBuffer.length) {
            if (this._outputTail + n7 >= this._outputEnd) {
                this._flushBuffer();
            }
            int n8 = this._outputTail;
            this._writeByte((byte)-28);
            if (this._shortUTF8Encode(cArray, n2, n2 + n3) == n3) {
                this._outputBuffer[n8] = -32;
            }
            this._outputBuffer[this._outputTail++] = -4;
            return;
        }
        this._writeByte((byte)-28);
        this._mediumUTF8Encode(cArray, n2, n2 + n3);
        this._writeByte((byte)-4);
    }

    @Override
    public final void writeString(SerializableString serializableString) {
        int n2;
        this._verifyValueWrite("write String value");
        Object object = serializableString.getValue();
        int n3 = ((String)object).length();
        if (n3 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (n3 <= 65 && this._seenStringValueCount >= 0 && (n2 = this._findSeenStringValue((String)object)) >= 0) {
            this._writeSharedStringValueReference(n2);
            return;
        }
        byte[] byArray = serializableString.asUnquotedUTF8();
        object = byArray;
        int n4 = byArray.length;
        if (n4 <= 64) {
            if (this._outputTail + n4 + 1 >= this._outputEnd) {
                this._flushBuffer();
            }
            n3 = n4 == n3 ? n4 + 63 : n4 + 126;
            this._outputBuffer[this._outputTail++] = (byte)n3;
            System.arraycopy(object, 0, this._outputBuffer, this._outputTail, n4);
            this._outputTail += n4;
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(serializableString.getValue());
            }
            return;
        }
        n3 = n4 == n3 ? -32 : -28;
        this._writeByte((byte)n3);
        this._writeBytes((byte[])object, 0, ((Object)object).length);
        this._writeByte((byte)-4);
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) {
        this._verifyValueWrite("write String value");
        if (n3 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenStringValueCount >= 0) {
            throw new UnsupportedOperationException("Can not use direct UTF-8 write methods when 'Feature.CHECK_SHARED_STRING_VALUES' enabled");
        }
        if (n3 <= 65) {
            if (this._outputTail + n3 >= this._outputEnd) {
                this._flushBuffer();
            }
            if (n3 == 1) {
                this._outputBuffer[this._outputTail++] = 64;
                this._outputBuffer[this._outputTail++] = byArray[n2];
                return;
            }
            this._outputBuffer[this._outputTail++] = (byte)(n3 + 126);
            System.arraycopy(byArray, n2, this._outputBuffer, this._outputTail, n3);
            this._outputTail += n3;
            return;
        }
        int n4 = n3 + n3 + n3 + 2;
        if (n4 <= this._outputBuffer.length) {
            if (this._outputTail + n4 >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = -28;
            System.arraycopy(byArray, n2, this._outputBuffer, this._outputTail, n3);
            this._outputTail += n3;
            this._outputBuffer[this._outputTail++] = -4;
            return;
        }
        this._writeByte((byte)-28);
        this._writeBytes(byArray, n2, n3);
        this._writeByte((byte)-4);
    }

    @Override
    public final void writeUTF8String(byte[] byArray, int n2, int n3) {
        this.writeRawUTF8String(byArray, n2, n3);
    }

    @Override
    public void writeRaw(String string) {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(String string, int n2, int n3) {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(char c2) {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(String string) {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(String string, int n2, int n3) {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(char[] cArray, int n2, int n3) {
        throw this._notSupported();
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (this.isEnabled(SmileGenerator$Feature.ENCODE_BINARY_AS_7BIT)) {
            this._writeByte((byte)-24);
            this._write7BitBinaryWithLength(byArray, n2, n3);
            return;
        }
        this._writeByte((byte)-3);
        this._writePositiveVInt(n3);
        this._writeBytes(byArray, n2, n3);
    }

    @Override
    public int writeBinary(InputStream inputStream, int n2) {
        int n3;
        if (n2 < 0) {
            throw new UnsupportedOperationException("Must pass actual length for Smile encoded data");
        }
        this._verifyValueWrite("write Binary value");
        if (this.isEnabled(SmileGenerator$Feature.ENCODE_BINARY_AS_7BIT)) {
            this._writeByte((byte)-24);
            byte[] byArray = this._ioContext.allocBase64Buffer();
            try {
                n3 = this._write7BitBinaryWithLength(inputStream, n2, byArray);
            }
            finally {
                this._ioContext.releaseBase64Buffer(byArray);
            }
        } else {
            this._writeByte((byte)-3);
            this._writePositiveVInt(n2);
            n3 = this._writeBytes(inputStream, n2);
        }
        if (n3 > 0) {
            this._reportError("Too few bytes available: missing " + n3 + " bytes (out of " + n2 + ")");
        }
        return n2;
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) {
        return this.writeBinary(inputStream, n2);
    }

    @Override
    public void writeBoolean(boolean bl) {
        this._verifyValueWrite("write boolean value");
        if (bl) {
            this._writeByte((byte)35);
            return;
        }
        this._writeByte((byte)34);
    }

    @Override
    public void writeNull() {
        this._verifyValueWrite("write null value");
        this._writeByte((byte)33);
    }

    @Override
    public void writeNumber(int n2) {
        this._verifyValueWrite("write number");
        n2 = SmileUtil.zigzagEncode(n2);
        if (n2 <= 63 && n2 >= 0) {
            if (n2 <= 31) {
                this._writeByte((byte)(n2 + 192));
                return;
            }
            this._writeBytes((byte)36, (byte)(n2 + 128));
            return;
        }
        byte by = (byte)(128 + (n2 & 0x3F));
        if ((n2 >>>= 6) <= 127) {
            this._writeBytes((byte)36, (byte)n2, by);
            return;
        }
        byte by2 = (byte)(n2 & 0x7F);
        if ((n2 >>= 7) <= 127) {
            this._writeBytes((byte)36, (byte)n2, by2, by);
            return;
        }
        byte by3 = (byte)(n2 & 0x7F);
        if ((n2 >>= 7) <= 127) {
            this._writeBytes((byte)36, (byte)n2, by3, by2, by);
            return;
        }
        byte by4 = (byte)(n2 & 0x7F);
        this._writeBytes((byte)36, (byte)(n2 >> 7), by4, by3, by2, by);
    }

    @Override
    public void writeNumber(long l2) {
        if (l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
            this.writeNumber((int)l2);
            return;
        }
        this._verifyValueWrite("write number");
        l2 = SmileUtil.zigzagEncode(l2);
        int n2 = (int)l2;
        byte by = (byte)(128 + (n2 & 0x3F));
        byte by2 = (byte)(n2 >> 6 & 0x7F);
        byte by3 = (byte)(n2 >> 13 & 0x7F);
        byte by4 = (byte)(n2 >> 20 & 0x7F);
        byte by5 = (byte)((int)(l2 >>>= 27) & 0x7F);
        n2 = (int)(l2 >> 7);
        if (n2 == 0) {
            this._writeBytes((byte)37, by5, by4, by3, by2, by);
            return;
        }
        if (n2 <= 127) {
            this._writeBytes((byte)37, (byte)n2);
            this._writeBytes(by5, by4, by3, by2, by);
            return;
        }
        byte by6 = (byte)(n2 & 0x7F);
        if ((n2 >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)n2);
            this._writeBytes(by6, by5, by4, by3, by2, by);
            return;
        }
        byte by7 = (byte)(n2 & 0x7F);
        if ((n2 >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)n2, by7);
            this._writeBytes(by6, by5, by4, by3, by2, by);
            return;
        }
        byte by8 = (byte)(n2 & 0x7F);
        if ((n2 >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)n2, by8, by7);
            this._writeBytes(by6, by5, by4, by3, by2, by);
            return;
        }
        byte by9 = (byte)(n2 & 0x7F);
        this._writeBytes((byte)37, (byte)(n2 >>= 7), by9, by8, by7);
        this._writeBytes(by6, by5, by4, by3, by2, by);
    }

    @Override
    public void writeNumber(BigInteger object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeByte((byte)38);
        object = ((BigInteger)object).toByteArray();
        this._write7BitBinaryWithLength((byte[])object, 0, ((Object)object).length);
    }

    @Override
    public void writeNumber(double d2) {
        this._ensureRoomForOutput(11);
        this._verifyValueWrite("write number");
        long l2 = Double.doubleToRawLongBits(d2);
        this._outputBuffer[this._outputTail++] = 41;
        int n2 = (int)(l2 >>> 35);
        this._outputBuffer[this._outputTail + 4] = (byte)(n2 & 0x7F);
        this._outputBuffer[this._outputTail + 3] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)(n2 >>= 7);
        this._outputTail += 5;
        n2 = (int)(l2 >> 28);
        this._outputBuffer[this._outputTail++] = (byte)(n2 & 0x7F);
        n2 = (int)l2;
        this._outputBuffer[this._outputTail + 3] = (byte)(n2 & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)((n2 >>= 7) & 0x7F);
        this._outputTail += 4;
    }

    @Override
    public void writeNumber(float f2) {
        this._ensureRoomForOutput(6);
        this._verifyValueWrite("write number");
        int n2 = Float.floatToRawIntBits(f2);
        this._outputBuffer[this._outputTail++] = 40;
        this._outputBuffer[this._outputTail + 4] = (byte)(n2 & 0x7F);
        this._outputBuffer[this._outputTail + 3] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)((n2 >>= 7) & 0x7F);
        this._outputTail += 5;
    }

    @Override
    public void writeNumber(BigDecimal object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeByte((byte)42);
        int n2 = ((BigDecimal)object).scale();
        this._writeSignedVInt(n2);
        object = ((BigDecimal)object).unscaledValue().toByteArray();
        this._write7BitBinaryWithLength((byte[])object, 0, ((Object)object).length);
    }

    @Override
    public void writeNumber(String string) {
        char c2;
        int n2;
        if (string == null) {
            this.writeNull();
            return;
        }
        int n3 = string.length();
        boolean bl = string.startsWith("-");
        int n4 = n2 = bl ? 1 : 0;
        while ((c2 = string.charAt(n2)) <= '9' && c2 >= '0') {
            if (++n2 != n3) continue;
            this._writeIntegralNumber(string, bl);
            return;
        }
        this._writeDecimalNumber(string);
    }

    protected void _writeIntegralNumber(String string, boolean bl) {
        int n2 = string.length();
        if (bl) {
            --n2;
        }
        try {
            if (n2 <= 9) {
                this.writeNumber(Integer.parseInt(string));
                return;
            }
            if (n2 <= 18) {
                this.writeNumber(Long.parseLong(string));
                return;
            }
            this.writeNumber(new BigInteger(string));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonGenerationException("Invalid String representation for Number ('" + string + "'); can not write using Smile format");
        }
    }

    protected void _writeDecimalNumber(String string) {
        try {
            this.writeNumber(new BigDecimal(string));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonGenerationException("Invalid String representation for Number ('" + string + "'); can not write using Smile format");
        }
    }

    @Override
    protected final void _verifyValueWrite(String string) {
        if (this._writeContext.writeValue() == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
    }

    @Override
    public final void flush() {
        this._flushBuffer();
        if (this.isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
            this._out.flush();
        }
    }

    @Override
    public void close() {
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator$Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonWriteContext jsonWriteContext;
                if ((jsonWriteContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonWriteContext.inObject()) break;
                this.writeEndObject();
            }
        }
        boolean bl = this._closed;
        super.close();
        if (!bl && this.isEnabled(SmileGenerator$Feature.WRITE_END_MARKER)) {
            this._writeByte((byte)-1);
        }
        this._flushBuffer();
        if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator$Feature.AUTO_CLOSE_TARGET)) {
            this._out.close();
        } else {
            this._out.flush();
        }
        this._releaseBuffers();
    }

    private final int _shortUTF8Encode(char[] cArray, int n2, int n3) {
        int n4;
        int n5 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        do {
            if ((n4 = cArray[n2]) > 127) {
                return this._shortUTF8Encode2(cArray, n2, n3, n5);
            }
            byArray[n5++] = (byte)n4;
        } while (++n2 < n3);
        n4 = n5 - this._outputTail;
        this._outputTail = n5;
        return n4;
    }

    private final int _shortUTF8Encode2(char[] cArray, int n2, int n3, int n4) {
        int n5;
        byte[] byArray = this._outputBuffer;
        while (n2 < n3) {
            if ((n5 = cArray[n2++]) <= 127) {
                byArray[n4++] = (byte)n5;
                continue;
            }
            if (n5 < 2048) {
                byArray[n4++] = (byte)(0xC0 | n5 >> 6);
                byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            if (n5 < 55296 || n5 > 57343) {
                byArray[n4++] = (byte)(0xE0 | n5 >> 12);
                byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            if (n5 > 56319) {
                this._throwIllegalSurrogate(n5);
            }
            if (n2 >= n3) {
                this._throwIllegalSurrogate(n5);
            }
            if ((n5 = this._convertSurrogate(n5, cArray[n2++])) > 0x10FFFF) {
                this._throwIllegalSurrogate(n5);
            }
            byArray[n4++] = (byte)(0xF0 | n5 >> 18);
            byArray[n4++] = (byte)(0x80 | n5 >> 12 & 0x3F);
            byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
        }
        n5 = n4 - this._outputTail;
        this._outputTail = n4;
        return n5;
    }

    private final int _shortUTF8Encode(String string, int n2, int n3) {
        int n4;
        int n5 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        do {
            if ((n4 = string.charAt(n2)) > 127) {
                return this._shortUTF8Encode2(string, n2, n3, n5);
            }
            byArray[n5++] = (byte)n4;
        } while (++n2 < n3);
        n4 = n5 - this._outputTail;
        this._outputTail = n5;
        return n4;
    }

    private final int _shortUTF8Encode2(String string, int n2, int n3, int n4) {
        int n5;
        byte[] byArray = this._outputBuffer;
        while (n2 < n3) {
            char c2 = string.charAt(n2++);
            n5 = c2;
            if (c2 <= '\u007f') {
                byArray[n4++] = (byte)n5;
                continue;
            }
            if (n5 < 2048) {
                byArray[n4++] = (byte)(0xC0 | n5 >> 6);
                byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            if (n5 < 55296 || n5 > 57343) {
                byArray[n4++] = (byte)(0xE0 | n5 >> 12);
                byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            if (n5 > 56319) {
                this._throwIllegalSurrogate(n5);
            }
            if (n2 >= n3) {
                this._throwIllegalSurrogate(n5);
            }
            if ((n5 = this._convertSurrogate(n5, string.charAt(n2++))) > 0x10FFFF) {
                this._throwIllegalSurrogate(n5);
            }
            byArray[n4++] = (byte)(0xF0 | n5 >> 18);
            byArray[n4++] = (byte)(0x80 | n5 >> 12 & 0x3F);
            byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
        }
        n5 = n4 - this._outputTail;
        this._outputTail = n4;
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _mediumUTF8Encode(char[] cArray, int n2, int n3) {
        int n4 = this._outputEnd - 4;
        block0: while (n2 < n3) {
            int n5;
            if (this._outputTail >= n4) {
                this._flushBuffer();
            }
            if ((n5 = cArray[n2++]) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)n5;
                int n6 = n3 - n2;
                n5 = n4 - this._outputTail;
                if (n6 > n5) {
                    n6 = n5;
                }
                n6 += n2;
                while (true) {
                    if (n2 >= n6) continue block0;
                    if ((n5 = cArray[n2++]) > 127) break;
                    this._outputBuffer[this._outputTail++] = (byte)n5;
                }
            }
            if (n5 < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | n5 >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            if (n5 < 55296 || n5 > 57343) {
                this._outputBuffer[this._outputTail++] = (byte)(0xE0 | n5 >> 12);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            if (n5 > 56319) {
                this._throwIllegalSurrogate(n5);
            }
            if (n2 >= n3) {
                this._throwIllegalSurrogate(n5);
            }
            if ((n5 = this._convertSurrogate(n5, cArray[n2++])) > 0x10FFFF) {
                this._throwIllegalSurrogate(n5);
            }
            this._outputBuffer[this._outputTail++] = (byte)(0xF0 | n5 >> 18);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 >> 12 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 & 0x3F);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _mediumUTF8Encode(String string, int n2, int n3) {
        int n4 = this._outputEnd - 4;
        block0: while (n2 < n3) {
            int n5;
            if (this._outputTail >= n4) {
                this._flushBuffer();
            }
            if ((n5 = string.charAt(n2++)) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)n5;
                int n6 = n3 - n2;
                n5 = n4 - this._outputTail;
                if (n6 > n5) {
                    n6 = n5;
                }
                n6 += n2;
                while (true) {
                    if (n2 >= n6) continue block0;
                    char c2 = string.charAt(n2++);
                    n5 = c2;
                    if (c2 > '\u007f') break;
                    this._outputBuffer[this._outputTail++] = (byte)n5;
                }
            }
            if (n5 < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | n5 >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            if (n5 < 55296 || n5 > 57343) {
                this._outputBuffer[this._outputTail++] = (byte)(0xE0 | n5 >> 12);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            if (n5 > 56319) {
                this._throwIllegalSurrogate(n5);
            }
            if (n2 >= n3) {
                this._throwIllegalSurrogate(n5);
            }
            if ((n5 = this._convertSurrogate(n5, string.charAt(n2++))) > 0x10FFFF) {
                this._throwIllegalSurrogate(n5);
            }
            this._outputBuffer[this._outputTail++] = (byte)(0xF0 | n5 >> 18);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 >> 12 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 & 0x3F);
        }
        return;
    }

    private int _convertSurrogate(int n2, int n3) {
        if (n3 < 56320 || n3 > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(n2) + ", second 0x" + Integer.toHexString(n3) + "; illegal combination");
        }
        return 65536 + (n2 - 55296 << 10) + (n3 - 56320);
    }

    private void _throwIllegalSurrogate(int n2) {
        if (n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(n2) + ") to output; max is 0x10FFFF as per RFC 4627");
        }
        if (n2 >= 55296) {
            if (n2 <= 56319) {
                throw new IllegalArgumentException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(n2) + ")");
            }
            throw new IllegalArgumentException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(n2) + ")");
        }
        throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(n2) + ") to output");
    }

    private final void _ensureRoomForOutput(int n2) {
        if (this._outputTail + n2 >= this._outputEnd) {
            this._flushBuffer();
        }
    }

    private final void _writeByte(byte by) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
    }

    private final void _writeBytes(byte by, byte by2) {
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
    }

    private final void _writeBytes(byte by, byte by2, byte by3) {
        if (this._outputTail + 2 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
    }

    private final void _writeBytes(byte by, byte by2, byte by3, byte by4) {
        if (this._outputTail + 3 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by4;
    }

    private final void _writeBytes(byte by, byte by2, byte by3, byte by4, byte by5) {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by4;
        this._outputBuffer[this._outputTail++] = by5;
    }

    private final void _writeBytes(byte by, byte by2, byte by3, byte by4, byte by5, byte by6) {
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by4;
        this._outputBuffer[this._outputTail++] = by5;
        this._outputBuffer[this._outputTail++] = by6;
    }

    private final void _writeBytes(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (this._outputTail + n3 >= this._outputEnd) {
            this._writeBytesLong(byArray, n2, n3);
            return;
        }
        System.arraycopy(byArray, n2, this._outputBuffer, this._outputTail, n3);
        this._outputTail += n3;
    }

    private final int _writeBytes(InputStream inputStream, int n2) {
        while (n2 > 0) {
            int n3 = this._outputEnd - this._outputTail;
            if (n3 <= 0) {
                this._flushBuffer();
                n3 = this._outputEnd - this._outputTail;
            }
            if (n3 > n2) {
                n3 = n2;
            }
            if ((n3 = inputStream.read(this._outputBuffer, this._outputTail, n3)) < 0) break;
            this._outputTail += n3;
            n2 -= n3;
        }
        return n2;
    }

    private final void _writeBytesLong(byte[] byArray, int n2, int n3) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        while (true) {
            int n4 = Math.min(n3, this._outputEnd - this._outputTail);
            System.arraycopy(byArray, n2, this._outputBuffer, this._outputTail, n4);
            this._outputTail += n4;
            if ((n3 -= n4) == 0) break;
            n2 += n4;
            this._flushBuffer();
        }
    }

    private void _writePositiveVInt(int n2) {
        this._ensureRoomForOutput(5);
        byte by = (byte)(128 + (n2 & 0x3F));
        if ((n2 >>= 6) <= 127) {
            if (n2 > 0) {
                this._outputBuffer[this._outputTail++] = (byte)n2;
            }
            this._outputBuffer[this._outputTail++] = by;
            return;
        }
        byte by2 = (byte)(n2 & 0x7F);
        if ((n2 >>= 7) <= 127) {
            this._outputBuffer[this._outputTail++] = (byte)n2;
            this._outputBuffer[this._outputTail++] = by2;
            this._outputBuffer[this._outputTail++] = by;
            return;
        }
        byte by3 = (byte)(n2 & 0x7F);
        if ((n2 >>= 7) <= 127) {
            this._outputBuffer[this._outputTail++] = (byte)n2;
            this._outputBuffer[this._outputTail++] = by3;
            this._outputBuffer[this._outputTail++] = by2;
            this._outputBuffer[this._outputTail++] = by;
            return;
        }
        byte by4 = (byte)(n2 & 0x7F);
        this._outputBuffer[this._outputTail++] = (byte)(n2 >> 7);
        this._outputBuffer[this._outputTail++] = by4;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by;
    }

    private void _writeSignedVInt(int n2) {
        this._writePositiveVInt(SmileUtil.zigzagEncode(n2));
    }

    protected void _write7BitBinaryWithLength(byte[] byArray, int n2, int n3) {
        int n4;
        this._writePositiveVInt(n3);
        while (n3 >= 7) {
            if (this._outputTail + 8 >= this._outputEnd) {
                this._flushBuffer();
            }
            n4 = byArray[n2++];
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 1 & 0x7F);
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 2 & 0x7F);
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 3 & 0x7F);
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 4 & 0x7F);
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 5 & 0x7F);
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 6 & 0x7F);
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 7 & 0x7F);
            this._outputBuffer[this._outputTail++] = (byte)(n4 & 0x7F);
            n3 -= 7;
        }
        if (n3 > 0) {
            if (this._outputTail + 7 >= this._outputEnd) {
                this._flushBuffer();
            }
            n4 = byArray[n2++];
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 1 & 0x7F);
            if (n3 > 1) {
                n4 = (n4 & 1) << 8 | byArray[n2++] & 0xFF;
                this._outputBuffer[this._outputTail++] = (byte)(n4 >> 2 & 0x7F);
                if (n3 > 2) {
                    n4 = (n4 & 3) << 8 | byArray[n2++] & 0xFF;
                    this._outputBuffer[this._outputTail++] = (byte)(n4 >> 3 & 0x7F);
                    if (n3 > 3) {
                        n4 = (n4 & 7) << 8 | byArray[n2++] & 0xFF;
                        this._outputBuffer[this._outputTail++] = (byte)(n4 >> 4 & 0x7F);
                        if (n3 > 4) {
                            n4 = (n4 & 0xF) << 8 | byArray[n2++] & 0xFF;
                            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 5 & 0x7F);
                            if (n3 > 5) {
                                n4 = (n4 & 0x1F) << 8 | byArray[n2] & 0xFF;
                                this._outputBuffer[this._outputTail++] = (byte)(n4 >> 6 & 0x7F);
                                this._outputBuffer[this._outputTail++] = (byte)(n4 & 0x3F);
                                return;
                            }
                            this._outputBuffer[this._outputTail++] = (byte)(n4 & 0x1F);
                            return;
                        }
                        this._outputBuffer[this._outputTail++] = (byte)(n4 & 0xF);
                        return;
                    }
                    this._outputBuffer[this._outputTail++] = (byte)(n4 & 7);
                    return;
                }
                this._outputBuffer[this._outputTail++] = (byte)(n4 & 3);
                return;
            }
            this._outputBuffer[this._outputTail++] = (byte)(n4 & 1);
        }
    }

    protected int _write7BitBinaryWithLength(InputStream inputStream, int n2, byte[] byArray) {
        int n3;
        this._writePositiveVInt(n2);
        int n4 = 0;
        int n5 = 0;
        int n6 = -7;
        while (n2 >= 7) {
            if (n4 > n6) {
                n5 = this._readMore(inputStream, byArray, n4, n5, n2);
                n4 = 0;
                if (n5 < 7) {
                    n2 -= n5;
                    break;
                }
                n6 = n5 - 7;
            }
            if (this._outputTail + 8 >= this._outputEnd) {
                this._flushBuffer();
            }
            n3 = byArray[n4++];
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 1 & 0x7F);
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 2 & 0x7F);
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 3 & 0x7F);
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 4 & 0x7F);
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 5 & 0x7F);
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 6 & 0x7F);
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 7 & 0x7F);
            this._outputBuffer[this._outputTail++] = (byte)(n3 & 0x7F);
            n2 -= 7;
        }
        if (n2 > 0) {
            if (this._outputTail + 7 >= this._outputEnd) {
                this._flushBuffer();
            }
            if ((n5 = this._readMore(inputStream, byArray, n4, n5, n2)) > 0) {
                n2 -= n5;
                n3 = byArray[0];
                this._outputBuffer[this._outputTail++] = (byte)(n3 >> 1 & 0x7F);
                if (n5 > 1) {
                    n3 = (n3 & 1) << 8 | byArray[1] & 0xFF;
                    this._outputBuffer[this._outputTail++] = (byte)(n3 >> 2 & 0x7F);
                    if (n5 > 2) {
                        n3 = (n3 & 3) << 8 | byArray[2] & 0xFF;
                        this._outputBuffer[this._outputTail++] = (byte)(n3 >> 3 & 0x7F);
                        if (n5 > 3) {
                            n3 = (n3 & 7) << 8 | byArray[3] & 0xFF;
                            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 4 & 0x7F);
                            if (n5 > 4) {
                                n3 = (n3 & 0xF) << 8 | byArray[4] & 0xFF;
                                this._outputBuffer[this._outputTail++] = (byte)(n3 >> 5 & 0x7F);
                                if (n5 > 5) {
                                    n3 = (n3 & 0x1F) << 8 | byArray[5] & 0xFF;
                                    this._outputBuffer[this._outputTail++] = (byte)(n3 >> 6 & 0x7F);
                                    this._outputBuffer[this._outputTail++] = (byte)(n3 & 0x3F);
                                } else {
                                    this._outputBuffer[this._outputTail++] = (byte)(n3 & 0x1F);
                                }
                            } else {
                                this._outputBuffer[this._outputTail++] = (byte)(n3 & 0xF);
                            }
                        } else {
                            this._outputBuffer[this._outputTail++] = (byte)(n3 & 7);
                        }
                    } else {
                        this._outputBuffer[this._outputTail++] = (byte)(n3 & 3);
                    }
                } else {
                    this._outputBuffer[this._outputTail++] = (byte)(n3 & 1);
                }
            }
        }
        return n2;
    }

    private int _readMore(InputStream inputStream, byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n2 < n3) {
            byArray[n5++] = byArray[n2++];
        }
        n3 = n5;
        n4 = Math.min(n4, byArray.length);
        while ((n2 = n4 - n3) != 0) {
            if ((n2 = inputStream.read(byArray, n3, n2)) < 0) {
                return n3;
            }
            if ((n3 += n2) < 7) continue;
        }
        return n3;
    }

    @Override
    protected void _releaseBuffers() {
        Object[] objectArray = this._outputBuffer;
        if (this._outputBuffer != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer((byte[])objectArray);
        }
        objectArray = this._seenNames;
        if (this._seenNames != null && objectArray.length == 64) {
            this._seenNames = null;
            if (this._seenNameCount > 0) {
                Arrays.fill(objectArray, null);
            }
            this._smileBufferRecycler.releaseSeenNamesBuffer((SmileGenerator$SharedStringNode[])objectArray);
        }
        objectArray = this._seenStringValues;
        if (this._seenStringValues != null && objectArray.length == 64) {
            this._seenStringValues = null;
            if (this._seenStringValueCount > 0) {
                Arrays.fill(objectArray, null);
            }
            this._smileBufferRecycler.releaseSeenStringValuesBuffer((SmileGenerator$SharedStringNode[])objectArray);
        }
    }

    protected final void _flushBuffer() {
        if (this._outputTail > 0) {
            this._bytesWritten += this._outputTail;
            this._out.write(this._outputBuffer, 0, this._outputTail);
            this._outputTail = 0;
        }
    }

    private final int _findSeenName(String string) {
        int n2 = string.hashCode();
        Object object = this._seenNames[n2 & this._seenNames.length - 1];
        if (object == null) {
            return -1;
        }
        SmileGenerator$SharedStringNode smileGenerator$SharedStringNode = object;
        if (smileGenerator$SharedStringNode.value == string) {
            return smileGenerator$SharedStringNode.index;
        }
        while ((smileGenerator$SharedStringNode = smileGenerator$SharedStringNode.next) != null) {
            if (smileGenerator$SharedStringNode.value != string) continue;
            return smileGenerator$SharedStringNode.index;
        }
        smileGenerator$SharedStringNode = object;
        do {
            if (((String)(object = smileGenerator$SharedStringNode.value)).hashCode() != n2 || !((String)object).equals(string)) continue;
            return smileGenerator$SharedStringNode.index;
        } while ((smileGenerator$SharedStringNode = smileGenerator$SharedStringNode.next) != null);
        return -1;
    }

    private final void _addSeenName(String string) {
        int n2;
        if (this._seenNameCount == this._seenNames.length) {
            if (this._seenNameCount == 1024) {
                Arrays.fill(this._seenNames, null);
                this._seenNameCount = 0;
            } else {
                SmileGenerator$SharedStringNode[] smileGenerator$SharedStringNodeArray = this._seenNames;
                this._seenNames = new SmileGenerator$SharedStringNode[1024];
                for (SmileGenerator$SharedStringNode smileGenerator$SharedStringNode : smileGenerator$SharedStringNodeArray) {
                    while (smileGenerator$SharedStringNode != null) {
                        int n3 = smileGenerator$SharedStringNode.value.hashCode() & 0x3FF;
                        SmileGenerator$SharedStringNode smileGenerator$SharedStringNode2 = smileGenerator$SharedStringNode.next;
                        smileGenerator$SharedStringNode.next = this._seenNames[n3];
                        this._seenNames[n3] = smileGenerator$SharedStringNode;
                        smileGenerator$SharedStringNode = smileGenerator$SharedStringNode2;
                    }
                }
            }
        }
        if (SmileGenerator._validBackRef(n2 = this._seenNameCount)) {
            int n4 = string.hashCode() & this._seenNames.length - 1;
            this._seenNames[n4] = new SmileGenerator$SharedStringNode(string, n2, this._seenNames[n4]);
        }
        this._seenNameCount = n2 + 1;
    }

    private final int _findSeenStringValue(String string) {
        int n2 = string.hashCode();
        Object object = this._seenStringValues[n2 & this._seenStringValues.length - 1];
        if (object != null) {
            SmileGenerator$SharedStringNode smileGenerator$SharedStringNode = object;
            do {
                if (smileGenerator$SharedStringNode.value != string) continue;
                return smileGenerator$SharedStringNode.index;
            } while ((smileGenerator$SharedStringNode = smileGenerator$SharedStringNode.next) != null);
            smileGenerator$SharedStringNode = object;
            do {
                if (((String)(object = smileGenerator$SharedStringNode.value)).hashCode() != n2 || !((String)object).equals(string)) continue;
                return smileGenerator$SharedStringNode.index;
            } while ((smileGenerator$SharedStringNode = smileGenerator$SharedStringNode.next) != null);
        }
        return -1;
    }

    private final void _addSeenStringValue(String string) {
        int n2;
        if (this._seenStringValueCount == this._seenStringValues.length) {
            if (this._seenStringValueCount == 1024) {
                Arrays.fill(this._seenStringValues, null);
                this._seenStringValueCount = 0;
            } else {
                SmileGenerator$SharedStringNode[] smileGenerator$SharedStringNodeArray = this._seenStringValues;
                this._seenStringValues = new SmileGenerator$SharedStringNode[1024];
                for (SmileGenerator$SharedStringNode smileGenerator$SharedStringNode : smileGenerator$SharedStringNodeArray) {
                    while (smileGenerator$SharedStringNode != null) {
                        int n3 = smileGenerator$SharedStringNode.value.hashCode() & 0x3FF;
                        SmileGenerator$SharedStringNode smileGenerator$SharedStringNode2 = smileGenerator$SharedStringNode.next;
                        smileGenerator$SharedStringNode.next = this._seenStringValues[n3];
                        this._seenStringValues[n3] = smileGenerator$SharedStringNode;
                        smileGenerator$SharedStringNode = smileGenerator$SharedStringNode2;
                    }
                }
            }
        }
        if (SmileGenerator._validBackRef(n2 = this._seenStringValueCount)) {
            int n4 = string.hashCode() & this._seenStringValues.length - 1;
            this._seenStringValues[n4] = new SmileGenerator$SharedStringNode(string, n2, this._seenStringValues[n4]);
        }
        this._seenStringValueCount = n2 + 1;
    }

    private static final boolean _validBackRef(int n2) {
        return (n2 & 0xFF) < 254;
    }

    protected long outputOffset() {
        return this._bytesWritten + this._outputTail;
    }

    protected UnsupportedOperationException _notSupported() {
        return new UnsupportedOperationException();
    }
}

