/*
 * Decompiled with CFR 0.152.
 */
package com.gpfreetech.aadhaarkyc;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import android.util.Xml;
import androidx.appcompat.app.AlertDialog;
import com.gemalto.jp2.JP2Decoder;
import com.gpfreetech.aadhaarkyc.OnAadhaarResponse;
import com.gpfreetech.aadhaarkyc.R;
import com.gpfreetech.aadhaarkyc.entity.AadhaarUser;
import com.gpfreetech.aadhaarkyc.util.SignVerifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.util.zip.GZIPInputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class AadhaarParser {
    public static final String IS_XML = "is_xml";
    private boolean isXML;
    private final Charset CHARSET = Charset.forName("ISO-8859-1");
    private boolean isVerified;
    private String sha256;
    private String[] address = new String[11];
    private boolean isDataValid = true;
    public static Context mContext = null;
    private AadhaarUser aadhaarUser = new AadhaarUser();
    public OnAadhaarResponse onAadhaarResponse = null;

    public static AadhaarParser getInstance(Context context) {
        if (mContext == null) {
            mContext = context;
        }
        return new AadhaarParser();
    }

    private void showAlertDialog(String alertMessage) {
        new AlertDialog.Builder(mContext).setTitle((CharSequence)mContext.getResources().getString(R.string.app_name)).setCancelable(false).setMessage((CharSequence)(alertMessage + mContext.getString(R.string.readingErrorMessage))).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).show();
    }

    private byte[] decompress(byte[] data) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            int len;
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            GZIPInputStream gis = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            while ((len = gis.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            os.close();
            gis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return os.toByteArray();
    }

    private void showScannedResult(byte[] uidData, boolean isXML) {
        this.isXML = isXML;
        byte[] uidBytes = uidData;
        if (isXML) {
            this.parseXMLToObject(uidBytes);
        } else {
            this.loadDataToObject(uidBytes);
        }
        if (!this.isVerified) {
            this.verifySignature(uidBytes);
        }
    }

    public void parse(String response, OnAadhaarResponse onAadhaarResponse) {
        this.onAadhaarResponse = onAadhaarResponse;
        Log.e((String)"parse string", (String)(": " + response));
        this.isDataValid = true;
        boolean isXML = false;
        byte[] message = response.getBytes();
        String res = new String(message, Charset.forName("UTF-8"));
        String xmlHeader = res.substring(0, 4);
        Log.e((String)"parse", (String)("onPreviewFrame: res " + res));
        Log.e((String)"parse", (String)("onPreviewFrame: xmlHeader " + xmlHeader));
        byte[] uiData = null;
        if (xmlHeader.equals("<QPD") || xmlHeader.equals("<QDB")) {
            uiData = message;
            isXML = true;
        } else if (xmlHeader.equals("<?xm") && response.contains("PrintLetterBarcodeData")) {
            uiData = message;
            isXML = true;
            this.isVerified = false;
        } else {
            try {
                uiData = new BigInteger(res).toByteArray();
                String data_ = new BigInteger(res).toString();
                Log.d((String)"DATA", (String)(data_ + " " + data_.length()));
                Log.d((String)"Size", (String)(uiData.length + " " + res.length()));
                uiData = this.decompress(uiData);
                if (uiData == null) {
                    this.isDataValid = false;
                }
            }
            catch (NumberFormatException e) {
                this.isDataValid = false;
            }
        }
        if (this.isDataValid) {
            this.showScannedResult(uiData, isXML);
        }
    }

    private void parseXMLToObject(byte[] uidBytes) {
        try {
            XmlPullParserFactory parserFactory = XmlPullParserFactory.newInstance();
            XmlPullParser parser = parserFactory.newPullParser();
            ByteArrayInputStream is = new ByteArrayInputStream(uidBytes);
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            parser.setInput((InputStream)is, null);
            int eventType = parser.getEventType();
            while (eventType != 1) {
                String eltName = null;
                switch (eventType) {
                    case 2: {
                        eltName = parser.getName();
                        if ("QPDB".equals(eltName) || "QDB".equals(eltName)) {
                            this.aadhaarUser.setName(parser.getAttributeValue(null, "n"));
                            this.aadhaarUser.setUid(parser.getAttributeValue(null, "u"));
                            this.aadhaarUser.setGender(parser.getAttributeValue(null, "g"));
                            this.aadhaarUser.setDob(parser.getAttributeValue(null, "d"));
                            this.aadhaarUser.setAddress(parser.getAttributeValue(null, "a"));
                            this.aadhaarUser.setDigSign(parser.getAttributeValue(null, "s"));
                            this.aadhaarUser.setMobile(parser.getAttributeValue(null, "m"));
                            if (!"QPDB".equals(eltName)) break;
                            this.aadhaarUser.setImage(parser.getAttributeValue(null, "i"));
                            try {
                                byte[] imageBytes = Base64.decode((String)this.aadhaarUser.getImage(), (int)0);
                                Bitmap bmp = new JP2Decoder(imageBytes).decode();
                                this.aadhaarUser.setImageBitmap(bmp);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            this.aadhaarUser.setImage("");
                            break;
                        }
                        if (!"PrintLetterBarcodeData".equals(eltName)) break;
                        this.aadhaarUser.setName(parser.getAttributeValue(null, "name"));
                        this.aadhaarUser.setUid(parser.getAttributeValue(null, "uid"));
                        this.aadhaarUser.setGender(parser.getAttributeValue(null, "gender"));
                        this.aadhaarUser.setDob(parser.getAttributeValue(null, "yob"));
                        StringBuilder sb = new StringBuilder();
                        sb.append(parser.getAttributeValue(null, "house") + ",");
                        sb.append(parser.getAttributeValue(null, "street") + ",");
                        sb.append(parser.getAttributeValue(null, "loc") + ",");
                        sb.append(parser.getAttributeValue(null, "vtc") + ",");
                        sb.append(parser.getAttributeValue(null, "subdist") + ",");
                        sb.append(parser.getAttributeValue(null, "dist") + ",");
                        sb.append(parser.getAttributeValue(null, "state") + ",");
                        sb.append(parser.getAttributeValue(null, "pc") + ",");
                        String address = sb.toString();
                        this.aadhaarUser.setAddress(address);
                        this.aadhaarUser.setDigSign(null);
                        this.aadhaarUser.setMobile(null);
                        this.aadhaarUser.setImage(null);
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadDataToObject(byte[] uidBytes) {
        int end = uidBytes.length - 1;
        this.aadhaarUser.setDigSign(Base64.encodeToString((byte[])this.getDataReverse(uidBytes, end, 256), (int)0));
        end -= 256;
        Pair<Integer, String> temp = this.getData(uidBytes, 2);
        this.aadhaarUser.setUid((String)temp.second);
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.aadhaarUser.setName((String)temp.second);
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.aadhaarUser.setDob((String)temp.second);
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.aadhaarUser.setGender((String)temp.second);
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.address[0] = (String)temp.second;
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.address[1] = (String)temp.second;
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.address[2] = (String)temp.second;
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.address[3] = (String)temp.second;
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.address[4] = (String)temp.second;
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.address[5] = (String)temp.second;
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.address[6] = (String)temp.second;
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.address[7] = (String)temp.second;
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.address[8] = (String)temp.second;
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.address[9] = (String)temp.second;
        temp = this.getData(uidBytes, (Integer)temp.first);
        this.address[10] = (String)temp.second;
        String add = this.address[0] + " " + this.address[3] + " " + this.address[8] + " " + this.address[4] + " " + this.address[2] + " " + this.address[10] + " " + this.address[6] + " " + this.address[9] + " " + this.address[1] + " " + this.address[7] + "-" + this.address[5] + " ";
        this.aadhaarUser.setAddress(add);
        byte flag = uidBytes[0];
        switch (new String(new byte[]{flag}, this.CHARSET).charAt(0)) {
            case '0': {
                break;
            }
            case '1': {
                this.aadhaarUser.setEmail(SignVerifier.getHexStringFromBytes(this.getDataReverse(uidBytes, end, 32)));
                end -= 32;
                break;
            }
            case '2': {
                this.aadhaarUser.setMobile(SignVerifier.getHexStringFromBytes(this.getDataReverse(uidBytes, end, 32)));
                end -= 32;
                break;
            }
            case '3': {
                this.aadhaarUser.setMobile(SignVerifier.getHexStringFromBytes(this.getDataReverse(uidBytes, end, 32)));
                this.aadhaarUser.setEmail(SignVerifier.getHexStringFromBytes(this.getDataReverse(uidBytes, end -= 32, 32)));
                end -= 32;
            }
        }
        this.aadhaarUser.setImage(Base64.encodeToString((byte[])this.getDataReverse(uidBytes, end, end - (Integer)temp.first + 1), (int)0));
        try {
            byte[] imageBytes = Base64.decode((String)this.aadhaarUser.getImage(), (int)0);
            Bitmap bmp = new JP2Decoder(imageBytes).decode();
            this.aadhaarUser.setImageBitmap(bmp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.aadhaarUser.setImage("");
    }

    private void verifySignature(byte[] uidData) {
        if (this.aadhaarUser.getDigSign() != null) {
            byte[] sign = Base64.decode((String)this.aadhaarUser.getDigSign(), (int)0);
            new VerifyAsyncTask().execute((Object[])new byte[][]{uidData, sign});
        } else {
            this.onAadhaarResponse.onAadhaarResponse(this.aadhaarUser);
        }
    }

    private String getXmlOutput(String[] address, AadhaarUser aadhaarUser) {
        StringWriter stringWriter = new StringWriter();
        XmlSerializer serializer = Xml.newSerializer();
        try {
            serializer.setOutput((Writer)stringWriter);
            serializer.startDocument("UTF-8", Boolean.valueOf(true));
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag("", "OfflinePaperlessKyc");
            serializer.attribute("", "referenceId", aadhaarUser.getUid());
            serializer.startTag("", "UidData");
            serializer.startTag("", "Poi");
            serializer.attribute("", "dob", aadhaarUser.getDob());
            serializer.attribute("", "e", aadhaarUser.getEmail());
            serializer.attribute("", "gender", aadhaarUser.getGender());
            serializer.attribute("", "m", aadhaarUser.getMobile());
            serializer.attribute("", "name", aadhaarUser.getName());
            serializer.endTag("", "Poi");
            serializer.startTag("", "Poa");
            serializer.attribute("", "country", "India");
            serializer.attribute("", "dist", address[1]);
            serializer.attribute("", "house", address[3]);
            serializer.attribute("", "loc", address[4]);
            serializer.attribute("", "pc", address[5]);
            serializer.attribute("", "po", address[6]);
            serializer.attribute("", "state", address[7]);
            serializer.attribute("", "street", address[8]);
            serializer.attribute("", "subdist", address[9]);
            serializer.attribute("", "vtc", address[10]);
            serializer.endTag("", "Poa");
            serializer.startTag("", "Pht");
            serializer.text(aadhaarUser.getImage());
            serializer.endTag("", "Pht");
            serializer.endTag("", "UidData");
            serializer.startTag("", "Signature");
            serializer.startTag("", "SignedInfo");
            serializer.startTag("", "CanonicalizationMethod");
            serializer.attribute("", "Algorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            serializer.endTag("", "CanonicalizationMethod");
            serializer.startTag("", "SignatureMethod");
            serializer.attribute("", "Algorithm", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
            serializer.endTag("", "SignatureMethod");
            serializer.startTag("", "Reference");
            serializer.attribute("", "URI", "");
            serializer.startTag("", "Transforms");
            serializer.startTag("", "Transform");
            serializer.attribute("", "Algorithm", "http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            serializer.endTag("", "Transform");
            serializer.endTag("", "Transforms");
            serializer.startTag("", "DigestMethod");
            serializer.attribute("", "Algorithm", "http://www.w3.org/2001/04/xmlenc#sha256");
            serializer.endTag("", "DigestMethod");
            serializer.startTag("", "DigestValue");
            serializer.text(this.sha256);
            serializer.endTag("", "DigestValue");
            serializer.endTag("", "Reference");
            serializer.endTag("", "SignedInfo");
            serializer.startTag("", "SignatureValue");
            serializer.text(aadhaarUser.getDigSign());
            serializer.endTag("", "SignatureValue");
            serializer.endTag("", "Signature");
            serializer.endTag("", "OfflinePaperlessKyc");
            serializer.endDocument();
            stringWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringWriter.toString();
    }

    private Pair<Integer, String> getData(byte[] uidBytes, int start) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = start;
        while (uidBytes[i] != -1) {
            out.write(uidBytes[i++]);
        }
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Pair((Object)(i + 1), (Object)new String(out.toByteArray(), this.CHARSET));
    }

    private byte[] getDataReverse(byte[] uidBytes, int end, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = end - length + 1;
        try {
            out.write(uidBytes, offSet, length);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    public boolean verifyUserDetail(String uid, String input, String key_of_input) {
        String digit = "";
        try {
            if (uid.toLowerCase().contains("xxx")) {
                digit = "" + uid.charAt(uid.length() - 1);
                Log.e((String)"last char X", (String)("" + digit));
            } else {
                String substring = uid.substring(0, 4);
                digit = "" + substring.charAt(3);
                Log.e((String)"last char", (String)("" + digit));
            }
            String generatedString = this.checkMobileAndEmail(input, digit);
            return key_of_input.equals(generatedString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String checkMobileAndEmail(String str, String last_no) {
        int parseInt = Integer.parseInt(last_no);
        if (parseInt != 0 && parseInt != 1) {
            int i = parseInt - 1;
            for (int i2 = 0; i2 < i; ++i2) {
                str = this.stringToHex(str);
            }
        }
        byte[] response = this.m6151c(str);
        Log.e((String)"checkMobileAndEmail", (String)(" " + SignVerifier.getHexStringFromBytes(response)));
        return SignVerifier.getHexStringFromBytes(response);
    }

    private String stringToHex(String str) {
        try {
            byte[] digest = MessageDigest.getInstance("SHA-256").digest(str.getBytes("UTF-8"));
            StringBuffer stringBuffer = new StringBuffer();
            for (byte b : digest) {
                String hexString = Integer.toHexString(b & 0xFF);
                if (hexString.length() == 1) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(hexString);
            }
            return stringBuffer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] m6151c(String str) {
        try {
            return MessageDigest.getInstance("SHA-256").digest(str.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    class VerifyAsyncTask
    extends AsyncTask<byte[], Void, Pair<String, Boolean>> {
        VerifyAsyncTask() {
        }

        protected Pair<String, Boolean> doInBackground(byte[] ... uidDataBytes) {
            byte[] uidData = uidDataBytes[0];
            byte[] sign = uidDataBytes[1];
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(uidData, 0, uidData.length - 256);
                byte[] rawData = out.toByteArray();
                out.close();
                SignVerifier signVerifier = new SignVerifier();
                String[] SECURE_KEY = new String[]{"uidai_offline_publickey_29032019.cer", "auth_hsm.cer", "uidai.cer", "uidai_auth_prod.cer", "okyc-publickey.cer", "uidai_offline_publickey_19062019.cer", "uidai_prod_cdup.cer"};
                Pair<String, Boolean> ret = null;
                for (String str : SECURE_KEY) {
                    try {
                        PublicKey publicKey = signVerifier.getPublicKey(str, mContext);
                        if (publicKey == null) continue;
                        ret = signVerifier.verifySignature(rawData, sign, publicKey, AadhaarParser.this.aadhaarUser.getUid().charAt(3) - 48);
                        if (((Boolean)ret.second).booleanValue()) {
                            Log.e((String)"DigiSign", (String)"true");
                            return ret;
                        }
                        Log.e((String)"DigiSign", (String)"false");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return ret;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new Pair((Object)"", (Object)false);
            }
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected void onPostExecute(Pair<String, Boolean> isVerified) {
            super.onPostExecute(isVerified);
            Log.e((String)"verify", (String)(" " + isVerified.second));
            AadhaarParser.this.isVerified = (Boolean)isVerified.second;
            AadhaarParser.this.sha256 = (String)isVerified.first;
            AadhaarParser.this.aadhaarUser.setVerified((Boolean)isVerified.second);
            String xmlContent = "";
            if (!AadhaarParser.this.isXML) {
                xmlContent = AadhaarParser.this.getXmlOutput(AadhaarParser.this.address, AadhaarParser.this.aadhaarUser);
            }
            AadhaarParser.this.onAadhaarResponse.onAadhaarResponse(AadhaarParser.this.aadhaarUser);
        }
    }
}

