/*
 * Decompiled with CFR 0.152.
 */
package com.gpfreetech.IndiUpi;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.gpfreetech.IndiUpi.Singleton;
import com.gpfreetech.IndiUpi.entity.PaymentPayload;
import com.gpfreetech.IndiUpi.listener.PaymentStatusListener;
import com.gpfreetech.IndiUpi.ui.PaymentActivity;

public final class IndiUpi {
    private Activity mActivity;
    private PaymentPayload mPayment;

    private IndiUpi(@NonNull Activity mActivity, @NonNull PaymentPayload mPayment) {
        this.mActivity = mActivity;
        this.mPayment = mPayment;
    }

    public void pay() {
        Intent payIntent = new Intent((Context)this.mActivity, PaymentActivity.class);
        payIntent.putExtra("payment", (Parcelable)this.mPayment);
        this.mActivity.startActivity(payIntent);
    }

    public void pay(String mBottomSheetTitle) {
        Intent payIntent = new Intent((Context)this.mActivity, PaymentActivity.class);
        payIntent.putExtra("payment", (Parcelable)this.mPayment);
        if (!TextUtils.isEmpty((CharSequence)mBottomSheetTitle)) {
            payIntent.putExtra("title", mBottomSheetTitle);
        }
        this.mActivity.startActivity(payIntent);
    }

    public void setPaymentStatusListener(@NonNull PaymentStatusListener mListener) {
        Singleton singleton = Singleton.getInstance();
        singleton.setListener(mListener);
    }

    public void detachPaymentListener() {
        Singleton.getInstance().detachListener();
    }

    public static final class Builder {
        private Activity activity;
        private PaymentPayload payment;

        @NonNull
        public Builder with(@NonNull Activity activity) {
            this.activity = activity;
            this.payment = new PaymentPayload();
            return this;
        }

        @NonNull
        public Builder setPayeeVpa(@NonNull String vpa) {
            if (!vpa.contains("@")) {
                throw new IllegalStateException("Payee VPA address should be valid (For e.g. example@vpa)");
            }
            this.payment.setVpa(vpa);
            return this;
        }

        @NonNull
        public Builder setPayeeName(@NonNull String name) {
            if (name.trim().length() == 0) {
                throw new IllegalStateException("Payee Name Should be Valid!");
            }
            this.payment.setName(name);
            return this;
        }

        @NonNull
        public Builder setPayeeMerchantCode(@NonNull String merchantCode) {
            if (merchantCode.trim().length() == 0) {
                throw new IllegalStateException("Merchant Code Should be Valid!");
            }
            this.payment.setPayeeMerchantCode(merchantCode);
            return this;
        }

        @NonNull
        public Builder setTransactionId(@NonNull String id) {
            if (id.trim().length() == 0) {
                throw new IllegalStateException("Invalid Transaction ID. Transaction ID Should be Valid!");
            }
            this.payment.setTxnId(id);
            return this;
        }

        @NonNull
        public Builder setTransactionRefId(@NonNull String refId) {
            if (refId.trim().length() == 0) {
                throw new IllegalStateException("RefId Should be Valid!");
            }
            this.payment.setTxnRefId(refId);
            return this;
        }

        @NonNull
        public Builder setDescription(@NonNull String description) {
            if (description.trim().length() == 0) {
                throw new IllegalStateException("Description Should be Valid!");
            }
            this.payment.setDescription(description);
            return this;
        }

        @NonNull
        public Builder setAmount(@NonNull String amount) {
            if (!amount.contains(".")) {
                throw new IllegalStateException("Amount should be in decimal format XX.XX (For e.g. 101.00)");
            }
            this.payment.setAmount(amount);
            return this;
        }

        @NonNull
        public Builder setUrl(@NonNull String scheme, @NonNull String authority, @NonNull String appendPath) {
            if (!scheme.contains("http")) {
                throw new IllegalStateException("URL should be in correct format");
            }
            this.payment.setUrl(scheme, authority, appendPath);
            return this;
        }

        @NonNull
        public IndiUpi build() {
            if (this.activity == null) {
                throw new IllegalStateException("Activity must be specified using with() call before build() IndiUpi");
            }
            if (this.payment == null) {
                throw new IllegalStateException("PaymentPayload null. PaymentPayload details must be initialized before build()");
            }
            if (this.payment.getVpa() == null) {
                throw new IllegalStateException("You need to set payee upi id i.e. VPA. Must call setPayeeVpa() before build().");
            }
            if (this.payment.getTxnId() == null) {
                throw new IllegalStateException("You need to set UNIQUE TxnId. Must call setTransactionId() before build");
            }
            if (this.payment.getTxnRefId() == null) {
                throw new IllegalStateException("You need to set UNIQUE TxnRefId. Must call setTransactionRefId() before build");
            }
            if (this.payment.getName() == null) {
                throw new IllegalStateException("You need to set name. Must call setPayeeName() before build().");
            }
            if (this.payment.getAmount() == null) {
                throw new IllegalStateException("You need to set AMOUNT in decimal format. Must call setAmount() before build().");
            }
            if (this.payment.getDescription() == null) {
                throw new IllegalStateException("You need to set description. Must call setDescription() before build().");
            }
            return new IndiUpi(this.activity, this.payment);
        }
    }
}

