/*
 * Decompiled with CFR 0.152.
 */
package com.gpfreetech.IndiUpi.ui.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.gpfreetech.IndiUpi.R;
import java.util.List;

public class AppsAdapter
extends RecyclerView.Adapter<AppViewHolder> {
    private Context mContext;
    private List<ResolveInfo> mList;
    private Intent mIntent;

    public AppsAdapter(Context mContext, List<ResolveInfo> mList, Intent mIntent) {
        this.mContext = mContext;
        this.mList = mList;
        this.mIntent = mIntent;
    }

    @NonNull
    public AppViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new AppViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_app, parent, false));
    }

    public void onBindViewHolder(@NonNull AppViewHolder holder, int position) {
        final ResolveInfo info = this.mList.get(position);
        String name = String.valueOf(info.loadLabel(this.mContext.getPackageManager()));
        Drawable icon = info.loadIcon(this.mContext.getPackageManager());
        holder.bind(name, icon);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = AppsAdapter.this.mIntent;
                intent.setPackage(info.activityInfo.packageName);
                ((Activity)AppsAdapter.this.mContext).startActivityForResult(intent, 1001);
            }
        });
    }

    public int getItemCount() {
        return this.mList.size();
    }

    static class AppViewHolder
    extends RecyclerView.ViewHolder {
        ImageView icon;
        TextView name;

        AppViewHolder(@NonNull View itemView) {
            super(itemView);
            this.icon = (ImageView)itemView.findViewById(R.id.appIcon);
            this.name = (TextView)itemView.findViewById(R.id.appName);
        }

        void bind(String app_name, Drawable app_icon) {
            this.name.setText((CharSequence)app_name);
            this.icon.setImageDrawable(app_icon);
        }
    }
}

