/*
 * Decompiled with CFR 0.152.
 */
package com.gpfreetech.IndiUpi.ui;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.gpfreetech.IndiUpi.R;
import com.gpfreetech.IndiUpi.Singleton;
import com.gpfreetech.IndiUpi.entity.PaymentPayload;
import com.gpfreetech.IndiUpi.entity.TransactionResponse;
import com.gpfreetech.IndiUpi.ui.AppsBottomSheet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PaymentActivity
extends AppCompatActivity {
    private static final String TAG = "PaymentActivity";
    public static final int PAYMENT_REQUEST = 1001;
    private Singleton singleton;
    private String title;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_pay);
        this.singleton = Singleton.getInstance();
        Intent intent = this.getIntent();
        PaymentPayload payment = (PaymentPayload)intent.getParcelableExtra("payment");
        this.title = !TextUtils.isEmpty((CharSequence)intent.getStringExtra("title")) ? intent.getStringExtra("title") : this.getString(R.string.default_text_pay_using);
        Uri.Builder payUri = new Uri.Builder();
        payUri.scheme("upi").authority("pay");
        payUri.appendQueryParameter("pa", payment.getVpa());
        payUri.appendQueryParameter("pn", payment.getName());
        payUri.appendQueryParameter("tid", payment.getTxnId());
        if (payment.getPayeeMerchantCode() != null) {
            payUri.appendQueryParameter("mc", payment.getPayeeMerchantCode());
        }
        payUri.appendQueryParameter("tr", payment.getTxnRefId());
        payUri.appendQueryParameter("tn", payment.getDescription());
        payUri.appendQueryParameter("am", payment.getAmount());
        payUri.appendQueryParameter("cu", payment.getCurrency());
        try {
            if (payment.getUrl() != null) {
                Uri.Builder callbackUrl = payment.getUrl().buildUpon();
                callbackUrl.appendQueryParameter("pa", payment.getVpa());
                callbackUrl.appendQueryParameter("pn", payment.getName());
                callbackUrl.appendQueryParameter("tid", payment.getTxnId());
                if (payment.getPayeeMerchantCode() != null) {
                    callbackUrl.appendQueryParameter("mc", payment.getPayeeMerchantCode());
                }
                callbackUrl.appendQueryParameter("tr", payment.getTxnRefId());
                callbackUrl.appendQueryParameter("tn", payment.getDescription());
                callbackUrl.appendQueryParameter("am", payment.getAmount());
                callbackUrl.appendQueryParameter("cu", payment.getCurrency());
                payUri.appendQueryParameter("url", callbackUrl.build().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Uri uri = payUri.build();
        Intent paymentIntent = new Intent("android.intent.action.VIEW");
        paymentIntent.setData(uri);
        if (paymentIntent.resolveActivity(this.getPackageManager()) != null) {
            List intentList = this.getPackageManager().queryIntentActivities(paymentIntent, 0);
            this.showApps(intentList, paymentIntent);
        } else {
            Toast.makeText((Context)this, (CharSequence)"No UPI Supported app found in device! Please Install to Proceed!", (int)1).show();
        }
    }

    private void showApps(List<ResolveInfo> appsList, Intent intent) {
        View.OnClickListener onCancelListener = new View.OnClickListener(){

            public void onClick(View v) {
                PaymentActivity.this.callbackTransactionCancelled();
                PaymentActivity.this.finish();
            }
        };
        AppsBottomSheet appsBottomSheet = new AppsBottomSheet(appsList, intent, onCancelListener);
        appsBottomSheet.show(this.getSupportFragmentManager(), this.title);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1001) {
            block9: {
                if (data != null) {
                    String response = data.getStringExtra("response");
                    if (response == null) {
                        this.callbackTransactionCancelled();
                        Log.d((String)TAG, (String)"Response is null");
                    } else {
                        TransactionResponse transactionDetails = this.getTransactionDetails(response);
                        this.callbackTransactionComplete(transactionDetails);
                        try {
                            if (transactionDetails.getStatus().toLowerCase().equals("success")) {
                                this.callbackTransactionSuccess(transactionDetails);
                                break block9;
                            }
                            if (transactionDetails.getStatus().toLowerCase().equals("submitted")) {
                                this.callbackTransactionSubmitted();
                                break block9;
                            }
                            this.callbackTransactionFailed();
                        }
                        catch (Exception e) {
                            this.callbackTransactionCancelled();
                            this.callbackTransactionFailed();
                        }
                    }
                } else {
                    Log.e((String)TAG, (String)"Intent Data is null. User cancelled");
                    this.callbackTransactionCancelled();
                }
            }
            this.finish();
        }
    }

    private Map<String, String> getQueryString(String url) {
        String[] params = url.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    private TransactionResponse getTransactionDetails(String response) {
        Map<String, String> map = this.getQueryString(response);
        String transactionId = map.get("txnId");
        String responseCode = map.get("responseCode");
        String approvalRefNo = map.get("ApprovalRefNo");
        String status = map.get("Status");
        String transactionRefId = map.get("txnRef");
        return new TransactionResponse(transactionId, responseCode, approvalRefNo, status, transactionRefId);
    }

    private boolean isListenerRegistered() {
        return Singleton.getInstance().isListenerRegistered();
    }

    private void callbackTransactionSuccess(TransactionResponse transactionDetails) {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionSuccess(transactionDetails);
        }
    }

    private void callbackTransactionSubmitted() {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionSubmitted();
        }
    }

    private void callbackTransactionFailed() {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionFailed();
        }
    }

    private void callbackTransactionCancelled() {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionCancelled();
        }
    }

    private void callbackTransactionComplete(TransactionResponse transactionDetails) {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionCompleted(transactionDetails);
        }
    }
}

