/*
 * Decompiled with CFR 0.152.
 */
package com.gpfreetech.views;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.os.AsyncTask;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import com.gpfreetech.utils.BitmapUtils;
import com.gpfreetech.views.R;

public class ScratchTextView
extends AppCompatTextView {
    public static final float STROKE_WIDTH = 15.0f;
    private float mX;
    private float mY;
    private static final float TOUCH_TOLERANCE = 4.0f;
    private Bitmap mScratchBitmap;
    private Canvas mCanvas;
    private Path mErasePath;
    private Path mTouchPath;
    private Paint mBitmapPaint;
    private Paint mErasePaint;
    private Paint mGradientBgPaint;
    private BitmapDrawable mDrawable;
    private IRevealListener mRevealListener;
    private float mRevealPercent;
    private int mThreadCount = 0;

    public ScratchTextView(Context context) {
        super(context);
        this.init();
    }

    public ScratchTextView(Context context, AttributeSet set) {
        super(context, set);
        this.init();
    }

    public ScratchTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setStrokeWidth(int multiplier) {
        this.mErasePaint.setStrokeWidth((float)multiplier * 15.0f);
    }

    private void init() {
        this.mTouchPath = new Path();
        this.mErasePaint = new Paint();
        this.mErasePaint.setAntiAlias(true);
        this.mErasePaint.setDither(true);
        this.mErasePaint.setColor(-65536);
        this.mErasePaint.setStyle(Paint.Style.STROKE);
        this.mErasePaint.setStrokeJoin(Paint.Join.BEVEL);
        this.mErasePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mErasePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.setStrokeWidth(6);
        this.mGradientBgPaint = new Paint();
        this.mErasePath = new Path();
        this.mBitmapPaint = new Paint(4);
        Bitmap scratchBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.ic_scratch_pattern);
        this.mDrawable = new BitmapDrawable(this.getResources(), scratchBitmap);
        this.mDrawable.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
    }

    public void setScratchImage(int id) {
        try {
            Bitmap scratchBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)id);
            this.mDrawable = new BitmapDrawable(this.getResources(), scratchBitmap);
            this.mDrawable.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
        }
        catch (Exception e) {
            e.printStackTrace();
            Bitmap scratchBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.ic_scratch_pattern);
            this.mDrawable = new BitmapDrawable(this.getResources(), scratchBitmap);
            this.mDrawable.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mScratchBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mCanvas = new Canvas(this.mScratchBitmap);
        Rect rect = new Rect(0, 0, this.mScratchBitmap.getWidth(), this.mScratchBitmap.getHeight());
        this.mDrawable.setBounds(rect);
        int startGradientColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.scratch_start_gradient);
        int endGradientColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.scratch_end_gradient);
        this.mGradientBgPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getHeight(), startGradientColor, endGradientColor, Shader.TileMode.MIRROR));
        this.mCanvas.drawRect(rect, this.mGradientBgPaint);
        this.mDrawable.draw(this.mCanvas);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawBitmap(this.mScratchBitmap, 0.0f, 0.0f, this.mBitmapPaint);
        canvas.drawPath(this.mErasePath, this.mErasePaint);
    }

    private void touch_start(float x, float y) {
        this.mErasePath.reset();
        this.mErasePath.moveTo(x, y);
        this.mX = x;
        this.mY = y;
    }

    private void touch_move(float x, float y) {
        float dx = Math.abs(x - this.mX);
        float dy = Math.abs(y - this.mY);
        if (dx >= 4.0f || dy >= 4.0f) {
            this.mErasePath.quadTo(this.mX, this.mY, (x + this.mX) / 2.0f, (y + this.mY) / 2.0f);
            this.mX = x;
            this.mY = y;
            this.drawPath();
        }
        this.mTouchPath.reset();
        this.mTouchPath.addCircle(this.mX, this.mY, 30.0f, Path.Direction.CW);
    }

    private void drawPath() {
        this.mErasePath.lineTo(this.mX, this.mY);
        this.mCanvas.drawPath(this.mErasePath, this.mErasePaint);
        this.mTouchPath.reset();
        this.mErasePath.reset();
        this.mErasePath.moveTo(this.mX, this.mY);
        this.checkRevealed();
    }

    public void reveal() {
        int[] bounds = this.getTextBounds(1.5f);
        int left = bounds[0];
        int top = bounds[1];
        int right = bounds[2];
        int bottom = bounds[3];
        Paint paint = new Paint();
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.mCanvas.drawRect((float)left, (float)top, (float)right, (float)bottom, paint);
        this.checkRevealed();
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.touch_start(x, y);
                this.invalidate();
                break;
            }
            case 2: {
                this.touch_move(x, y);
                this.invalidate();
                break;
            }
            case 1: {
                this.drawPath();
                this.invalidate();
                break;
            }
        }
        return true;
    }

    public int getColor() {
        return this.mErasePaint.getColor();
    }

    public void setRevealListener(IRevealListener listener) {
        this.mRevealListener = listener;
    }

    public boolean isRevealed() {
        return this.mRevealPercent == 1.0f;
    }

    private void checkRevealed() {
        if (!this.isRevealed() && this.mRevealListener != null) {
            int[] bounds = this.getTextBounds();
            int left = bounds[0];
            int top = bounds[1];
            int width = bounds[2] - left;
            int height = bounds[3] - top;
            if (this.mThreadCount > 1) {
                return;
            }
            ++this.mThreadCount;
            new AsyncTask<Integer, Void, Float>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Float doInBackground(Integer ... params) {
                    try {
                        int left = params[0];
                        int top = params[1];
                        int width = params[2];
                        int height = params[3];
                        Bitmap croppedBitmap = Bitmap.createBitmap((Bitmap)ScratchTextView.this.mScratchBitmap, (int)left, (int)top, (int)width, (int)height);
                        Float f = Float.valueOf(BitmapUtils.getTransparentPixelPercent(croppedBitmap));
                        return f;
                    }
                    finally {
                        ScratchTextView.this.mThreadCount--;
                    }
                }

                public void onPostExecute(Float percentRevealed) {
                    if (!ScratchTextView.this.isRevealed()) {
                        float oldValue = ScratchTextView.this.mRevealPercent;
                        ScratchTextView.this.mRevealPercent = percentRevealed.floatValue();
                        if (oldValue != percentRevealed.floatValue()) {
                            ScratchTextView.this.mRevealListener.onRevealPercentChangedListener(ScratchTextView.this, percentRevealed.floatValue());
                        }
                        if (ScratchTextView.this.isRevealed()) {
                            ScratchTextView.this.mRevealListener.onRevealed(ScratchTextView.this);
                        }
                    }
                }
            }.execute((Object[])new Integer[]{left, top, width, height});
        }
    }

    private static int[] getTextDimens(String text, Paint paint) {
        int end = text.length();
        Rect bounds = new Rect();
        paint.getTextBounds(text, 0, end, bounds);
        int width = bounds.left + bounds.width();
        int height = bounds.bottom + bounds.height();
        return new int[]{width, height};
    }

    private int[] getTextBounds() {
        return this.getTextBounds(1.0f);
    }

    private int[] getTextBounds(float scale) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int vwidth = this.getWidth();
        int vheight = this.getHeight();
        int centerX = vwidth / 2;
        int centerY = vheight / 2;
        TextPaint paint = this.getPaint();
        String text = this.getText().toString();
        int[] dimens = ScratchTextView.getTextDimens(text, (Paint)paint);
        int width = dimens[0];
        int height = dimens[1];
        int lines = this.getLineCount();
        width /= lines;
        int left = 0;
        int top = 0;
        height = (height *= lines) > vheight ? vheight - (paddingBottom + paddingTop) : (int)((float)height * scale);
        width = width > vwidth ? vwidth - (paddingLeft + paddingRight) : (int)((float)width * scale);
        int gravity = this.getGravity();
        if ((gravity & 3) == 3) {
            left = paddingLeft;
        } else if ((gravity & 5) == 5) {
            left = vwidth - paddingRight - width;
        } else if ((gravity & 1) == 1) {
            left = centerX - width / 2;
        }
        if ((gravity & 0x30) == 48) {
            top = paddingTop;
        } else if ((gravity & 0x50) == 80) {
            top = vheight - paddingBottom - height;
        } else if ((gravity & 0x10) == 16) {
            top = centerY - height / 2;
        }
        return new int[]{left, top, left + width, top + height};
    }

    public static interface IRevealListener {
        public void onRevealed(ScratchTextView var1);

        public void onRevealPercentChangedListener(ScratchTextView var1, float var2);
    }
}

