/*
 * Decompiled with CFR 0.152.
 */
package com.gpfreetech.utils;

import android.graphics.Bitmap;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class BitmapUtils {
    public static float compareEquivalance(Bitmap bitmap1, Bitmap bitmap2) {
        if (bitmap1 == null || bitmap2 == null || bitmap1.getWidth() != bitmap2.getWidth() || bitmap1.getHeight() != bitmap2.getHeight()) {
            return 0.0f;
        }
        ByteBuffer buffer1 = ByteBuffer.allocate(bitmap1.getHeight() * bitmap1.getRowBytes());
        bitmap1.copyPixelsToBuffer((Buffer)buffer1);
        ByteBuffer buffer2 = ByteBuffer.allocate(bitmap2.getHeight() * bitmap2.getRowBytes());
        bitmap2.copyPixelsToBuffer((Buffer)buffer2);
        byte[] array1 = buffer1.array();
        byte[] array2 = buffer2.array();
        int len = array1.length;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (array1[i] != array2[i]) continue;
            ++count;
        }
        return (float)count / (float)len;
    }

    public static float getTransparentPixelPercent(Bitmap bitmap) {
        if (bitmap == null) {
            return 0.0f;
        }
        ByteBuffer buffer = ByteBuffer.allocate(bitmap.getHeight() * bitmap.getRowBytes());
        bitmap.copyPixelsToBuffer((Buffer)buffer);
        byte[] array = buffer.array();
        int len = array.length;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (array[i] != 0) continue;
            ++count;
        }
        return (float)count / (float)len;
    }
}

