/*
 * Decompiled with CFR 0.152.
 */
package com.goyourfly.gdownloader.helper;

import android.content.Context;
import android.text.TextUtils;
import com.goyourfly.gdownloader.helper.DownloadHelper;
import com.goyourfly.gdownloader.utils.Ln;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DownloadHelperImpl
extends DownloadHelper {
    private int mMaxTask;
    private static ExecutorService mExecutor;
    private Context mContext;
    private Map<String, Downloader> mRequestQueue = new HashMap<String, Downloader>();
    private OkHttpClient mHttpClient;

    public DownloadHelperImpl(Context context, int maxTask) {
        this.mContext = context;
        mExecutor = Executors.newFixedThreadPool(maxTask);
        this.mMaxTask = maxTask;
        this.mHttpClient = new OkHttpClient();
    }

    @Override
    public int getRunningTaskCount() {
        return this.mRequestQueue.size();
    }

    @Override
    public void start(String url, File file, final DownloadHelper.DownloadListener downloadListener) {
        if (mExecutor == null || mExecutor.isShutdown()) {
            mExecutor = Executors.newFixedThreadPool(this.mMaxTask);
        }
        Ln.d("start");
        if (this.mRequestQueue.containsKey(url)) {
            return;
        }
        Ln.d("prepare create downloader");
        Downloader downloader = new Downloader(url, file, new DownloadHelper.DownloadListener(){

            @Override
            public void onPreStart(String url) {
                downloadListener.onPreStart(url);
            }

            @Override
            public void onStart(String url, long fileLength, long localFileSize) {
                downloadListener.onStart(url, fileLength, localFileSize);
            }

            @Override
            public void onProgress(String url, long totalLength, long downloadedBytes) {
                downloadListener.onProgress(url, totalLength, downloadedBytes);
            }

            @Override
            public void onPause(String url) {
                DownloadHelperImpl.this.mRequestQueue.remove(url);
                downloadListener.onPause(url);
            }

            @Override
            public void onWaiting(String url) {
                downloadListener.onWaiting(url);
            }

            @Override
            public void onCancel(String url) {
                DownloadHelperImpl.this.mRequestQueue.remove(url);
                downloadListener.onCancel(url);
            }

            @Override
            public void onFinish(String url) {
                DownloadHelperImpl.this.mRequestQueue.remove(url);
                downloadListener.onFinish(url);
            }

            @Override
            public void onError(String url, String err) {
                DownloadHelperImpl.this.mRequestQueue.remove(url);
                downloadListener.onError(url, err);
            }
        });
        Ln.d("put queue:" + this.getRunningTaskCount() + ":" + this.mMaxTask);
        this.mRequestQueue.put(url, downloader);
        if (this.getRunningTaskCount() > this.mMaxTask) {
            downloadListener.onWaiting(url);
        }
        mExecutor.execute(downloader);
    }

    @Override
    public void shutdown() {
        if (mExecutor != null && !mExecutor.isShutdown()) {
            mExecutor.shutdownNow();
        }
        mExecutor = null;
        this.mRequestQueue.clear();
    }

    @Override
    public boolean cancel(String url) {
        if (this.mRequestQueue.containsKey(url)) {
            this.mRequestQueue.get(url).cancel();
            return true;
        }
        return false;
    }

    @Override
    public boolean pause(String url) {
        if (this.mRequestQueue.containsKey(url)) {
            this.mRequestQueue.get(url).pause();
            return true;
        }
        return false;
    }

    protected class Downloader
    implements Runnable {
        private String url;
        private File file;
        private DownloadHelper.DownloadListener listener;
        private Boolean started = false;
        private Boolean cancel = false;
        private Boolean pause = false;
        private InputStream in;
        private long fileTotalLength;

        public Downloader(String url, File file, DownloadHelper.DownloadListener listener) {
            this.url = url;
            this.file = file;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Boolean bl = this.cancel;
            synchronized (bl) {
                this.cancel = true;
            }
            if (!this.started.booleanValue()) {
                this.listener.onCancel(this.url);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pause() {
            Boolean bl = this.pause;
            synchronized (bl) {
                this.pause = true;
            }
            if (!this.started.booleanValue()) {
                this.listener.onPause(this.url);
            }
        }

        private void download(String url, File file, DownloadHelper.DownloadListener listener) {
            if (this.cancel.booleanValue() || this.pause.booleanValue()) {
                return;
            }
            try {
                int count;
                Request.Builder builder = new Request.Builder().url(url);
                long localFileSize = 0L;
                if (file.exists()) {
                    localFileSize = file.length();
                }
                builder.header("Range", "bytes=" + localFileSize + "-");
                Response response = DownloadHelperImpl.this.mHttpClient.newCall(builder.build()).execute();
                String headerLength = response.header("Content-Length");
                if (!(TextUtils.isEmpty((CharSequence)headerLength) || headerLength.equals("0") || headerLength.equals("-1"))) {
                    this.fileTotalLength = Long.parseLong(headerLength) + localFileSize;
                }
                Ln.d("|-|-|-|-|-|-|-|-|-|Content-Length:" + this.fileTotalLength);
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code " + response);
                }
                long contentLength = this.fileTotalLength;
                listener.onStart(url, contentLength, localFileSize);
                this.in = response.body().byteStream();
                FileOutputStream fileOutputStream = new FileOutputStream(file, true);
                byte[] data = new byte[1024];
                long progress = 0L;
                while ((count = this.in.read(data)) != -1) {
                    if (this.cancel.booleanValue()) {
                        fileOutputStream.close();
                        this.in.close();
                        listener.onCancel(url);
                        return;
                    }
                    if (this.pause.booleanValue()) {
                        fileOutputStream.close();
                        this.in.close();
                        listener.onPause(url);
                        return;
                    }
                    if (!file.exists()) {
                        fileOutputStream.close();
                        this.in.close();
                        if (this.cancel.booleanValue()) {
                            listener.onCancel(url);
                        } else {
                            listener.onError(url, "File not exist");
                        }
                        return;
                    }
                    fileOutputStream.write(data, 0, count);
                    listener.onProgress(url, contentLength, localFileSize + (progress += (long)count));
                }
                fileOutputStream.close();
                this.in.close();
                listener.onFinish(url);
            }
            catch (InterruptedIOException e) {
                Ln.e("InterruptedIOException:" + e.getMessage());
                listener.onCancel(url);
            }
            catch (IOException e) {
                Ln.e("IOException:" + e.getMessage());
                listener.onError(url, e.getMessage());
            }
        }

        @Override
        public void run() {
            this.started = true;
            try {
                this.download(this.url, this.file, this.listener);
            }
            catch (RuntimeException runTimeException) {
                Ln.e("Run exception:" + runTimeException.getMessage());
                if (runTimeException.getMessage().contains("thread interrupted")) {
                    if (this.pause.booleanValue()) {
                        this.listener.onPause(this.url);
                    } else if (this.cancel.booleanValue()) {
                        this.listener.onCancel(this.url);
                    } else {
                        this.listener.onError(this.url, runTimeException.getMessage());
                    }
                }
                if (runTimeException.getMessage().contains("File not found")) {
                    if (this.pause.booleanValue()) {
                        this.listener.onPause(this.url);
                    } else if (this.cancel.booleanValue()) {
                        this.listener.onCancel(this.url);
                    } else {
                        this.listener.onError(this.url, runTimeException.getMessage());
                    }
                }
                this.listener.onError(this.url, runTimeException.getMessage());
            }
        }
    }
}

