/*
 * Decompiled with CFR 0.152.
 */
package com.goyourfly.gdownloader.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.goyourfly.gdownloader.db.DbVideoExtOpenHelper;
import java.util.ArrayList;
import java.util.List;

public class DbDownloadExt {
    public static final int DOWNLOAD_STATE_NOT_DOWNLOAD = 0;
    public static final int DOWNLOAD_STATE_DOWNLOADED = 2;
    public static final int DOWNLOAD_STATE_DOWNLOADING = 3;
    public static final int DOWNLOAD_STATE_PAUSE = 4;
    public static final int DOWNLOAD_STATE_ERROR = 5;
    public static final int DOWNLOAD_STATE_WAITING = 6;
    public static final int DOWNLOAD_STATE_PREPARING = 7;
    public static final String TABLE_VIDEO_DOWNLOAD = "video_download";
    public static final String COLUMN_ID = "_id";
    public static final String COLUMN_DOWNLOAD_URL = "url";
    public static final String COLUMN_DOWNLOAD_STATE = "state";
    public static final String COLUMN_DOWNLOAD_PROGRESS = "progress";
    public static final String COLUMN_DOWNLOAD_FILE_SIZE = "fileSize";
    public static final String COLUMN_DOWNLOAD_LAST_UPDATE_TIME = "updateTime";
    protected String url;
    protected int downloadState;
    protected long downloadProgress;
    protected long fileSize;
    protected long lastUpdateTime;

    public long getDownloadProgress() {
        return this.downloadProgress;
    }

    public void setDownloadProgress(long downloadProgress) {
        this.downloadProgress = downloadProgress;
    }

    public int getDownloadState() {
        return this.downloadState;
    }

    public void setDownloadState(int downloadState) {
        this.downloadState = downloadState;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public static class Helper {
        protected SQLiteDatabase mDb;
        protected static Helper mHelper;

        private Helper(Context context) {
            this.mDb = new DbVideoExtOpenHelper(context).getWritableDatabase();
        }

        public static Helper getInstance(Context context) {
            if (mHelper == null) {
                mHelper = new Helper(context);
            }
            return mHelper;
        }

        public String insertOrUpdate(DbDownloadExt dbDownloadExt) {
            ContentValues contentValues = new ContentValues();
            contentValues.put(DbDownloadExt.COLUMN_DOWNLOAD_URL, dbDownloadExt.url);
            contentValues.put(DbDownloadExt.COLUMN_DOWNLOAD_STATE, Integer.valueOf(dbDownloadExt.downloadState));
            contentValues.put(DbDownloadExt.COLUMN_DOWNLOAD_PROGRESS, Long.valueOf(dbDownloadExt.downloadProgress));
            contentValues.put(DbDownloadExt.COLUMN_DOWNLOAD_FILE_SIZE, Long.valueOf(dbDownloadExt.fileSize));
            contentValues.put(DbDownloadExt.COLUMN_DOWNLOAD_LAST_UPDATE_TIME, Long.valueOf(System.currentTimeMillis()));
            Cursor cursor = this.mDb.query(DbDownloadExt.TABLE_VIDEO_DOWNLOAD, null, "url = ?", new String[]{dbDownloadExt.url}, null, null, null);
            if (cursor.moveToNext()) {
                cursor.close();
                this.mDb.update(DbDownloadExt.TABLE_VIDEO_DOWNLOAD, contentValues, "url = ?", new String[]{dbDownloadExt.url});
            } else {
                cursor.close();
                this.mDb.insert(DbDownloadExt.TABLE_VIDEO_DOWNLOAD, null, contentValues);
            }
            return dbDownloadExt.url;
        }

        public String updateProgress(String url, long progress) {
            ContentValues contentValues = new ContentValues();
            contentValues.put(DbDownloadExt.COLUMN_DOWNLOAD_PROGRESS, Long.valueOf(progress));
            contentValues.put(DbDownloadExt.COLUMN_DOWNLOAD_LAST_UPDATE_TIME, Long.valueOf(System.currentTimeMillis()));
            this.mDb.update(DbDownloadExt.TABLE_VIDEO_DOWNLOAD, contentValues, "url = ?", new String[]{url});
            return url;
        }

        public String updateState(String url, int state) {
            ContentValues contentValues = new ContentValues();
            contentValues.put(DbDownloadExt.COLUMN_DOWNLOAD_STATE, Integer.valueOf(state));
            contentValues.put(DbDownloadExt.COLUMN_DOWNLOAD_LAST_UPDATE_TIME, Long.valueOf(System.currentTimeMillis()));
            this.mDb.update(DbDownloadExt.TABLE_VIDEO_DOWNLOAD, contentValues, "url = ?", new String[]{url});
            return url;
        }

        public String updateFileLength(String url, long length) {
            ContentValues contentValues = new ContentValues();
            contentValues.put(DbDownloadExt.COLUMN_DOWNLOAD_FILE_SIZE, Long.valueOf(length));
            contentValues.put(DbDownloadExt.COLUMN_DOWNLOAD_LAST_UPDATE_TIME, Long.valueOf(System.currentTimeMillis()));
            this.mDb.update(DbDownloadExt.TABLE_VIDEO_DOWNLOAD, contentValues, "url = ?", new String[]{url});
            return url;
        }

        public void delete(String url) {
            this.mDb.delete(DbDownloadExt.TABLE_VIDEO_DOWNLOAD, "url = ?", new String[]{url});
        }

        public DbDownloadExt queryDownloadExt(String url) {
            if (url == null) {
                return null;
            }
            Cursor cursor = this.mDb.query(DbDownloadExt.TABLE_VIDEO_DOWNLOAD, null, "url = ?", new String[]{url}, null, null, null);
            if (cursor.moveToNext()) {
                DbDownloadExt dbDownloadExt = this.cursorToDb(cursor);
                cursor.close();
                return dbDownloadExt;
            }
            cursor.close();
            return null;
        }

        private DbDownloadExt cursorToDb(Cursor cursor) {
            DbDownloadExt dbDownloadExt = new DbDownloadExt();
            dbDownloadExt.url = cursor.getString(cursor.getColumnIndex(DbDownloadExt.COLUMN_DOWNLOAD_URL));
            dbDownloadExt.downloadProgress = cursor.getLong(cursor.getColumnIndex(DbDownloadExt.COLUMN_DOWNLOAD_PROGRESS));
            dbDownloadExt.fileSize = cursor.getLong(cursor.getColumnIndex(DbDownloadExt.COLUMN_DOWNLOAD_FILE_SIZE));
            dbDownloadExt.downloadState = cursor.getInt(cursor.getColumnIndex(DbDownloadExt.COLUMN_DOWNLOAD_STATE));
            dbDownloadExt.lastUpdateTime = cursor.getLong(cursor.getColumnIndex(DbDownloadExt.COLUMN_DOWNLOAD_LAST_UPDATE_TIME));
            return dbDownloadExt;
        }

        public List<DbDownloadExt> queryAllDownloadExt() {
            ArrayList<DbDownloadExt> list = new ArrayList<DbDownloadExt>();
            Cursor cursor = this.mDb.query(DbDownloadExt.TABLE_VIDEO_DOWNLOAD, null, null, null, null, null, null);
            while (cursor.moveToNext()) {
                DbDownloadExt dbDownloadExt = this.cursorToDb(cursor);
                list.add(dbDownloadExt);
            }
            cursor.close();
            return list;
        }

        public List<DbDownloadExt> queryAllNotDownloadedExt() {
            ArrayList<DbDownloadExt> list = new ArrayList<DbDownloadExt>();
            Cursor cursor = this.mDb.query(DbDownloadExt.TABLE_VIDEO_DOWNLOAD, null, "state != ?", new String[]{"2"}, null, null, null);
            while (cursor.moveToNext()) {
                DbDownloadExt dbDownloadExt = this.cursorToDb(cursor);
                list.add(dbDownloadExt);
            }
            cursor.close();
            return list;
        }

        public List<DbDownloadExt> queryAllDownloadedExt() {
            ArrayList<DbDownloadExt> list = new ArrayList<DbDownloadExt>();
            Cursor cursor = this.mDb.query(DbDownloadExt.TABLE_VIDEO_DOWNLOAD, null, "state = ?", new String[]{"2"}, null, null, null);
            while (cursor.moveToNext()) {
                DbDownloadExt dbDownloadExt = this.cursorToDb(cursor);
                list.add(dbDownloadExt);
            }
            cursor.close();
            return list;
        }

        public void clear() {
            this.mDb.delete(DbDownloadExt.TABLE_VIDEO_DOWNLOAD, null, null);
        }
    }
}

