/*
 * Decompiled with CFR 0.152.
 */
package com.goyourfly.gdownloader;

import android.content.Context;
import android.support.annotation.Nullable;
import com.goyourfly.gdownloader.DownloadModule;
import com.goyourfly.gdownloader.db.DbDownloadExt;
import com.goyourfly.gdownloader.helper.DownloadFileHelper;
import com.goyourfly.gdownloader.helper.DownloadHelper;
import com.goyourfly.gdownloader.name_generator.HashCodeNameGenerator;
import com.goyourfly.gdownloader.name_generator.NameGenerator;
import com.goyourfly.gdownloader.utils.ByteUtils;
import com.goyourfly.gdownloader.utils.Ln;
import java.io.File;
import java.util.HashMap;
import java.util.List;

public class DownloadModuleImpl
extends DownloadModule {
    private Context mContext;
    private DownloadHelper.DownloadListener mDownloadListener;
    private HashMap<String, Integer> transformerMap = new HashMap();

    public DownloadModuleImpl(Context context, String path, int maxTask, @Nullable NameGenerator nameGenerator) {
        this.mContext = context;
        if (nameGenerator == null) {
            nameGenerator = new HashCodeNameGenerator();
        }
        DownloadFileHelper.init(path, nameGenerator);
        DownloadHelper.init(context, maxTask);
    }

    @Override
    public void download(String url) {
        DownloadHelper.DownloadListener listener = new DownloadHelper.DownloadListener(){

            @Override
            public void onPreStart(String url) {
                Ln.d("onPreStart:" + url);
                if (DbDownloadExt.Helper.getInstance(DownloadModuleImpl.this.mContext).queryDownloadExt(url) == null) {
                    DbDownloadExt dbDownloadExt1 = new DbDownloadExt();
                    dbDownloadExt1.setUrl(url);
                    dbDownloadExt1.setDownloadProgress(0L);
                    dbDownloadExt1.setDownloadState(7);
                    dbDownloadExt1.setLastUpdateTime(System.currentTimeMillis());
                    Ln.d("onPreStart:insert" + url);
                    DbDownloadExt.Helper.getInstance(DownloadModuleImpl.this.mContext).insertOrUpdate(dbDownloadExt1);
                } else {
                    DbDownloadExt.Helper.getInstance(DownloadModuleImpl.this.mContext).updateState(url, 7);
                }
                if (DownloadModuleImpl.this.mDownloadListener != null) {
                    DownloadModuleImpl.this.mDownloadListener.onPreStart(url);
                }
            }

            @Override
            public void onStart(String url, long fileLength, long localFileSize) {
                Ln.d("onStart-fileLength:" + ByteUtils.getMb(fileLength) + ",localFileSize:" + ByteUtils.getMb(localFileSize));
                DbDownloadExt.Helper.getInstance(DownloadModuleImpl.this.mContext).updateFileLength(url, fileLength);
                DbDownloadExt.Helper.getInstance(DownloadModuleImpl.this.mContext).updateState(url, 3);
                if (DownloadModuleImpl.this.mDownloadListener != null) {
                    DownloadModuleImpl.this.mDownloadListener.onStart(url, fileLength, localFileSize);
                }
            }

            @Override
            public void onProgress(String url, long totalLength, long downloadedBytes) {
                int transfer = (int)(downloadedBytes * 100L * 5L / totalLength);
                if (!DownloadModuleImpl.this.transformerMap.containsKey(url) || DownloadModuleImpl.this.transformerMap.containsKey(url) && (Integer)DownloadModuleImpl.this.transformerMap.get(url) != transfer) {
                    DbDownloadExt.Helper.getInstance(DownloadModuleImpl.this.mContext).updateProgress(url, downloadedBytes);
                    if (DownloadModuleImpl.this.mDownloadListener != null) {
                        DownloadModuleImpl.this.mDownloadListener.onProgress(url, totalLength, downloadedBytes);
                    }
                    DownloadModuleImpl.this.transformerMap.put(url, transfer);
                }
            }

            @Override
            public void onPause(String url) {
                Ln.d("OnPause:" + url);
                DownloadModuleImpl.this.transformerMap.remove(url);
                DbDownloadExt.Helper.getInstance(DownloadModuleImpl.this.mContext).updateState(url, 4);
                if (DownloadModuleImpl.this.mDownloadListener != null) {
                    DownloadModuleImpl.this.mDownloadListener.onPause(url);
                }
            }

            @Override
            public void onWaiting(String url) {
                Ln.d("onWaiting:" + url);
                DbDownloadExt.Helper.getInstance(DownloadModuleImpl.this.mContext).updateState(url, 6);
                if (DownloadModuleImpl.this.mDownloadListener != null) {
                    DownloadModuleImpl.this.mDownloadListener.onWaiting(url);
                }
            }

            @Override
            public void onCancel(String url) {
                Ln.d("onCancel:" + url);
                DownloadModuleImpl.this.transformerMap.remove(url);
                DbDownloadExt.Helper.getInstance(DownloadModuleImpl.this.mContext).delete(url);
                if (DownloadModuleImpl.this.mDownloadListener != null) {
                    DownloadModuleImpl.this.mDownloadListener.onCancel(url);
                }
            }

            @Override
            public void onFinish(String url) {
                Ln.d("onFinish:" + url);
                DownloadModuleImpl.this.transformerMap.remove(url);
                DbDownloadExt.Helper.getInstance(DownloadModuleImpl.this.mContext).updateState(url, 2);
                if (DownloadModuleImpl.this.mDownloadListener != null) {
                    DownloadModuleImpl.this.mDownloadListener.onFinish(url);
                }
            }

            @Override
            public void onError(String url, String err) {
                Ln.e("onError:url:" + url + ",err:" + err);
                DownloadModuleImpl.this.transformerMap.remove(url);
                DbDownloadExt.Helper.getInstance(DownloadModuleImpl.this.mContext).updateState(url, 5);
                if (DownloadModuleImpl.this.mDownloadListener != null) {
                    DownloadModuleImpl.this.mDownloadListener.onError(url, err);
                }
            }
        };
        listener.onPreStart(url);
        DownloadHelper.getInstance().start(url, DownloadFileHelper.getInstance().get(url), listener);
    }

    @Override
    public void pause(String url) {
        Ln.d("pause:url:" + url);
        DbDownloadExt.Helper.getInstance(this.mContext).updateState(url, 4);
        boolean result = DownloadHelper.getInstance().pause(url);
        if (!result) {
            this.mDownloadListener.onPause(url);
        }
    }

    @Override
    public void delete(String url) {
        Ln.d("delete:url:" + url);
        DownloadFileHelper.getInstance().delete(url);
        DbDownloadExt.Helper.getInstance(this.mContext).delete(url);
        boolean result = DownloadHelper.getInstance().cancel(url);
        if (!result) {
            this.mDownloadListener.onCancel(url);
        }
    }

    @Override
    public int getRunningTaskCount() {
        return DownloadHelper.getInstance().getRunningTaskCount();
    }

    @Override
    public void registerListener(DownloadHelper.DownloadListener listener) {
        this.mDownloadListener = listener;
    }

    @Override
    public void unRegisterListener() {
        this.mDownloadListener = null;
    }

    @Override
    public List<DbDownloadExt> getDownloading() {
        return DbDownloadExt.Helper.getInstance(this.mContext).queryAllNotDownloadedExt();
    }

    @Override
    public List<DbDownloadExt> getDownloaded() {
        return DbDownloadExt.Helper.getInstance(this.mContext).queryAllDownloadedExt();
    }

    @Override
    public DbDownloadExt getDownloadState(String url) {
        return DbDownloadExt.Helper.getInstance(this.mContext).queryDownloadExt(url);
    }

    @Override
    public File getFile(String url) {
        return DownloadFileHelper.getInstance().get(url);
    }

    @Override
    public void startAllWithoutPause() {
        List<DbDownloadExt> list = DbDownloadExt.Helper.getInstance(this.mContext).queryAllDownloadExt();
        Ln.d("startAllWithoutPause:list:" + list.toString());
        for (DbDownloadExt dbDownloadExt : list) {
            if (dbDownloadExt.getDownloadState() != 3 && dbDownloadExt.getDownloadState() != 6 && dbDownloadExt.getDownloadState() != 7) continue;
            Ln.d("startAllWithoutPause:url:" + dbDownloadExt.getUrl());
            this.download(dbDownloadExt.getUrl());
        }
    }

    @Override
    public void forceStartAll() {
        List<DbDownloadExt> list = DbDownloadExt.Helper.getInstance(this.mContext).queryAllDownloadExt();
        Ln.d("startAllWithoutPause:list:" + list.toString());
        for (DbDownloadExt dbDownloadExt : list) {
            if (dbDownloadExt.getDownloadState() != 4 && dbDownloadExt.getDownloadState() != 5) continue;
            Ln.d("startAllWithoutPause:url:" + dbDownloadExt.getUrl());
            this.download(dbDownloadExt.getUrl());
        }
    }

    @Override
    public void stopAll() {
        List<DbDownloadExt> list = DbDownloadExt.Helper.getInstance(this.mContext).queryAllDownloadExt();
        Ln.d("stopAll:list:" + list.toString());
        for (DbDownloadExt dbDownloadExt : list) {
            if (dbDownloadExt.getDownloadState() != 3 && dbDownloadExt.getDownloadState() != 6) continue;
            Ln.d("stopAll:url:" + dbDownloadExt.getUrl());
            this.pause(dbDownloadExt.getUrl());
        }
    }

    @Override
    public void deleteAllDownloaded() {
        List<DbDownloadExt> list = DbDownloadExt.Helper.getInstance(this.mContext).queryAllDownloadedExt();
        Ln.d("deleteAllDownloaded:list:" + list.toString());
        for (DbDownloadExt dbDownloadExt : list) {
            DownloadFileHelper.getInstance().delete(dbDownloadExt.getUrl());
            DbDownloadExt.Helper.getInstance(this.mContext).delete(dbDownloadExt.getUrl());
            Ln.d("deleteAllDownloaded:url:" + dbDownloadExt.getUrl());
            this.mDownloadListener.onCancel(dbDownloadExt.getUrl());
        }
    }

    @Override
    public void shutdown() {
        List<DbDownloadExt> list = DbDownloadExt.Helper.getInstance(this.mContext).queryAllNotDownloadedExt();
        Ln.d("shutdown");
        DownloadHelper.getInstance().shutdown();
        for (DbDownloadExt dbDownloadExt : list) {
            Ln.d("shutdown:" + dbDownloadExt.getUrl());
            DbDownloadExt.Helper.getInstance(this.mContext).updateState(dbDownloadExt.getUrl(), 4);
            this.mDownloadListener.onPause(dbDownloadExt.getUrl());
        }
    }

    @Override
    public void clearAll() {
        DownloadHelper.getInstance().shutdown();
        List<DbDownloadExt> list = DbDownloadExt.Helper.getInstance(this.mContext).queryAllDownloadExt();
        Ln.d("clearAll:list:" + list.toString());
        for (DbDownloadExt dbDownloadExt : list) {
            DbDownloadExt.Helper.getInstance(this.mContext).delete(dbDownloadExt.getUrl());
            if (dbDownloadExt.getDownloadState() == 0 || this.mDownloadListener == null) continue;
            this.mDownloadListener.onCancel(dbDownloadExt.getUrl());
            Ln.d("clearAll:url:" + dbDownloadExt.getUrl());
        }
        DownloadFileHelper.getInstance().clear();
    }
}

