/*
 * Decompiled with CFR 0.152.
 */
package com.goyourfly.gdownloader;

import android.content.Context;
import android.support.annotation.Nullable;
import com.goyourfly.gdownloader.DownloadModuleImpl;
import com.goyourfly.gdownloader.db.DbDownloadExt;
import com.goyourfly.gdownloader.helper.DownloadHelper;
import com.goyourfly.gdownloader.name_generator.NameGenerator;
import java.io.File;
import java.util.List;

public abstract class DownloadModule {
    private static DownloadModule mImpl;

    public static synchronized DownloadModule getInstance() {
        if (mImpl == null) {
            throw new NullPointerException("Please call init before getInstance()");
        }
        return mImpl;
    }

    public static synchronized DownloadModule init(Context context, String downloadPath, int maxTask, @Nullable NameGenerator nameGenerator) {
        if (mImpl == null) {
            mImpl = new DownloadModuleImpl(context, downloadPath, maxTask, nameGenerator);
        }
        return mImpl;
    }

    public abstract void download(String var1);

    public abstract void pause(String var1);

    public abstract void delete(String var1);

    public abstract int getRunningTaskCount();

    public abstract void registerListener(DownloadHelper.DownloadListener var1);

    public abstract void unRegisterListener();

    public abstract List<DbDownloadExt> getDownloading();

    public abstract List<DbDownloadExt> getDownloaded();

    public abstract DbDownloadExt getDownloadState(String var1);

    public abstract File getFile(String var1);

    public abstract void startAllWithoutPause();

    public abstract void forceStartAll();

    public abstract void stopAll();

    public abstract void deleteAllDownloaded();

    public abstract void shutdown();

    public abstract void clearAll();
}

