/*
 * Decompiled with CFR 0.152.
 */
package com.goyourfly.gdownloader.helper;

import android.content.Context;
import com.goyourfly.gdownloader.helper.DownloadHelperImpl;
import java.io.File;

public abstract class DownloadHelper {
    private static DownloadHelper mHelper;

    public static synchronized DownloadHelper init(Context context, int maxTask) {
        if (mHelper == null) {
            mHelper = new DownloadHelperImpl(context, maxTask);
        }
        return mHelper;
    }

    public static synchronized DownloadHelper getInstance() {
        if (mHelper == null) {
            throw new NullPointerException("DownloadHelper not init");
        }
        return mHelper;
    }

    public abstract void start(String var1, File var2, DownloadListener var3);

    public abstract int getRunningTaskCount();

    public abstract void shutdown();

    public abstract boolean cancel(String var1);

    public abstract boolean pause(String var1);

    public static interface DownloadListener {
        public void onPreStart(String var1);

        public void onStart(String var1, long var2, long var4);

        public void onProgress(String var1, long var2, long var4);

        public void onPause(String var1);

        public void onWaiting(String var1);

        public void onCancel(String var1);

        public void onFinish(String var1);

        public void onError(String var1, String var2);
    }
}

