/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazycode.lazysodium.interfaces;

import com.goterl.lazycode.lazysodium.LazySodium;
import com.goterl.lazycode.lazysodium.exceptions.SodiumException;

public interface KeyExchange {
    public static final int PUBLICKEYBYTES = 32;
    public static final int SECRETKEYBYTES = 32;
    public static final int SESSIONKEYBYTES = 32;
    public static final int SEEDBYTES = 32;
    public static final String PRIMITIVE = "x25519blake2b";

    public static interface Lazy {
        public KeyPair cryptoKxKeypair();

        public KeyPair cryptoKxKeypair(byte[] var1);

        public SessionPair cryptoKxClientSessionKeys(byte[] var1, byte[] var2, byte[] var3) throws SodiumException;

        public SessionPair cryptoKxClientSessionKeys(KeyPair var1, KeyPair var2) throws SodiumException;

        public SessionPair cryptoKxServerSessionKeys(byte[] var1, byte[] var2, byte[] var3) throws SodiumException;

        public SessionPair cryptoKxServerSessionKeys(KeyPair var1, KeyPair var2) throws SodiumException;
    }

    public static interface Native {
        public boolean cryptoKxKeypair(byte[] var1, byte[] var2);

        public boolean cryptoKxSeedKeypair(byte[] var1, byte[] var2, byte[] var3);

        public boolean cryptoKxClientSessionKeys(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

        public boolean cryptoKxServerSessionKeys(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);
    }

    public static class SessionPair {
        private byte[] rx;
        private byte[] tx;

        public SessionPair(byte[] rx, byte[] tx) {
            this.rx = rx;
            this.tx = tx;
        }

        public SessionPair(String rx, String tx) {
            this.rx = LazySodium.toBin(rx);
            this.tx = LazySodium.toBin(tx);
        }

        public byte[] getRx() {
            return this.rx;
        }

        public byte[] getTx() {
            return this.tx;
        }

        public String getRxString() {
            return LazySodium.toHex(this.rx);
        }

        public String getTxString() {
            return LazySodium.toHex(this.tx);
        }
    }

    public static class KeyPair {
        private byte[] secretKey;
        private byte[] publicKey;

        public KeyPair(byte[] publicKey, byte[] secretKey) {
            this.secretKey = secretKey;
            this.publicKey = publicKey;
        }

        public KeyPair(String publicKey, String secretKey) {
            this.secretKey = LazySodium.toBin(secretKey);
            this.publicKey = LazySodium.toBin(publicKey);
        }

        public byte[] getSecretKey() {
            return this.secretKey;
        }

        public byte[] getPublicKey() {
            return this.publicKey;
        }

        public String getSecretKeyString() {
            return LazySodium.toHex(this.secretKey);
        }

        public String getPublicKeyString() {
            return LazySodium.toHex(this.publicKey);
        }
    }
}

