/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import com.google.ar.sceneform.FrameTime;
import com.google.ar.sceneform.Node;
import com.google.ar.sceneform.math.MathHelper;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.ux.BaseTransformableNode;
import com.google.ar.sceneform.ux.BaseTransformationController;
import com.google.ar.sceneform.ux.PinchGesture;
import com.google.ar.sceneform.ux.PinchGestureRecognizer;

public class ScaleController
extends BaseTransformationController<PinchGesture> {
    public static final float DEFAULT_MIN_SCALE = 0.75f;
    public static final float DEFAULT_MAX_SCALE = 1.75f;
    public static final float DEFAULT_SENSITIVITY = 0.75f;
    public static final float DEFAULT_ELASTICITY = 0.15f;
    private float minScale = 0.75f;
    private float maxScale = 1.75f;
    private float sensitivity = 0.75f;
    private float elasticity = 0.15f;
    private float currentScaleRatio;
    private static final float ELASTIC_RATIO_LIMIT = 0.8f;
    private static final float LERP_SPEED = 8.0f;

    public ScaleController(BaseTransformableNode transformableNode, PinchGestureRecognizer gestureRecognizer) {
        super(transformableNode, gestureRecognizer);
    }

    public void setMinScale(float minScale) {
        this.minScale = minScale;
    }

    public float getMinScale() {
        return this.minScale;
    }

    public void setMaxScale(float maxScale) {
        this.maxScale = maxScale;
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public void setSensitivity(float sensitivity) {
        this.sensitivity = sensitivity;
    }

    public float getSensitivity() {
        return this.sensitivity;
    }

    public void setElasticity(float elasticity) {
        this.elasticity = elasticity;
    }

    public float getElasticity() {
        return this.elasticity;
    }

    @Override
    public void onActivated(Node node) {
        super.onActivated(node);
        Vector3 scale = this.getTransformableNode().getLocalScale();
        this.currentScaleRatio = (scale.x - this.minScale) / this.getScaleDelta();
    }

    @Override
    public void onUpdated(Node node, FrameTime frameTime) {
        if (this.isTransforming() || !this.isEnabled()) {
            return;
        }
        float t = MathHelper.clamp((float)(frameTime.getDeltaSeconds() * 8.0f), (float)0.0f, (float)1.0f);
        this.currentScaleRatio = MathHelper.lerp((float)this.currentScaleRatio, (float)this.getClampedScaleRatio(), (float)t);
        float finalScaleValue = this.getFinalScale();
        Vector3 finalScale = new Vector3(finalScaleValue, finalScaleValue, finalScaleValue);
        this.getTransformableNode().setLocalScale(finalScale);
    }

    @Override
    public boolean canStartTransformation(PinchGesture gesture) {
        return this.getTransformableNode().isSelected();
    }

    @Override
    public void onContinueTransformation(PinchGesture gesture) {
        this.currentScaleRatio += gesture.gapDeltaInches() * this.sensitivity;
        float finalScaleValue = this.getFinalScale();
        Vector3 finalScale = new Vector3(finalScaleValue, finalScaleValue, finalScaleValue);
        this.getTransformableNode().setLocalScale(finalScale);
        if (this.currentScaleRatio < -0.8f || this.currentScaleRatio > 1.8f) {
            gesture.cancel();
        }
    }

    @Override
    public void onEndTransformation(PinchGesture gesture) {
    }

    private float getScaleDelta() {
        float scaleDelta = this.maxScale - this.minScale;
        if (scaleDelta <= 0.0f) {
            throw new IllegalStateException("maxScale must be greater than minScale.");
        }
        return scaleDelta;
    }

    private float getClampedScaleRatio() {
        return Math.min(1.0f, Math.max(0.0f, this.currentScaleRatio));
    }

    private float getFinalScale() {
        float elasticScaleRatio = this.getClampedScaleRatio() + this.getElasticDelta();
        float elasticScale = this.minScale + elasticScaleRatio * this.getScaleDelta();
        return elasticScale;
    }

    private float getElasticDelta() {
        float overRatio;
        if (this.currentScaleRatio > 1.0f) {
            overRatio = this.currentScaleRatio - 1.0f;
        } else if (this.currentScaleRatio < 0.0f) {
            overRatio = this.currentScaleRatio;
        } else {
            return 0.0f;
        }
        return (1.0f - 1.0f / (Math.abs(overRatio) * this.elasticity + 1.0f)) * Math.signum(overRatio);
    }
}

