/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.ar.sceneform.ux.R;
import java.util.HashMap;
import java.util.Map;

public class InstructionsController {
    public static final int TYPE_PLANE_DISCOVERY = 0;
    public static final int TYPE_AUGMENTED_IMAGE_SCAN = 1;
    protected LayoutInflater inflater;
    protected FrameLayout container;
    private final Map<Integer, View> views = new HashMap<Integer, View>();
    private boolean isVisible = true;
    private final Map<Integer, Boolean> typesVisibilities = new HashMap<Integer, Boolean>();
    private boolean isEnabled = true;
    private final Map<Integer, Boolean> typesEnabled = new HashMap<Integer, Boolean>();

    public InstructionsController(LayoutInflater inflater, FrameLayout container) {
        this.inflater = inflater;
        this.container = container;
    }

    protected View onCreateView(int type) {
        View view = null;
        switch (type) {
            case 0: {
                view = this.inflater.inflate(R.layout.sceneform_instructions_plane_discovery, (ViewGroup)this.container, false);
                break;
            }
            case 1: {
                view = this.inflater.inflate(R.layout.sceneform_instructions_augmented_image, (ViewGroup)this.container, false);
            }
        }
        if (view != null) {
            this.container.addView(view);
        }
        return view;
    }

    public void setView(int type, View view) {
        this.views.put(type, view);
        this.updateVisibility();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isEnabled(int type) {
        return this.typesEnabled.getOrDefault(type, true);
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            this.updateVisibility();
        }
    }

    public void setEnabled(int type, boolean enable) {
        if (this.isEnabled(type) != enable) {
            this.typesEnabled.put(type, enable);
            this.updateVisibility();
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isVisible(int type) {
        return this.typesVisibilities.getOrDefault(type, false);
    }

    public void setVisible(boolean visible) {
        if (this.isVisible != visible) {
            this.isVisible = visible;
            this.updateVisibility();
        }
    }

    public void setVisible(int type, boolean visible) {
        if (this.isVisible(type) != visible) {
            this.typesVisibilities.put(type, visible);
            this.updateVisibility();
        }
    }

    private void updateVisibility() {
        for (int type : this.typesVisibilities.keySet()) {
            boolean isVisible = this.isEnabled() && this.isVisible() && this.isEnabled(type) && this.isVisible(type);
            View view = this.views.get(type);
            if (isVisible && view == null) {
                view = this.onCreateView(type);
                this.views.put(type, view);
            }
            if (view == null) continue;
            view.setVisibility(isVisible ? 0 : 8);
        }
    }
}

