/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;

public class HandMotionAnimation
extends Animation {
    private final View handImageView;
    private final View containerView;
    private static final float TWO_PI = (float)Math.PI * 2;
    private static final float HALF_PI = 1.5707964f;

    public HandMotionAnimation(View containerView, View handImageView) {
        this.handImageView = handImageView;
        this.containerView = containerView;
    }

    protected void applyTransformation(float interpolatedTime, Transformation transformation) {
        float startAngle = 1.5707964f;
        float progressAngle = (float)Math.PI * 2 * interpolatedTime;
        float currentAngle = startAngle + progressAngle;
        float handWidth = this.handImageView.getWidth();
        float radius = this.handImageView.getResources().getDisplayMetrics().density * 25.0f;
        float xPos = radius * 2.0f * (float)Math.cos(currentAngle);
        float yPos = radius * (float)Math.sin(currentAngle);
        xPos += (float)this.containerView.getWidth() / 2.0f;
        yPos += (float)this.containerView.getHeight() / 2.0f;
        this.handImageView.setX(xPos -= handWidth / 2.0f);
        this.handImageView.setY(yPos -= (float)this.handImageView.getHeight() / 2.0f);
        this.handImageView.invalidate();
    }
}

