/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import android.view.MotionEvent;
import com.google.ar.sceneform.HitTestResult;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.ux.BaseGesture;
import com.google.ar.sceneform.ux.GesturePointersUtility;

public class DragGesture
extends BaseGesture<DragGesture> {
    private static final String TAG = DragGesture.class.getSimpleName();
    private final Vector3 startPosition;
    private final Vector3 position;
    private final Vector3 delta;
    private final int pointerId;
    private static final float SLOP_INCHES = 0.1f;
    private static final boolean DRAG_GESTURE_DEBUG = false;

    public DragGesture(GesturePointersUtility gesturePointersUtility, HitTestResult hitTestResult, MotionEvent motionEvent) {
        super(gesturePointersUtility);
        this.pointerId = motionEvent.getPointerId(motionEvent.getActionIndex());
        this.startPosition = GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId);
        this.position = new Vector3(this.startPosition);
        this.delta = Vector3.zero();
        this.targetNode = hitTestResult.getNode();
        DragGesture.debugLog("Created: " + this.pointerId);
    }

    public Vector3 getPosition() {
        return new Vector3(this.position);
    }

    public Vector3 getDelta() {
        return new Vector3(this.delta);
    }

    @Override
    protected boolean canStart(HitTestResult hitTestResult, MotionEvent motionEvent) {
        float slopPixels;
        Vector3 newPosition;
        float diff;
        int actionId = motionEvent.getPointerId(motionEvent.getActionIndex());
        int action = motionEvent.getActionMasked();
        if (this.gesturePointersUtility.isPointerIdRetained(this.pointerId)) {
            this.cancel();
            return false;
        }
        if (actionId == this.pointerId && (action == 1 || action == 6)) {
            this.cancel();
            return false;
        }
        if (action == 3) {
            this.cancel();
            return false;
        }
        if (action != 2) {
            return false;
        }
        if (motionEvent.getPointerCount() > 1) {
            for (int i = 0; i < motionEvent.getPointerCount(); ++i) {
                int id2 = motionEvent.getPointerId(i);
                if (id2 == this.pointerId || this.gesturePointersUtility.isPointerIdRetained(id2)) continue;
                return false;
            }
        }
        return (diff = Vector3.subtract((Vector3)(newPosition = GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId)), (Vector3)this.startPosition).length()) >= (slopPixels = this.gesturePointersUtility.inchesToPixels(0.1f));
    }

    @Override
    protected void onStart(HitTestResult hitTestResult, MotionEvent motionEvent) {
        DragGesture.debugLog("Started: " + this.pointerId);
        this.position.set(GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId));
        this.gesturePointersUtility.retainPointerId(this.pointerId);
    }

    @Override
    protected boolean updateGesture(HitTestResult hitTestResult, MotionEvent motionEvent) {
        int actionId = motionEvent.getPointerId(motionEvent.getActionIndex());
        int action = motionEvent.getActionMasked();
        if (action == 2) {
            Vector3 newPosition = GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId);
            if (!Vector3.equals((Vector3)newPosition, (Vector3)this.position)) {
                this.delta.set(Vector3.subtract((Vector3)newPosition, (Vector3)this.position));
                this.position.set(newPosition);
                DragGesture.debugLog("Updated: " + this.pointerId + " : " + this.position);
                return true;
            }
        } else if (actionId == this.pointerId && (action == 1 || action == 6)) {
            this.complete();
        } else if (action == 3) {
            this.cancel();
        }
        return false;
    }

    @Override
    protected void onCancel() {
        DragGesture.debugLog("Cancelled: " + this.pointerId);
    }

    @Override
    protected void onFinish() {
        DragGesture.debugLog("Finished: " + this.pointerId);
        this.gesturePointersUtility.releasePointerId(this.pointerId);
    }

    @Override
    protected DragGesture getSelf() {
        return this;
    }

    private static void debugLog(String log) {
    }

    public static interface OnGestureEventListener
    extends BaseGesture.OnGestureEventListener<DragGesture> {
    }
}

