/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import com.google.ar.sceneform.FrameTime;
import com.google.ar.sceneform.Node;
import com.google.ar.sceneform.ux.BaseGesture;
import com.google.ar.sceneform.ux.BaseGestureRecognizer;
import com.google.ar.sceneform.ux.BaseTransformableNode;

public abstract class BaseTransformationController<T extends BaseGesture<T>>
implements BaseGestureRecognizer.OnGestureStartedListener<T>,
BaseGesture.OnGestureEventListener<T>,
Node.LifecycleListener {
    private final BaseTransformableNode transformableNode;
    private final BaseGestureRecognizer<T> gestureRecognizer;
    @Nullable
    private T activeGesture;
    private boolean enabled;
    private boolean activeAndEnabled;

    public BaseTransformationController(BaseTransformableNode transformableNode, BaseGestureRecognizer<T> gestureRecognizer) {
        this.transformableNode = transformableNode;
        this.transformableNode.addLifecycleListener(this);
        this.gestureRecognizer = gestureRecognizer;
        this.setEnabled(true);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public T getActiveGesture() {
        return this.activeGesture;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateActiveAndEnabled();
    }

    public boolean isTransforming() {
        return this.activeGesture != null;
    }

    public BaseTransformableNode getTransformableNode() {
        return this.transformableNode;
    }

    @CallSuper
    public void onActivated(Node node) {
        this.updateActiveAndEnabled();
    }

    public void onUpdated(Node node, FrameTime frameTime) {
    }

    @CallSuper
    public void onDeactivated(Node node) {
        this.updateActiveAndEnabled();
    }

    @Override
    public void onGestureStarted(T gesture) {
        if (this.isTransforming()) {
            return;
        }
        if (this.canStartTransformation(gesture)) {
            this.setActiveGesture(gesture);
        }
    }

    @Override
    public void onUpdated(T gesture) {
        this.onContinueTransformation(gesture);
    }

    @Override
    public void onFinished(T gesture) {
        this.onEndTransformation(gesture);
        this.setActiveGesture(null);
    }

    protected abstract boolean canStartTransformation(T var1);

    protected abstract void onContinueTransformation(T var1);

    protected abstract void onEndTransformation(T var1);

    private void setActiveGesture(@Nullable T gesture) {
        if (this.activeGesture != null) {
            ((BaseGesture)this.activeGesture).setGestureEventListener(null);
        }
        this.activeGesture = gesture;
        if (this.activeGesture != null) {
            ((BaseGesture)this.activeGesture).setGestureEventListener(this);
        }
    }

    private void updateActiveAndEnabled() {
        boolean newActiveAndEnabled;
        boolean bl = newActiveAndEnabled = this.getTransformableNode().isActive() && this.enabled;
        if (newActiveAndEnabled == this.activeAndEnabled) {
            return;
        }
        this.activeAndEnabled = newActiveAndEnabled;
        if (this.activeAndEnabled) {
            this.connectToRecognizer();
        } else {
            this.disconnectFromRecognizer();
            if (this.activeGesture != null) {
                ((BaseGesture)this.activeGesture).cancel();
            }
        }
    }

    private void connectToRecognizer() {
        this.gestureRecognizer.addOnGestureStartedListener(this);
    }

    private void disconnectFromRecognizer() {
        this.gestureRecognizer.removeOnGestureStartedListener(this);
    }
}

