/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.widget.FrameLayout;
import android.widget.Toast;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.google.ar.core.ArCoreApk;
import com.google.ar.core.AugmentedFace;
import com.google.ar.core.AugmentedImage;
import com.google.ar.core.AugmentedImageDatabase;
import com.google.ar.core.CameraConfig;
import com.google.ar.core.Config;
import com.google.ar.core.Frame;
import com.google.ar.core.HitResult;
import com.google.ar.core.Plane;
import com.google.ar.core.Session;
import com.google.ar.core.Trackable;
import com.google.ar.core.TrackingState;
import com.google.ar.core.exceptions.UnavailableApkTooOldException;
import com.google.ar.core.exceptions.UnavailableArcoreNotInstalledException;
import com.google.ar.core.exceptions.UnavailableDeviceNotCompatibleException;
import com.google.ar.core.exceptions.UnavailableException;
import com.google.ar.core.exceptions.UnavailableSdkTooOldException;
import com.google.ar.sceneform.ArSceneView;
import com.google.ar.sceneform.FrameTime;
import com.google.ar.sceneform.HitTestResult;
import com.google.ar.sceneform.Scene;
import com.google.ar.sceneform.rendering.ModelRenderable;
import com.google.ar.sceneform.ux.FootprintSelectionVisualizer;
import com.google.ar.sceneform.ux.InstructionsController;
import com.google.ar.sceneform.ux.R;
import com.google.ar.sceneform.ux.TransformationSystem;
import com.gorisse.thomas.sceneform.ArSceneViewKt;
import com.gorisse.thomas.sceneform.light.LightEstimationConfig;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

public abstract class BaseArFragment
extends Fragment
implements Scene.OnPeekTouchListener,
Scene.OnUpdateListener {
    public static final String ARGUMENT_FULLSCREEN = "fullscreen";
    private static final String TAG = BaseArFragment.class.getSimpleName();
    private boolean installRequested;
    private boolean sessionInitializationFailed = false;
    private ArSceneView arSceneView;
    private InstructionsController instructionsController;
    private TransformationSystem transformationSystem;
    private GestureDetector gestureDetector;
    private FrameLayout frameLayout;
    private boolean isStarted;
    private boolean canRequestDangerousPermissions = true;
    private boolean fullscreen = true;
    private final ViewTreeObserver.OnWindowFocusChangeListener onFocusListener = hasFocus -> this.onWindowFocusChanged(hasFocus);
    private boolean isAugmentedImageDatabaseEnabled = true;
    @Nullable
    private OnSessionConfigurationListener onSessionConfigurationListener;
    @Nullable
    private OnTapArPlaneListener onTapArPlaneListener;
    @Nullable
    private OnAugmentedImageUpdateListener onAugmentedImageUpdateListener;
    @Nullable
    private OnAugmentedFaceUpdateListener onAugmentedFaceUpdateListener;

    public ArSceneView getArSceneView() {
        return this.arSceneView;
    }

    public InstructionsController getInstructionsController() {
        return this.instructionsController;
    }

    public void setInstructionsController(InstructionsController instructionsController) {
        this.instructionsController = instructionsController;
    }

    public TransformationSystem getTransformationSystem() {
        return this.transformationSystem;
    }

    public void setOnSessionConfigurationListener(@Nullable OnSessionConfigurationListener onSessionConfigurationListener) {
        this.onSessionConfigurationListener = onSessionConfigurationListener;
    }

    public void setOnTapArPlaneListener(@Nullable OnTapArPlaneListener onTapArPlaneListener) {
        this.onTapArPlaneListener = onTapArPlaneListener;
    }

    public void setOnAugmentedImageUpdateListener(@Nullable OnAugmentedImageUpdateListener listener) {
        this.onAugmentedImageUpdateListener = listener;
    }

    public void setOnAugmentedFaceUpdateListener(@Nullable OnAugmentedFaceUpdateListener listener) {
        this.onAugmentedFaceUpdateListener = listener;
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.frameLayout = (FrameLayout)inflater.inflate(R.layout.sceneform_ux_fragment_layout, container, false);
        this.arSceneView = (ArSceneView)this.frameLayout.findViewById(R.id.sceneform_ar_scene_view);
        this.arSceneView.setOnSessionConfigChangeListener(this::onSessionConfigChanged);
        this.instructionsController = new InstructionsController(inflater, this.frameLayout);
        this.instructionsController.setEnabled(0, true);
        if (Build.VERSION.SDK_INT < 24) {
            return this.frameLayout;
        }
        this.transformationSystem = this.makeTransformationSystem();
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent e) {
                BaseArFragment.this.onSingleTap(e);
                return true;
            }

            public boolean onDown(MotionEvent e) {
                return true;
            }
        });
        this.arSceneView.getScene().addOnPeekTouchListener((Scene.OnPeekTouchListener)this);
        this.arSceneView.getScene().addOnUpdateListener((Scene.OnUpdateListener)this);
        if (this.isArRequired()) {
            this.requestDangerousPermissions();
        }
        this.arSceneView.getViewTreeObserver().addOnWindowFocusChangeListener(this.onFocusListener);
        return this.frameLayout;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        Bundle arguments = this.getArguments();
        if (arguments != null) {
            this.fullscreen = arguments.getBoolean(ARGUMENT_FULLSCREEN, true);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.arSceneView.getViewTreeObserver().removeOnWindowFocusChangeListener(this.onFocusListener);
    }

    public void onResume() {
        super.onResume();
        if (this.isArRequired() && this.arSceneView.getSession() == null) {
            this.initializeSession();
        }
        this.resume();
    }

    public void resume() {
        if (this.isStarted) {
            return;
        }
        if (this.getActivity() != null) {
            this.isStarted = true;
            try {
                this.arSceneView.resume();
            }
            catch (Exception ex) {
                this.sessionInitializationFailed = true;
            }
            if (!this.sessionInitializationFailed && this.getInstructionsController() != null) {
                this.getInstructionsController().setVisible(true);
            }
        }
    }

    public void onPause() {
        super.onPause();
        this.pause();
    }

    public void pause() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        if (this.getInstructionsController() != null) {
            this.getInstructionsController().setVisible(false);
        }
        this.arSceneView.pause();
    }

    public void onDestroy() {
        this.destroy();
        super.onDestroy();
    }

    public void destroy() {
        this.pause();
        this.arSceneView.destroy();
    }

    public void destroySession() {
        this.arSceneView.destroySession();
    }

    public abstract boolean isArRequired();

    public String[] getAdditionalPermissions() {
        return new String[0];
    }

    protected void requestDangerousPermissions() {
        if (!this.canRequestDangerousPermissions) {
            return;
        }
        this.canRequestDangerousPermissions = false;
        ArrayList<String> permissions = new ArrayList<String>();
        String[] additionalPermissions = this.getAdditionalPermissions();
        int permissionLength = additionalPermissions != null ? additionalPermissions.length : 0;
        for (int i = 0; i < permissionLength; ++i) {
            if (ActivityCompat.checkSelfPermission((Context)this.requireActivity(), (String)additionalPermissions[i]) == 0) continue;
            permissions.add(additionalPermissions[i]);
        }
        if (ActivityCompat.checkSelfPermission((Context)this.requireActivity(), (String)"android.permission.CAMERA") != 0) {
            permissions.add("android.permission.CAMERA");
        }
        if (!permissions.isEmpty()) {
            ActivityResultLauncher requestMultiplePermissions = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestMultiplePermissions(), results -> results.forEach((key, value) -> {
                if (key.equals("android.permission.CAMERA")) {
                    if (!value.booleanValue()) {
                        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.requireActivity(), 16974374);
                        builder.setTitle(R.string.sceneform_camera_permission_required).setMessage(R.string.sceneform_add_camera_permission_via_settings).setPositiveButton(17039370, (dialog, which) -> {
                            Intent intent = new Intent();
                            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                            intent.setData(Uri.fromParts((String)"package", (String)this.requireActivity().getPackageName(), null));
                            this.requireActivity().startActivity(intent);
                            this.setCanRequestDangerousPermissions(true);
                        }).setNegativeButton(0x1040000, null).setIcon(17301543).setOnDismissListener(arg0 -> {
                            if (!this.getCanRequestDangerousPermissions().booleanValue()) {
                                this.requireActivity().finish();
                            }
                        }).show();
                    }
                } else if (!value.booleanValue()) {
                    this.requireActivity().finish();
                }
            }));
            requestMultiplePermissions.launch((Object)permissions.toArray(new String[0]));
        }
    }

    protected Boolean getCanRequestDangerousPermissions() {
        return this.canRequestDangerousPermissions;
    }

    protected void setCanRequestDangerousPermissions(Boolean canRequestDangerousPermissions) {
        this.canRequestDangerousPermissions = canRequestDangerousPermissions;
    }

    protected final boolean requestInstall() throws UnavailableException {
        switch (ArCoreApk.getInstance().requestInstall((Activity)this.requireActivity(), !this.installRequested)) {
            case INSTALL_REQUESTED: {
                this.installRequested = true;
                return true;
            }
        }
        return false;
    }

    protected final void initializeSession() {
        if (this.sessionInitializationFailed) {
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)this.requireActivity(), (String)"android.permission.CAMERA") == 0) {
            UnavailableException sessionException = null;
            try {
                if (this.requestInstall()) {
                    return;
                }
                Session session = this.onCreateSession();
                Config config = this.onCreateSessionConfig(session);
                if (this.onSessionConfigurationListener != null) {
                    this.onSessionConfigurationListener.onSessionConfiguration(session, config);
                }
                if (session.getCameraConfig().getFacingDirection() == CameraConfig.FacingDirection.FRONT && config.getLightEstimationMode() == Config.LightEstimationMode.ENVIRONMENTAL_HDR) {
                    config.setLightEstimationMode(Config.LightEstimationMode.DISABLED);
                }
                session.configure(config);
                this.setSession(session);
                return;
            }
            catch (UnavailableException e) {
                sessionException = e;
            }
            catch (Exception e) {
                sessionException = new UnavailableException();
                sessionException.initCause((Throwable)e);
            }
            this.sessionInitializationFailed = true;
            this.onArUnavailableException(sessionException);
        } else {
            this.requestDangerousPermissions();
        }
    }

    private Session onCreateSession() throws UnavailableSdkTooOldException, UnavailableDeviceNotCompatibleException, UnavailableArcoreNotInstalledException, UnavailableApkTooOldException {
        return new Session((Context)this.requireActivity());
    }

    protected Config onCreateSessionConfig(Session session) {
        LightEstimationConfig lightEstimationConfig;
        Config config = new Config(session);
        LightEstimationConfig lightEstimationConfig2 = lightEstimationConfig = this.getArSceneView() != null ? ArSceneViewKt.getLightEstimationConfig((ArSceneView)this.getArSceneView()) : null;
        if (lightEstimationConfig != null) {
            config.setLightEstimationMode(lightEstimationConfig.getMode());
        }
        config.setDepthMode(Config.DepthMode.DISABLED);
        config.setPlaneFindingMode(Config.PlaneFindingMode.HORIZONTAL_AND_VERTICAL);
        config.setFocusMode(Config.FocusMode.AUTO);
        config.setUpdateMode(Config.UpdateMode.LATEST_CAMERA_IMAGE);
        return config;
    }

    public void setSession(Session session) {
        this.getArSceneView().setSession(session);
    }

    public void setSessionConfig(Config config, boolean configureSession) {
        this.getArSceneView().setSessionConfig(config, configureSession);
    }

    protected void onSessionConfigChanged(Config config) {
        InstructionsController instructionsController = this.getInstructionsController();
        if (instructionsController != null) {
            instructionsController.setEnabled(0, config.getPlaneFindingMode() != Config.PlaneFindingMode.DISABLED);
            AugmentedImageDatabase augmentedImageDatabase = config.getAugmentedImageDatabase();
            instructionsController.setEnabled(1, augmentedImageDatabase != null && augmentedImageDatabase.getNumImages() > 0);
        }
    }

    protected TransformationSystem makeTransformationSystem() {
        FootprintSelectionVisualizer selectionVisualizer = new FootprintSelectionVisualizer();
        TransformationSystem transformationSystem = new TransformationSystem(this.getResources().getDisplayMetrics(), selectionVisualizer);
        this.setupSelectionRenderable(selectionVisualizer);
        return transformationSystem;
    }

    protected void setupSelectionRenderable(FootprintSelectionVisualizer selectionVisualizer) {
        ((CompletableFuture)((ModelRenderable.Builder)((ModelRenderable.Builder)ModelRenderable.builder().setSource((Context)this.getActivity(), R.raw.sceneform_footprint)).setIsFilamentGltf(true)).build().thenAccept(renderable -> {
            if (selectionVisualizer.getFootprintRenderable() == null) {
                selectionVisualizer.setFootprintRenderable((ModelRenderable)renderable);
            }
        })).exceptionally(throwable -> {
            Toast toast = Toast.makeText((Context)this.getContext(), (CharSequence)"Unable to load footprint renderable", (int)1);
            toast.setGravity(17, 0, 0);
            toast.show();
            return null;
        });
    }

    protected abstract void onArUnavailableException(UnavailableException var1);

    protected void onWindowFocusChanged(boolean hasFocus) {
        FragmentActivity activity = this.getActivity();
        if (hasFocus && activity != null && this.fullscreen) {
            activity.getWindow().addFlags(128);
            if (Build.VERSION.SDK_INT >= 30) {
                WindowInsetsController controller = activity.getWindow().getInsetsController();
                if (controller != null) {
                    controller.hide(WindowInsets.Type.statusBars() | WindowInsets.Type.navigationBars());
                    controller.setSystemBarsBehavior(2);
                }
            } else {
                activity.getWindow().getDecorView().setSystemUiVisibility(5894);
            }
        }
    }

    public void onPeekTouch(HitTestResult hitTestResult, MotionEvent motionEvent) {
        this.transformationSystem.onTouch(hitTestResult, motionEvent);
        if (hitTestResult.getNode() == null) {
            this.gestureDetector.onTouchEvent(motionEvent);
        }
    }

    public void onUpdate(FrameTime frameTime) {
        if (this.getArSceneView() == null || this.getArSceneView().getSession() == null || this.getArSceneView().getArFrame() == null) {
            return;
        }
        if (this.getInstructionsController() != null) {
            boolean showAugmentedImageInstructions;
            boolean showPlaneInstructions;
            boolean bl = showPlaneInstructions = !this.getArSceneView().hasTrackedPlane();
            if (this.getInstructionsController().isVisible(0) != showPlaneInstructions) {
                this.getInstructionsController().setVisible(0, showPlaneInstructions);
            }
            boolean bl2 = showAugmentedImageInstructions = !this.getArSceneView().isTrackingAugmentedImage();
            if (this.getInstructionsController().isVisible(1) != showAugmentedImageInstructions) {
                this.getInstructionsController().setVisible(1, showAugmentedImageInstructions);
            }
        }
        if (this.onAugmentedImageUpdateListener != null) {
            for (AugmentedImage augmentedImage : this.getArSceneView().getUpdatedAugmentedImages()) {
                this.onAugmentedImageUpdateListener.onAugmentedImageTrackingUpdate(augmentedImage);
            }
        }
        if (this.onAugmentedFaceUpdateListener != null) {
            for (AugmentedFace augmentedFace : this.getArSceneView().getUpdatedAugmentedFaces()) {
                this.onAugmentedFaceUpdateListener.onAugmentedFaceTrackingUpdate(augmentedFace);
            }
        }
    }

    private void onSingleTap(MotionEvent motionEvent) {
        Frame frame = this.arSceneView.getArFrame();
        this.transformationSystem.selectNode(null);
        OnTapArPlaneListener onTapArPlaneListener = this.onTapArPlaneListener;
        if (frame != null && onTapArPlaneListener != null && motionEvent != null && frame.getCamera().getTrackingState() == TrackingState.TRACKING) {
            for (HitResult hit : frame.hitTest(motionEvent)) {
                Trackable trackable = hit.getTrackable();
                if (!(trackable instanceof Plane) || !((Plane)trackable).isPoseInPolygon(hit.getHitPose())) continue;
                Plane plane = (Plane)trackable;
                onTapArPlaneListener.onTapPlane(hit, plane, motionEvent);
                break;
            }
        }
    }

    public static interface OnAugmentedFaceUpdateListener {
        public void onAugmentedFaceTrackingUpdate(AugmentedFace var1);
    }

    public static interface OnAugmentedImageUpdateListener {
        public void onAugmentedImageTrackingUpdate(AugmentedImage var1);
    }

    public static interface OnTapArPlaneListener {
        public void onTapPlane(HitResult var1, Plane var2, MotionEvent var3);
    }

    public static interface OnSessionConfigurationListener {
        public void onSessionConfiguration(Session var1, Config var2);
    }
}

