/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import android.content.Context;
import android.opengl.Matrix;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.filament.TransformManager;
import com.google.ar.core.AugmentedFace;
import com.google.ar.core.Pose;
import com.google.ar.core.TrackingState;
import com.google.ar.sceneform.FrameTime;
import com.google.ar.sceneform.Node;
import com.google.ar.sceneform.NodeParent;
import com.google.ar.sceneform.Scene;
import com.google.ar.sceneform.math.Quaternion;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.EngineInstance;
import com.google.ar.sceneform.rendering.Material;
import com.google.ar.sceneform.rendering.ModelRenderable;
import com.google.ar.sceneform.rendering.Renderable;
import com.google.ar.sceneform.rendering.RenderableDefinition;
import com.google.ar.sceneform.rendering.RenderableInstance;
import com.google.ar.sceneform.rendering.Texture;
import com.google.ar.sceneform.rendering.Vertex;
import com.google.ar.sceneform.ux.R;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;

public class AugmentedFaceNode
extends Node {
    private static final String TAG = AugmentedFaceNode.class.getSimpleName();
    @Nullable
    private AugmentedFace augmentedFace;
    private final Node faceMeshNode;
    private final Node faceRegionNode;
    private final ArrayList<Vertex> vertices = new ArrayList();
    private final ArrayList<Integer> triangleIndices = new ArrayList();
    private final ArrayList<RenderableDefinition.Submesh> submeshes = new ArrayList();
    private final RenderableDefinition faceMeshDefinition;
    private final HashMap<AugmentedFace.RegionType, Integer> faceMeshSkeleton = new HashMap();
    private final float[] inverseRootNodeMatrix = new float[16];
    private final float[] regionPoseMatrix = new float[16];
    private final float[] matrix = new float[16];
    @Nullable
    private ModelRenderable faceMeshRenderable;
    @Nullable
    private Material defaultFaceMeshMaterial;
    @Nullable
    private Material overrideFaceMeshMaterial;
    @Nullable
    private Material faceMeshOccluderMaterial;
    @Nullable
    private Texture faceMeshTexture;
    private static final String FACE_MESH_TEXTURE_MATERIAL_PARAMETER = "texture";
    private static final int FACE_MESH_RENDER_PRIORITY = Math.max(0, 3);

    public AugmentedFaceNode() {
        this.faceMeshNode = new Node();
        this.faceMeshNode.setParent((NodeParent)this);
        this.faceMeshDefinition = RenderableDefinition.builder().setVertices(this.vertices).setSubmeshes(this.submeshes).build();
        this.faceRegionNode = new Node();
        this.faceRegionNode.setParent((NodeParent)this);
    }

    public AugmentedFaceNode(AugmentedFace augmentedFace) {
        this();
        this.augmentedFace = augmentedFace;
    }

    @Nullable
    public AugmentedFace getAugmentedFace() {
        return this.augmentedFace;
    }

    public void setAugmentedFace(@Nullable AugmentedFace face) {
        this.augmentedFace = face;
    }

    @Nullable
    public Texture getFaceMeshTexture() {
        return this.faceMeshTexture;
    }

    public void setFaceMeshTexture(@Nullable Texture texture) {
        this.faceMeshTexture = texture;
        this.updateSubmeshes();
    }

    @Nullable
    public Material getFaceMeshMaterialOverride() {
        return this.overrideFaceMeshMaterial;
    }

    public void setFaceMeshMaterialOverride(@Nullable Material material) {
        this.overrideFaceMeshMaterial = material;
        this.updateSubmeshes();
    }

    public RenderableInstance setFaceRegionsRenderable(ModelRenderable renderable) {
        RenderableInstance renderableInstance = this.faceRegionNode.setRenderable((Renderable)renderable);
        this.updateSubmeshes();
        this.extractBonesFromRenderable();
        return renderableInstance;
    }

    private void extractBonesFromRenderable() {
        if (!this.faceMeshSkeleton.isEmpty()) {
            this.faceMeshSkeleton.clear();
        }
        for (AugmentedFace.RegionType type : AugmentedFace.RegionType.values()) {
            String boneName = AugmentedFaceNode.boneNameForRegion(type);
            int entity = this.faceRegionNode.getRenderableInstance().getFilamentAsset().getFirstEntityByName(boneName);
            if (entity == 0) {
                Log.w((String)TAG, (String)("Face mesh model is missing bone " + boneName + ". Tracking might not be accurate"));
                continue;
            }
            this.faceMeshSkeleton.put(type, entity);
        }
    }

    @Nullable
    public ModelRenderable getFaceRegionsRenderable() {
        Renderable renderable = this.faceRegionNode.getRenderable();
        if (renderable != null && !(renderable instanceof ModelRenderable)) {
            throw new IllegalStateException("Face Regions Renderable must be a ModelRenderable.");
        }
        return (ModelRenderable)renderable;
    }

    public void onActivate() {
        Scene scene = AugmentedFaceNode.checkNotNull(this.getScene());
        Context context = scene.getView().getContext();
        Material.builder().setSource(context, R.raw.sceneform_face_mesh_material).build().handle((material, throwable) -> {
            if (throwable != null) {
                Log.e((String)TAG, (String)"Unable to load face mesh material.", (Throwable)throwable);
                return false;
            }
            this.defaultFaceMeshMaterial = material;
            this.updateSubmeshes();
            return true;
        });
        Material.builder().setSource(context, R.raw.sceneform_face_mesh_occluder_material).build().handle((material, throwable) -> {
            if (throwable != null) {
                Log.e((String)TAG, (String)"Unable to load face mesh occluder material.", (Throwable)throwable);
                return false;
            }
            this.faceMeshOccluderMaterial = material;
            this.updateSubmeshes();
            return true;
        });
    }

    public void onUpdate(FrameTime frameTime) {
        boolean isTracking = this.isTracking();
        this.faceMeshNode.setEnabled(isTracking);
        this.faceRegionNode.setEnabled(isTracking);
        if (isTracking) {
            this.updateTransform();
            this.updateRegionNodes();
            this.updateFaceMesh();
        }
    }

    private void updateTransform() {
        Pose centerPose = AugmentedFaceNode.checkNotNull(this.augmentedFace).getCenterPose();
        this.setWorldPosition(new Vector3(centerPose.tx(), centerPose.ty(), centerPose.tz()));
        this.setWorldRotation(new Quaternion(centerPose.qx(), centerPose.qy(), centerPose.qz(), centerPose.qw()));
    }

    private void updateRegionNodes() {
        if (this.augmentedFace == null) {
            return;
        }
        TransformManager tfm = EngineInstance.getEngine().getTransformManager();
        Matrix.invertM((float[])this.inverseRootNodeMatrix, (int)0, (float[])this.getWorldModelMatrix().data, (int)0);
        for (AugmentedFace.RegionType type : AugmentedFace.RegionType.values()) {
            Pose pose = this.augmentedFace.getRegionPose(type);
            Log.d((String)TAG, (String)(type + " " + pose.toString()));
            pose.toMatrix(this.regionPoseMatrix, 0);
            Matrix.multiplyMM((float[])this.matrix, (int)0, (float[])this.inverseRootNodeMatrix, (int)0, (float[])this.regionPoseMatrix, (int)0);
            if (!this.faceMeshSkeleton.containsKey(type)) continue;
            int instance = tfm.getInstance(this.faceMeshSkeleton.get(type).intValue());
            tfm.setTransform(instance, this.matrix);
            tfm.getWorldTransform(instance, this.matrix);
        }
        if (this.faceRegionNode != null && this.faceRegionNode.getRenderableInstance() != null) {
            this.faceRegionNode.getRenderableInstance().getFilamentAsset().getAnimator().updateBoneMatrices();
        }
    }

    private boolean isTracking() {
        return this.augmentedFace != null && this.augmentedFace.getTrackingState() == TrackingState.TRACKING;
    }

    private void updateFaceMesh() {
        if (this.defaultFaceMeshMaterial == null || this.faceMeshOccluderMaterial == null) {
            return;
        }
        this.updateFaceMeshVerticesAndTriangles();
        if (this.faceMeshRenderable == null) {
            try {
                this.faceMeshRenderable = (ModelRenderable)((ModelRenderable.Builder)ModelRenderable.builder().setSource(AugmentedFaceNode.checkNotNull(this.faceMeshDefinition))).build().get();
                this.faceMeshRenderable.setRenderPriority(FACE_MESH_RENDER_PRIORITY);
            }
            catch (InterruptedException | ExecutionException ex) {
                Log.e((String)TAG, (String)"Failed to build faceMeshRenderable from definition", (Throwable)ex);
            }
            AugmentedFaceNode.checkNotNull(this.faceMeshRenderable).setShadowReceiver(false);
            AugmentedFaceNode.checkNotNull(this.faceMeshRenderable).setShadowCaster(false);
            this.faceMeshNode.setRenderable((Renderable)this.faceMeshRenderable);
        } else {
            this.faceMeshRenderable.updateFromDefinition(AugmentedFaceNode.checkNotNull(this.faceMeshDefinition));
        }
    }

    private void updateFaceMeshVerticesAndTriangles() {
        AugmentedFace augmentedFace = AugmentedFaceNode.checkNotNull(this.augmentedFace);
        FloatBuffer verticesBuffer = augmentedFace.getMeshVertices();
        verticesBuffer.rewind();
        int numVertices = verticesBuffer.limit() / 3;
        FloatBuffer textureCoordsBuffer = augmentedFace.getMeshTextureCoordinates();
        textureCoordsBuffer.rewind();
        int numTextureCoords = textureCoordsBuffer.limit() / 2;
        FloatBuffer normalsBuffer = augmentedFace.getMeshNormals();
        normalsBuffer.rewind();
        int numNormals = normalsBuffer.limit() / 3;
        if (numVertices != numTextureCoords || numVertices != numNormals) {
            throw new IllegalStateException("AugmentedFace must have the same number of vertices, normals, and texture coordinates.");
        }
        this.vertices.ensureCapacity(numVertices);
        for (int i = 0; i < numVertices; ++i) {
            Vertex vertex;
            float vX = verticesBuffer.get();
            float vY = verticesBuffer.get();
            float vZ = verticesBuffer.get();
            float nX = normalsBuffer.get();
            float nY = normalsBuffer.get();
            float nZ = normalsBuffer.get();
            float u = textureCoordsBuffer.get();
            float v = textureCoordsBuffer.get();
            if (i < this.vertices.size()) {
                vertex = this.vertices.get(i);
                Vector3 vertexPos = AugmentedFaceNode.checkNotNull(vertex.getPosition());
                vertexPos.set(vX, vY, vZ);
                Vector3 normal = AugmentedFaceNode.checkNotNull(vertex.getNormal());
                normal.set(nX, nY, nZ);
                Vertex.UvCoordinate uvCoord = AugmentedFaceNode.checkNotNull(vertex.getUvCoordinate());
                uvCoord.x = u;
                uvCoord.y = v;
                continue;
            }
            vertex = Vertex.builder().setPosition(new Vector3(vX, vY, vZ)).setNormal(new Vector3(nX, nY, nZ)).setUvCoordinate(new Vertex.UvCoordinate(u, v)).build();
            this.vertices.add(vertex);
        }
        while (this.vertices.size() > numVertices) {
            this.vertices.remove(this.vertices.size() - 1);
        }
        ShortBuffer indicesBuffer = augmentedFace.getMeshTriangleIndices();
        indicesBuffer.rewind();
        if (this.triangleIndices.size() != indicesBuffer.limit()) {
            this.triangleIndices.clear();
            this.triangleIndices.ensureCapacity(indicesBuffer.limit());
            while (indicesBuffer.hasRemaining()) {
                this.triangleIndices.add(Integer.valueOf(indicesBuffer.get()));
            }
        }
    }

    private void updateSubmeshes() {
        Material currentFaceMeshMaterial = this.getFaceMeshMaterial();
        if (this.defaultFaceMeshMaterial == null || currentFaceMeshMaterial == null) {
            return;
        }
        Material faceMeshMaterial = AugmentedFaceNode.checkNotNull(currentFaceMeshMaterial);
        Material faceMeshOccluderMaterial = AugmentedFaceNode.checkNotNull(this.faceMeshOccluderMaterial);
        this.submeshes.clear();
        RenderableDefinition.Submesh occluderSubmesh = RenderableDefinition.Submesh.builder().setTriangleIndices(this.triangleIndices).setMaterial(faceMeshOccluderMaterial).build();
        this.submeshes.add(occluderSubmesh);
        if (this.faceMeshTexture != null) {
            if (faceMeshMaterial == this.defaultFaceMeshMaterial) {
                faceMeshMaterial.setTexture(FACE_MESH_TEXTURE_MATERIAL_PARAMETER, this.faceMeshTexture);
            }
            RenderableDefinition.Submesh faceTextureSubmesh = RenderableDefinition.Submesh.builder().setTriangleIndices(this.triangleIndices).setMaterial(faceMeshMaterial).build();
            this.submeshes.add(faceTextureSubmesh);
        }
    }

    @Nullable
    private Material getFaceMeshMaterial() {
        if (this.overrideFaceMeshMaterial != null) {
            return this.overrideFaceMeshMaterial;
        }
        return this.defaultFaceMeshMaterial;
    }

    private static String boneNameForRegion(AugmentedFace.RegionType regionType) {
        return regionType.name();
    }

    private static <T> T checkNotNull(@Nullable T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }
}

