/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import android.content.Context;
import android.media.MediaPlayer;
import androidx.annotation.Nullable;
import com.google.ar.sceneform.FrameTime;
import com.google.ar.sceneform.Node;
import com.google.ar.sceneform.math.Quaternion;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.rendering.Color;
import com.google.ar.sceneform.rendering.ExternalTexture;
import com.google.ar.sceneform.rendering.Material;
import com.google.ar.sceneform.rendering.PlaneFactory;
import com.google.ar.sceneform.rendering.Renderable;
import com.google.ar.sceneform.ux.R;
import java.util.concurrent.CompletableFuture;

public class VideoNode
extends Node {
    private static final String MATERIAL_PARAMETER_VIDEO_TEXTURE = "videoTexture";
    private static final String MATERIAL_PARAMETER_CHROMA_KEY_COLOR = "keyColor";
    private final MediaPlayer player;
    private final ExternalTexture texture;
    private final Color chromaKeyColor;
    private final Listener listener;
    private boolean rotateAlwaysToCamera = false;

    public VideoNode(Context context, MediaPlayer player, @Nullable Listener listener) {
        this(context, player, null, null, listener);
    }

    public VideoNode(Context context, MediaPlayer player, @Nullable Color chromaKeyColor, @Nullable Listener listener) {
        this(context, player, chromaKeyColor, null, listener);
    }

    public VideoNode(Context context, MediaPlayer player, @Nullable Color chromaKeyColor, @Nullable ExternalTexture texture, @Nullable Listener listener) {
        this.player = player;
        this.texture = texture != null ? texture : new ExternalTexture();
        this.chromaKeyColor = chromaKeyColor;
        this.listener = listener;
        this.init(context);
    }

    private void init(Context context) {
        this.player.setSurface(this.texture.getSurface());
        int rawResId = this.chromaKeyColor != null ? R.raw.external_chroma_key_video_material : R.raw.external_plain_video_material;
        ((CompletableFuture)Material.builder().setSource(context, rawResId).build().thenAccept(material -> {
            material.setExternalTexture(MATERIAL_PARAMETER_VIDEO_TEXTURE, this.texture);
            if (this.chromaKeyColor != null) {
                material.setFloat4(MATERIAL_PARAMETER_CHROMA_KEY_COLOR, this.chromaKeyColor);
            }
            Renderable renderable = this.createModel(this.player, (Material)material);
            this.setRenderable(renderable);
            this.onCreated(this);
        })).exceptionally(throwable -> {
            this.onError((Throwable)throwable);
            return null;
        });
    }

    public Renderable createModel(MediaPlayer player, Material material) {
        float y;
        float x;
        int height;
        int width = player.getVideoWidth();
        if (width >= (height = player.getVideoHeight())) {
            x = 1.0f;
            y = (float)height / (float)width;
        } else {
            x = (float)width / (float)height;
            y = 1.0f;
        }
        return this.makePlane(x, y, material);
    }

    public Renderable makePlane(float width, float height, Material material) {
        return PlaneFactory.makePlane((Vector3)new Vector3(width, height, 0.0f), (Vector3)new Vector3(0.0f, height / 2.0f, 0.0f), (Material)material);
    }

    public void onUpdate(FrameTime frameTime) {
        super.onUpdate(frameTime);
        if (this.rotateAlwaysToCamera && this.getScene() != null && this.getScene().getCamera() != null) {
            Vector3 cameraPosition = this.getScene().getCamera().getWorldPosition();
            Vector3 cardPosition = this.getWorldPosition();
            Vector3 direction = Vector3.subtract((Vector3)cameraPosition, (Vector3)cardPosition);
            Quaternion lookRotation = Quaternion.lookRotation((Vector3)direction, (Vector3)Vector3.up());
            this.setWorldRotation(lookRotation);
        }
    }

    public MediaPlayer getPlayer() {
        return this.player;
    }

    public ExternalTexture getTexture() {
        return this.texture;
    }

    public Color getChromaKeyColor() {
        return this.chromaKeyColor;
    }

    public boolean isRotateAlwaysToCamera() {
        return this.rotateAlwaysToCamera;
    }

    public void setRotateAlwaysToCamera(boolean rotateAlwaysToCamera) {
        this.rotateAlwaysToCamera = rotateAlwaysToCamera;
    }

    private void onCreated(VideoNode videoNode) {
        if (this.listener != null) {
            this.listener.onCreated(videoNode);
        }
    }

    private void onError(Throwable throwable) {
        if (this.listener != null) {
            this.listener.onError(throwable);
        }
    }

    public static class Vertical
    extends VideoNode {
        public Vertical(Context context, MediaPlayer player, @Nullable Listener listener) {
            super(context, player, listener);
        }

        public Vertical(Context context, MediaPlayer player, @Nullable Color chromaKeyColor, @Nullable Listener listener) {
            super(context, player, chromaKeyColor, listener);
        }

        public Vertical(Context context, MediaPlayer player, @Nullable Color chromaKeyColor, @Nullable ExternalTexture texture, @Nullable Listener listener) {
            super(context, player, chromaKeyColor, texture, listener);
        }

        @Override
        public Renderable makePlane(float width, float height, Material material) {
            return PlaneFactory.makePlane((Vector3)new Vector3(width, height, 0.0f), (Vector3)new Vector3(0.0f, height / 2.0f, 0.0f), (Material)material);
        }
    }

    public static class Horizontal
    extends VideoNode {
        public Horizontal(Context context, MediaPlayer player, @Nullable Listener listener) {
            super(context, player, listener);
        }

        public Horizontal(Context context, MediaPlayer player, @Nullable Color chromaKeyColor, @Nullable Listener listener) {
            super(context, player, chromaKeyColor, listener);
        }

        public Horizontal(Context context, MediaPlayer player, @Nullable Color chromaKeyColor, @Nullable ExternalTexture texture, @Nullable Listener listener) {
            super(context, player, chromaKeyColor, texture, listener);
        }

        @Override
        public Renderable makePlane(float width, float height, Material material) {
            return PlaneFactory.makePlane((Vector3)new Vector3(width, 0.0f, height), (Vector3)new Vector3(0.0f, 0.0f, 0.0f), (Material)material);
        }
    }

    public static interface Listener {
        public void onCreated(VideoNode var1);

        public void onError(Throwable var1);
    }

    public static interface OnCreateListener {
        public void onError(Throwable var1);
    }
}

