/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import androidx.annotation.Nullable;
import com.google.ar.core.Anchor;
import com.google.ar.core.Camera;
import com.google.ar.core.Frame;
import com.google.ar.core.HitResult;
import com.google.ar.core.Plane;
import com.google.ar.core.Pose;
import com.google.ar.core.Trackable;
import com.google.ar.core.TrackingState;
import com.google.ar.sceneform.AnchorNode;
import com.google.ar.sceneform.ArSceneView;
import com.google.ar.sceneform.FrameTime;
import com.google.ar.sceneform.Node;
import com.google.ar.sceneform.NodeParent;
import com.google.ar.sceneform.Scene;
import com.google.ar.sceneform.math.MathHelper;
import com.google.ar.sceneform.math.Quaternion;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.utilities.Preconditions;
import com.google.ar.sceneform.ux.BaseTransformableNode;
import com.google.ar.sceneform.ux.BaseTransformationController;
import com.google.ar.sceneform.ux.DragGesture;
import com.google.ar.sceneform.ux.DragGestureRecognizer;
import java.util.EnumSet;
import java.util.List;

public class TranslationController
extends BaseTransformationController<DragGesture> {
    @Nullable
    private HitResult lastArHitResult;
    @Nullable
    private Vector3 desiredLocalPosition;
    @Nullable
    private Quaternion desiredLocalRotation;
    private final Vector3 initialForwardInLocal = new Vector3();
    private EnumSet<Plane.Type> allowedPlaneTypes = EnumSet.allOf(Plane.Type.class);
    private static final float LERP_SPEED = 12.0f;
    private static final float POSITION_LENGTH_THRESHOLD = 0.01f;
    private static final float ROTATION_DOT_THRESHOLD = 0.99f;

    public TranslationController(BaseTransformableNode transformableNode, DragGestureRecognizer gestureRecognizer) {
        super(transformableNode, gestureRecognizer);
    }

    public void setAllowedPlaneTypes(EnumSet<Plane.Type> allowedPlaneTypes) {
        this.allowedPlaneTypes = allowedPlaneTypes;
    }

    public EnumSet<Plane.Type> getAllowedPlaneTypes() {
        return this.allowedPlaneTypes;
    }

    @Override
    public void onUpdated(Node node, FrameTime frameTime) {
        this.updatePosition(frameTime);
        this.updateRotation(frameTime);
    }

    @Override
    public boolean isTransforming() {
        return super.isTransforming() || this.desiredLocalRotation != null || this.desiredLocalPosition != null;
    }

    @Override
    public boolean canStartTransformation(DragGesture gesture) {
        Node targetNode = gesture.getTargetNode();
        if (targetNode == null) {
            return false;
        }
        BaseTransformableNode transformableNode = this.getTransformableNode();
        if (targetNode != transformableNode && !targetNode.isDescendantOf((NodeParent)transformableNode)) {
            return false;
        }
        if (!transformableNode.isSelected() && !transformableNode.select()) {
            return false;
        }
        Vector3 initialForwardInWorld = transformableNode.getForward();
        Node parent = transformableNode.getParentNode();
        if (parent != null) {
            this.initialForwardInLocal.set(parent.worldToLocalDirection(initialForwardInWorld));
        } else {
            this.initialForwardInLocal.set(initialForwardInWorld);
        }
        return true;
    }

    @Override
    public void onContinueTransformation(DragGesture gesture) {
        Scene scene = this.getTransformableNode().getScene();
        if (scene == null) {
            return;
        }
        Frame frame = ((ArSceneView)scene.getView()).getArFrame();
        if (frame == null) {
            return;
        }
        Camera arCamera = frame.getCamera();
        if (arCamera.getTrackingState() != TrackingState.TRACKING) {
            return;
        }
        Vector3 position = gesture.getPosition();
        List hitResultList = frame.hitTest(position.x, position.y);
        for (int i = 0; i < hitResultList.size(); ++i) {
            Plane plane;
            HitResult hit = (HitResult)hitResultList.get(i);
            Trackable trackable = hit.getTrackable();
            Pose pose = hit.getHitPose();
            if (!(trackable instanceof Plane) || !(plane = (Plane)trackable).isPoseInPolygon(pose) || !this.allowedPlaneTypes.contains(plane.getType())) continue;
            this.desiredLocalPosition = new Vector3(pose.tx(), pose.ty(), pose.tz());
            this.desiredLocalRotation = new Quaternion(pose.qx(), pose.qy(), pose.qz(), pose.qw());
            Node parent = this.getTransformableNode().getParentNode();
            if (parent != null && this.desiredLocalPosition != null && this.desiredLocalRotation != null) {
                this.desiredLocalPosition = parent.worldToLocalPoint(this.desiredLocalPosition);
                this.desiredLocalRotation = Quaternion.multiply((Quaternion)parent.getWorldRotation().inverted(), (Quaternion)((Quaternion)Preconditions.checkNotNull((Object)this.desiredLocalRotation)));
            }
            this.desiredLocalRotation = this.calculateFinalDesiredLocalRotation((Quaternion)Preconditions.checkNotNull((Object)this.desiredLocalRotation));
            this.lastArHitResult = hit;
            break;
        }
    }

    @Override
    public void onEndTransformation(DragGesture gesture) {
        HitResult hitResult = this.lastArHitResult;
        if (hitResult == null) {
            return;
        }
        if (hitResult.getTrackable().getTrackingState() == TrackingState.TRACKING) {
            Quaternion worldRotation;
            AnchorNode anchorNode = this.getAnchorNodeOrDie();
            Anchor oldAnchor = anchorNode.getAnchor();
            if (oldAnchor != null) {
                oldAnchor.detach();
            }
            Anchor newAnchor = hitResult.createAnchor();
            Vector3 worldPosition = this.getTransformableNode().getWorldPosition();
            Quaternion finalDesiredWorldRotation = worldRotation = this.getTransformableNode().getWorldRotation();
            Quaternion desiredLocalRotation = this.desiredLocalRotation;
            if (desiredLocalRotation != null) {
                this.getTransformableNode().setLocalRotation(desiredLocalRotation);
                finalDesiredWorldRotation = this.getTransformableNode().getWorldRotation();
            }
            anchorNode.setAnchor(newAnchor);
            this.getTransformableNode().setWorldRotation(finalDesiredWorldRotation);
            Vector3 initialForwardInWorld = this.getTransformableNode().getForward();
            this.initialForwardInLocal.set(anchorNode.worldToLocalDirection(initialForwardInWorld));
            this.getTransformableNode().setWorldRotation(worldRotation);
            this.getTransformableNode().setWorldPosition(worldPosition);
        }
        this.desiredLocalPosition = Vector3.zero();
        this.desiredLocalRotation = this.calculateFinalDesiredLocalRotation(Quaternion.identity());
    }

    private AnchorNode getAnchorNodeOrDie() {
        NodeParent parent = this.getTransformableNode().getParent();
        if (!(parent instanceof AnchorNode)) {
            throw new IllegalStateException("TransformableNode must have an AnchorNode as a parent.");
        }
        return (AnchorNode)parent;
    }

    private void updatePosition(FrameTime frameTime) {
        Vector3 desiredLocalPosition = this.desiredLocalPosition;
        if (desiredLocalPosition == null) {
            return;
        }
        Vector3 localPosition = this.getTransformableNode().getLocalPosition();
        float lerpFactor = MathHelper.clamp((float)(frameTime.getDeltaSeconds() * 12.0f), (float)0.0f, (float)1.0f);
        float lengthDiff = Math.abs(Vector3.subtract((Vector3)desiredLocalPosition, (Vector3)(localPosition = Vector3.lerp((Vector3)localPosition, (Vector3)desiredLocalPosition, (float)lerpFactor))).length());
        if (lengthDiff <= 0.01f) {
            localPosition = desiredLocalPosition;
            this.desiredLocalPosition = null;
        }
        this.getTransformableNode().setLocalPosition(localPosition);
    }

    private void updateRotation(FrameTime frameTime) {
        Quaternion desiredLocalRotation = this.desiredLocalRotation;
        if (desiredLocalRotation == null) {
            return;
        }
        Quaternion localRotation = this.getTransformableNode().getLocalRotation();
        float lerpFactor = MathHelper.clamp((float)(frameTime.getDeltaSeconds() * 12.0f), (float)0.0f, (float)1.0f);
        float dot = Math.abs(TranslationController.dotQuaternion(localRotation = Quaternion.slerp((Quaternion)localRotation, (Quaternion)desiredLocalRotation, (float)lerpFactor), desiredLocalRotation));
        if (dot >= 0.99f) {
            localRotation = desiredLocalRotation;
            this.desiredLocalRotation = null;
        }
        this.getTransformableNode().setLocalRotation(localRotation);
    }

    private Quaternion calculateFinalDesiredLocalRotation(Quaternion desiredLocalRotation) {
        Vector3 rotatedUp = Quaternion.rotateVector((Quaternion)desiredLocalRotation, (Vector3)Vector3.up());
        desiredLocalRotation = Quaternion.rotationBetweenVectors((Vector3)Vector3.up(), (Vector3)rotatedUp);
        Quaternion forwardInLocal = Quaternion.rotationBetweenVectors((Vector3)Vector3.forward(), (Vector3)this.initialForwardInLocal);
        desiredLocalRotation = Quaternion.multiply((Quaternion)desiredLocalRotation, (Quaternion)forwardInLocal);
        return desiredLocalRotation.normalized();
    }

    private static float dotQuaternion(Quaternion lhs, Quaternion rhs) {
        return lhs.x * rhs.x + lhs.y * rhs.y + lhs.z * rhs.z + lhs.w * rhs.w;
    }
}

