/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import android.util.DisplayMetrics;
import android.view.MotionEvent;
import androidx.annotation.Nullable;
import com.google.ar.sceneform.HitTestResult;
import com.google.ar.sceneform.ux.BaseGestureRecognizer;
import com.google.ar.sceneform.ux.BaseTransformableNode;
import com.google.ar.sceneform.ux.DragGestureRecognizer;
import com.google.ar.sceneform.ux.GesturePointersUtility;
import com.google.ar.sceneform.ux.PinchGestureRecognizer;
import com.google.ar.sceneform.ux.SelectionVisualizer;
import com.google.ar.sceneform.ux.TwistGestureRecognizer;
import java.util.ArrayList;

public class TransformationSystem {
    private final GesturePointersUtility gesturePointersUtility;
    private final DragGestureRecognizer dragGestureRecognizer;
    private final PinchGestureRecognizer pinchGestureRecognizer;
    private final TwistGestureRecognizer twistGestureRecognizer;
    private final ArrayList<BaseGestureRecognizer<?>> recognizers = new ArrayList();
    private SelectionVisualizer selectionVisualizer;
    @Nullable
    private BaseTransformableNode selectedNode;

    public TransformationSystem(DisplayMetrics displayMetrics, SelectionVisualizer selectionVisualizer) {
        this.selectionVisualizer = selectionVisualizer;
        this.gesturePointersUtility = new GesturePointersUtility(displayMetrics);
        this.dragGestureRecognizer = new DragGestureRecognizer(this.gesturePointersUtility);
        this.addGestureRecognizer(this.dragGestureRecognizer);
        this.pinchGestureRecognizer = new PinchGestureRecognizer(this.gesturePointersUtility);
        this.addGestureRecognizer(this.pinchGestureRecognizer);
        this.twistGestureRecognizer = new TwistGestureRecognizer(this.gesturePointersUtility);
        this.addGestureRecognizer(this.twistGestureRecognizer);
    }

    public void setSelectionVisualizer(SelectionVisualizer selectionVisualizer) {
        if (this.selectedNode != null) {
            this.selectionVisualizer.removeSelectionVisual(this.selectedNode);
        }
        this.selectionVisualizer = selectionVisualizer;
        if (this.selectedNode != null) {
            this.selectionVisualizer.applySelectionVisual(this.selectedNode);
        }
    }

    public SelectionVisualizer getSelectionVisualizer() {
        return this.selectionVisualizer;
    }

    public GesturePointersUtility getGesturePointersUtility() {
        return this.gesturePointersUtility;
    }

    public DragGestureRecognizer getDragRecognizer() {
        return this.dragGestureRecognizer;
    }

    public PinchGestureRecognizer getPinchRecognizer() {
        return this.pinchGestureRecognizer;
    }

    public TwistGestureRecognizer getTwistRecognizer() {
        return this.twistGestureRecognizer;
    }

    public void addGestureRecognizer(BaseGestureRecognizer<?> gestureRecognizer) {
        this.recognizers.add(gestureRecognizer);
    }

    @Nullable
    public BaseTransformableNode getSelectedNode() {
        return this.selectedNode;
    }

    public boolean selectNode(@Nullable BaseTransformableNode node) {
        if (!this.deselectNode()) {
            return false;
        }
        if (node != null) {
            this.selectedNode = node;
            this.selectionVisualizer.applySelectionVisual(this.selectedNode);
        }
        return true;
    }

    public void onTouch(HitTestResult hitTestResult, MotionEvent motionEvent) {
        for (int i = 0; i < this.recognizers.size(); ++i) {
            this.recognizers.get(i).onTouch(hitTestResult, motionEvent);
        }
    }

    private boolean deselectNode() {
        if (this.selectedNode == null) {
            return true;
        }
        if (this.selectedNode.isTransforming()) {
            return false;
        }
        this.selectionVisualizer.removeSelectionVisual(this.selectedNode);
        this.selectedNode = null;
        return true;
    }
}

