/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import com.google.ar.sceneform.math.Quaternion;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.ux.BaseTransformableNode;
import com.google.ar.sceneform.ux.BaseTransformationController;
import com.google.ar.sceneform.ux.TwistGesture;
import com.google.ar.sceneform.ux.TwistGestureRecognizer;

public class RotationController
extends BaseTransformationController<TwistGesture> {
    private float rotationRateDegrees = 2.5f;

    public RotationController(BaseTransformableNode transformableNode, TwistGestureRecognizer gestureRecognizer) {
        super(transformableNode, gestureRecognizer);
    }

    public void setRotationRateDegrees(float rotationRateDegrees) {
        this.rotationRateDegrees = rotationRateDegrees;
    }

    public float getRotationRateDegrees() {
        return this.rotationRateDegrees;
    }

    @Override
    public boolean canStartTransformation(TwistGesture gesture) {
        return this.getTransformableNode().isSelected();
    }

    @Override
    public void onContinueTransformation(TwistGesture gesture) {
        float rotationAmount = -gesture.getDeltaRotationDegrees() * this.rotationRateDegrees;
        Quaternion rotationDelta = new Quaternion(Vector3.up(), rotationAmount);
        Quaternion localrotation = this.getTransformableNode().getLocalRotation();
        localrotation = Quaternion.multiply((Quaternion)localrotation, (Quaternion)rotationDelta);
        this.getTransformableNode().setLocalRotation(localrotation);
    }

    @Override
    public void onEndTransformation(TwistGesture gesture) {
    }
}

