/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import com.google.ar.sceneform.math.Vector3;
import java.util.HashSet;

public class GesturePointersUtility {
    private final DisplayMetrics displayMetrics;
    private final HashSet<Integer> retainedPointerIds;

    public GesturePointersUtility(DisplayMetrics displayMetrics) {
        this.displayMetrics = displayMetrics;
        this.retainedPointerIds = new HashSet();
    }

    public void retainPointerId(int pointerId) {
        if (!this.isPointerIdRetained(pointerId)) {
            this.retainedPointerIds.add(pointerId);
        }
    }

    public void releasePointerId(int pointerId) {
        this.retainedPointerIds.remove(pointerId);
    }

    public boolean isPointerIdRetained(int pointerId) {
        return this.retainedPointerIds.contains(pointerId);
    }

    public float inchesToPixels(float inches) {
        return TypedValue.applyDimension((int)4, (float)inches, (DisplayMetrics)this.displayMetrics);
    }

    public float pixelsToInches(float pixels) {
        float inchOfPixels = TypedValue.applyDimension((int)4, (float)1.0f, (DisplayMetrics)this.displayMetrics);
        return pixels / inchOfPixels;
    }

    public static Vector3 motionEventToPosition(MotionEvent me, int pointerId) {
        int index = me.findPointerIndex(pointerId);
        return new Vector3(me.getX(index), me.getY(index), 0.0f);
    }
}

