/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import android.view.MotionEvent;
import com.google.ar.sceneform.HitTestResult;
import com.google.ar.sceneform.ux.BaseGesture;
import com.google.ar.sceneform.ux.GesturePointersUtility;
import java.util.ArrayList;

public abstract class BaseGestureRecognizer<T extends BaseGesture<T>> {
    protected final GesturePointersUtility gesturePointersUtility;
    protected final ArrayList<T> gestures = new ArrayList();
    private final ArrayList<OnGestureStartedListener<T>> gestureStartedListeners;

    public BaseGestureRecognizer(GesturePointersUtility gesturePointersUtility) {
        this.gesturePointersUtility = gesturePointersUtility;
        this.gestureStartedListeners = new ArrayList();
    }

    public void addOnGestureStartedListener(OnGestureStartedListener<T> listener) {
        if (!this.gestureStartedListeners.contains(listener)) {
            this.gestureStartedListeners.add(listener);
        }
    }

    public void removeOnGestureStartedListener(OnGestureStartedListener<T> listener) {
        this.gestureStartedListeners.remove(listener);
    }

    public void onTouch(HitTestResult hitTestResult, MotionEvent motionEvent) {
        this.tryCreateGestures(hitTestResult, motionEvent);
        for (int i = 0; i < this.gestures.size(); ++i) {
            BaseGesture gesture = (BaseGesture)this.gestures.get(i);
            gesture.onTouch(hitTestResult, motionEvent);
            if (!gesture.justStarted()) continue;
            this.dispatchGestureStarted(gesture);
        }
        this.removeFinishedGestures();
    }

    protected abstract void tryCreateGestures(HitTestResult var1, MotionEvent var2);

    private void dispatchGestureStarted(T gesture) {
        for (int i = 0; i < this.gestureStartedListeners.size(); ++i) {
            OnGestureStartedListener<T> listener = this.gestureStartedListeners.get(i);
            listener.onGestureStarted(gesture);
        }
    }

    private void removeFinishedGestures() {
        for (int i = this.gestures.size() - 1; i >= 0; --i) {
            BaseGesture gesture = (BaseGesture)this.gestures.get(i);
            if (!gesture.hasFinished()) continue;
            this.gestures.remove(i);
        }
    }

    public static interface OnGestureStartedListener<T extends BaseGesture<T>> {
        public void onGestureStarted(T var1);
    }
}

