/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import android.view.MotionEvent;
import androidx.annotation.Nullable;
import com.google.ar.sceneform.HitTestResult;
import com.google.ar.sceneform.Node;
import com.google.ar.sceneform.ux.GesturePointersUtility;

public abstract class BaseGesture<T extends BaseGesture<T>> {
    protected final GesturePointersUtility gesturePointersUtility;
    private boolean hasStarted;
    private boolean justStarted;
    private boolean hasFinished;
    private boolean wasCancelled;
    @Nullable
    protected Node targetNode;
    @Nullable
    private OnGestureEventListener<T> eventListener;

    public BaseGesture(GesturePointersUtility gesturePointersUtility) {
        this.gesturePointersUtility = gesturePointersUtility;
    }

    public boolean hasStarted() {
        return this.hasStarted;
    }

    public boolean justStarted() {
        return this.justStarted;
    }

    public boolean hasFinished() {
        return this.hasFinished;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    @Nullable
    public Node getTargetNode() {
        return this.targetNode;
    }

    public float inchesToPixels(float inches) {
        return this.gesturePointersUtility.inchesToPixels(inches);
    }

    public float pixelsToInches(float pixels) {
        return this.gesturePointersUtility.pixelsToInches(pixels);
    }

    public void setGestureEventListener(@Nullable OnGestureEventListener<T> listener) {
        this.eventListener = listener;
    }

    public void onTouch(HitTestResult hitTestResult, MotionEvent motionEvent) {
        if (!this.hasStarted && this.canStart(hitTestResult, motionEvent)) {
            this.start(hitTestResult, motionEvent);
            return;
        }
        this.justStarted = false;
        if (this.hasStarted && this.updateGesture(hitTestResult, motionEvent)) {
            this.dispatchUpdateEvent();
        }
    }

    protected abstract boolean canStart(HitTestResult var1, MotionEvent var2);

    protected abstract void onStart(HitTestResult var1, MotionEvent var2);

    protected abstract boolean updateGesture(HitTestResult var1, MotionEvent var2);

    protected abstract void onCancel();

    protected abstract void onFinish();

    protected void cancel() {
        this.wasCancelled = true;
        this.onCancel();
        this.complete();
    }

    protected void complete() {
        this.hasFinished = true;
        if (this.hasStarted) {
            this.onFinish();
            this.dispatchFinishedEvent();
        }
    }

    private void start(HitTestResult hitTestResult, MotionEvent motionEvent) {
        this.hasStarted = true;
        this.justStarted = true;
        this.onStart(hitTestResult, motionEvent);
    }

    private void dispatchUpdateEvent() {
        if (this.eventListener != null) {
            this.eventListener.onUpdated(this.getSelf());
        }
    }

    private void dispatchFinishedEvent() {
        if (this.eventListener != null) {
            this.eventListener.onFinished(this.getSelf());
        }
    }

    protected abstract T getSelf();

    public static interface OnGestureEventListener<T extends BaseGesture<T>> {
        public void onUpdated(T var1);

        public void onFinished(T var1);
    }
}

