/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.button;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.form.button.ButtonBehavior;
import com.googlecode.wicket.kendo.ui.form.button.IIndicatingButton;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;

public class AjaxIndicatingButtonBehavior
extends ButtonBehavior {
    private static final long serialVersionUID = 1L;
    protected static final String CSS_INDICATOR = "indicator";
    private IIndicatingButton button = null;

    public AjaxIndicatingButtonBehavior(String selector) {
        super(selector);
    }

    public AjaxIndicatingButtonBehavior(String selector, Options options) {
        super(selector, options);
    }

    public AjaxIndicatingButtonBehavior(String selector, String icon) {
        super(selector, icon);
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render(AjaxIndicatingButtonBehavior.newIndicatorCssHeaderItem());
    }

    public void bind(Component component) {
        super.bind(component);
        if (component instanceof IIndicatingButton) {
            this.button = (IIndicatingButton)component;
        }
    }

    protected String $() {
        StringBuilder builder = new StringBuilder(super.$());
        builder.append("jQuery('").append(this.getSelector()).append("')").append(".click(function() { ");
        builder.append(this.$(this.newOnClickOptions()));
        builder.append(" }); ");
        builder.append("jQuery(document).ajaxStart(function() { ");
        builder.append(this.$(this.newAjaxStartOptions()));
        builder.append(" }); ");
        builder.append("jQuery(document).ajaxStop(function() { ");
        builder.append("jQuery('").append(this.selector).append(" .").append("k-icon").append("').remove(); ");
        builder.append("jQuery('").append(this.selector).append("').removeAttr('disabled'); ");
        builder.append(this.$(this.options));
        builder.append(" }); ");
        return builder.toString();
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.options.set("enable", (Object)component.isEnabledInHierarchy());
    }

    private static HeaderItem newIndicatorCssHeaderItem() {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(AbstractDefaultAjaxBehavior.INDICATOR);
        String css = String.format(".k-i-%s { background-image: url(%s); background-position: 0 0; }", CSS_INDICATOR, RequestCycle.get().urlFor((IRequestHandler)handler));
        return CssHeaderItem.forCSS((CharSequence)css, (String)"kendo-ui-icon-indicator");
    }

    protected Options newOnClickOptions() {
        Options options = new Options();
        options.set("icon", (Object)Options.asString((String)CSS_INDICATOR));
        if (this.button != null && this.button.isDisabledOnClick()) {
            options.set("enable", (Object)false);
        }
        return options;
    }

    protected Options newAjaxStartOptions() {
        return new Options();
    }
}

