/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable.button;

import com.github.openjson.JSONObject;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.kendo.ui.datatable.button.AbstractButton;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.json.JSONFunction;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;

public class CommandButton
extends AbstractButton {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY = "id";

    public CommandButton(String name) {
        super(name, PROPERTY);
    }

    public CommandButton(String name, IModel<String> text) {
        super(name, text, PROPERTY);
    }

    public CommandButton(String name, String property) {
        super(name, property);
    }

    public CommandButton(String name, IModel<String> text, String property) {
        super(name, text, property);
    }

    @Override
    public boolean isBuiltIn() {
        switch (this.getName()) {
            case "edit": 
            case "destroy": {
                return true;
            }
        }
        return false;
    }

    public String toString(JQueryAjaxBehavior behavior) {
        JSONObject object = this.toJSONObject();
        if (this.isEnabled() && behavior != null) {
            object.put("click", (Object)new JSONFunction((CharSequence)behavior.getCallbackFunction()));
        }
        return object.toString();
    }

    public JSONObject toJSONObject() {
        JSONObject object = new JSONObject();
        object.put("name", (Object)this.getName());
        object.put("text", this.getTextModel().getObject());
        if (!Strings.isEmpty((CharSequence)this.getCSSClass())) {
            object.put("className", (Object)this.getCSSClass());
        }
        if (!Strings.isEmpty((CharSequence)this.getIconClass())) {
            object.put("iconClass", (Object)this.getIconClass());
        }
        return object;
    }

    public void onClick(AjaxRequestTarget target, String value) {
    }
}

