/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.window;

import com.googlecode.wicket.jquery.core.JQueryAbstractBehavior;
import com.googlecode.wicket.kendo.ui.form.TextField;
import com.googlecode.wicket.kendo.ui.panel.KendoFeedbackPanel;
import com.googlecode.wicket.kendo.ui.widget.window.Window;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButton;
import com.googlecode.wicket.kendo.ui.widget.window.WindowButtons;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class InputWindow<T>
extends Window<T> {
    private static final long serialVersionUID = 1L;
    private final Form<?> form;
    private KendoFeedbackPanel feedback;
    private IModel<String> labelModel;
    private FormComponent<T> textField;

    public InputWindow(String id, String title, String label) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), null, (IModel<String>)Model.of((Serializable)((Object)label)));
    }

    public InputWindow(String id, IModel<String> title, IModel<String> label) {
        this(id, title, null, label);
    }

    public InputWindow(String id, String title, IModel<T> model, String label) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), model, (IModel<String>)Model.of((Serializable)((Object)label)));
    }

    public InputWindow(String id, IModel<String> title, IModel<T> model, IModel<String> label) {
        super(id, title, model, WindowButtons.OK_CANCEL);
        this.labelModel = label;
        this.form = InputWindow.newForm("form");
        this.add(new Component[]{this.form});
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.feedback = this.newFeedbackPanel("feedback");
        this.form.add(new Component[]{this.feedback});
        this.form.add(new Component[]{this.newLabel("label", this.labelModel)});
        this.textField = this.newTextField("input", this.getModel());
        this.textField.setOutputMarkupId(true);
        this.textField.setRequired(this.isRequired());
        this.form.add(new Component[]{this.textField});
        this.form.add(new Component[]{this.newButtonPanel("buttons", this.getButtons())});
    }

    @Override
    protected void onOpen(IPartialPageRequestHandler handler) {
        super.onOpen(handler);
        handler.add(new Component[]{this.form});
    }

    @Override
    protected void onError(AjaxRequestTarget target, WindowButton button) {
        target.add(new Component[]{this.feedback});
    }

    @Override
    protected void onSubmit(AjaxRequestTarget target, WindowButton button) {
        if (button != null) {
            if (button.match("OK")) {
                this.onSubmit(target);
            } else if (button.match("CANCEL")) {
                this.onCancel(target);
            }
        }
    }

    protected abstract void onSubmit(AjaxRequestTarget var1);

    protected void onCancel(AjaxRequestTarget target) {
    }

    public void detachModels() {
        super.detachModels();
        if (this.labelModel != null) {
            this.labelModel.detach();
        }
    }

    @Override
    public Form<?> getForm() {
        return this.form;
    }

    public String getLabel() {
        return (String)this.labelModel.getObject();
    }

    public void setLabel(String label) {
        this.labelModel.setObject((Object)label);
    }

    protected boolean isRequired() {
        return true;
    }

    public String getTextFieldMarkupId() {
        return this.textField.getMarkupId();
    }

    private static Form<Void> newForm(String id) {
        return new Form<Void>(id){
            private static final long serialVersionUID = 1L;

            protected boolean wantSubmitOnParentFormSubmit() {
                return false;
            }
        };
    }

    protected KendoFeedbackPanel newFeedbackPanel(String id) {
        return new KendoFeedbackPanel(id, (MarkupContainer)this);
    }

    protected Component newLabel(String id, IModel<String> model) {
        return new Label(id, model);
    }

    protected FormComponent<T> newTextField(String id, IModel<T> model) {
        return new TextField<T>(id, model);
    }

    public static class AutoFocusBehavior
    extends JQueryAbstractBehavior {
        private static final long serialVersionUID = 1L;
        private InputWindow<?> window = null;

        public void bind(Component component) {
            super.bind(component);
            if (component instanceof InputWindow) {
                this.window = (InputWindow)component;
            }
        }

        protected String $() {
            if (this.window != null) {
                return String.format("%s.bind('activate', function() { jQuery('#%s').focus(); });", this.window.widget(), this.window.getTextFieldMarkupId());
            }
            return null;
        }
    }
}

