/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.format.DateTimeFormatter;

public class KendoDateTimeUtils {
    static final String PATTERN_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSSzzz";
    static final String j_chars = "GyYMwWDdFEuaHkKhmsSzZX";
    static final String k_chars = "GyYMwWDdFdutHkKhmsfzZX";
    static final int chars_lenth = "GyYMwWDdFEuaHkKhmsSzZX".length();

    private KendoDateTimeUtils() {
    }

    public static String toPattern(String pattern) {
        String converted = pattern;
        if (converted.contains("a") && !converted.contains("aa")) {
            converted = converted.replace("a", "aa");
        }
        for (int i = 0; i < chars_lenth; ++i) {
            char k;
            char j = j_chars.charAt(i);
            if (j == (k = k_chars.charAt(i))) continue;
            converted = converted.replace(j, k);
        }
        return converted;
    }

    public static String toString(Date date) {
        return new SimpleDateFormat(PATTERN_TZ).format(date);
    }

    public static String toString(LocalDate date) {
        return date.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String toString(LocalDateTime date) {
        return date.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }
}

