/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.scheduler;

import com.googlecode.wicket.jquery.core.behavior.AjaxCallbackBehavior;
import com.googlecode.wicket.kendo.ui.scheduler.ISchedulerVisitor;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerEvent;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerEventFactory;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerModel;
import java.util.List;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.util.lang.Args;

public class SchedulerModelBehavior
extends AjaxCallbackBehavior {
    private static final long serialVersionUID = 1L;
    private final SchedulerModel model;
    private final SchedulerEventFactory factory;

    public SchedulerModelBehavior(SchedulerModel model, SchedulerEventFactory factory) {
        this.model = model;
        this.factory = (SchedulerEventFactory)Args.notNull((Object)factory, (String)"factory");
    }

    protected void setStartDate(SchedulerModel model, long date) {
        model.setStart(date);
    }

    protected void setEndDate(SchedulerModel model, long date) {
        model.setEnd(date);
    }

    protected String getResponse(IRequestParameters parameters) {
        long start = parameters.getParameterValue("start").toLong(0L);
        long end = parameters.getParameterValue("end").toLong(0L);
        StringBuilder builder = new StringBuilder("[ ");
        if (this.model != null) {
            this.setStartDate(this.model, start);
            this.setEndDate(this.model, end);
            List list = (List)this.model.getObject();
            if (list != null) {
                int count = 0;
                for (SchedulerEvent event : list) {
                    if (this.model instanceof ISchedulerVisitor) {
                        event.accept((ISchedulerVisitor)((Object)this.model));
                    }
                    if (!event.isVisible()) continue;
                    if (count++ > 0) {
                        builder.append(", ");
                    }
                    builder.append(this.factory.toJson(event));
                }
            }
        }
        return builder.append(" ]").toString();
    }
}

