/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.scheduler;

import com.googlecode.wicket.jquery.core.utils.DateUtils;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerEvent;
import com.googlecode.wicket.kendo.ui.scheduler.resource.ResourceList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Generics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerEventFactory
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerEventFactory.class);

    public JSONObject toJson(SchedulerEvent event) {
        try {
            JSONObject object = new JSONObject();
            object.put("id", event.getId());
            object.put("isAllDay", event.isAllDay());
            if (event.getTitle() != null) {
                object.put("title", (Object)event.getTitle());
            }
            if (event.getDescription() != null) {
                object.put("description", (Object)event.getDescription());
            }
            if (event.getStart() != null) {
                object.put("start", (Object)DateUtils.toUTCString((Date)event.getStart()));
            }
            if (event.getEnd() != null) {
                object.put("end", (Object)DateUtils.toUTCString((Date)event.getEnd()));
            }
            if (event.getRecurrenceId() != null) {
                object.put("recurrenceId", (Object)event.getRecurrenceId());
            }
            if (event.getRecurrenceRule() != null) {
                object.put("recurrenceRule", (Object)event.getRecurrenceRule());
            }
            if (event.getRecurrenceException() != null) {
                object.put("recurrenceException", (Object)event.getRecurrenceException());
            }
            for (String field : event.getFields()) {
                object.put(field, event.getValue(field));
            }
            return object;
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public SchedulerEvent toObject(JSONObject object, List<ResourceList> lists) {
        try {
            SchedulerEvent event = new SchedulerEvent();
            event.setId(object.getInt("id"));
            event.setTitle(object.optString("title"));
            event.setDescription(object.optString("description"));
            event.setStart(object.getLong("start"));
            event.setEnd(object.getLong("end"));
            event.setAllDay(object.getBoolean("isAllDay"));
            event.setRecurrenceId(object.optString("recurrenceId"));
            event.setRecurrenceRule(object.optString("recurrenceRule"));
            event.setRecurrenceException(object.optString("recurrenceException"));
            Pattern pattern = Pattern.compile("([\\w-]+)");
            for (ResourceList list : lists) {
                ArrayList values = Generics.newArrayList();
                String field = list.getField();
                String value = object.optString(field);
                if (value != null) {
                    Matcher matcher = pattern.matcher(value);
                    while (matcher.find()) {
                        values.add(matcher.group());
                    }
                }
                if (list.isMultiple()) {
                    event.setResource(field, values);
                    continue;
                }
                if (values.isEmpty()) continue;
                event.setResource(field, (String)values.get(0));
            }
            return event;
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

