/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.repeater.listview;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.datatable.DataSourceAjaxBehavior;
import com.googlecode.wicket.kendo.ui.datatable.DataSourceEvent;
import com.googlecode.wicket.kendo.ui.repeater.listview.IListViewListener;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;

public abstract class ListViewBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoListView";
    private final IListViewListener listener;
    private final KendoDataSource dataSource;
    private JQueryAjaxBehavior onCreateAjaxBehavior;
    private JQueryAjaxBehavior onUpdateAjaxBehavior;
    private JQueryAjaxBehavior onDeleteAjaxBehavior;
    private JQueryAjaxBehavior onChangeAjaxBehavior = null;

    public ListViewBehavior(String selector, KendoDataSource dataSource, IListViewListener listener) {
        this(selector, dataSource, listener, new Options());
    }

    public ListViewBehavior(String selector, KendoDataSource dataSource, IListViewListener listener, Options options) {
        super(selector, METHOD, options);
        this.listener = (IListViewListener)Args.notNull((Object)listener, (String)"listener");
        this.dataSource = dataSource;
    }

    public void bind(Component component) {
        super.bind(component);
        this.add(this.dataSource);
        this.onCreateAjaxBehavior = this.newOnCreateAjaxBehavior(this);
        component.add(new Behavior[]{this.onCreateAjaxBehavior});
        this.onUpdateAjaxBehavior = this.newOnUpdateAjaxBehavior(this);
        component.add(new Behavior[]{this.onUpdateAjaxBehavior});
        this.onDeleteAjaxBehavior = this.newOnDeleteAjaxBehavior(this);
        component.add(new Behavior[]{this.onDeleteAjaxBehavior});
        if (this.listener.isSelectable()) {
            this.onChangeAjaxBehavior = this.newOnChangeAjaxBehavior(this, this.getDataSourceName());
            component.add(new Behavior[]{this.onChangeAjaxBehavior});
        }
    }

    protected abstract long getRowCount();

    protected abstract CharSequence getProviderUrl();

    public String getDataSourceName() {
        return this.dataSource.getName();
    }

    protected boolean useCache() {
        return false;
    }

    private String getReadCallbackFunction() {
        return KendoDataSource.getReadCallbackFunction(this.getProviderUrl(), this.useCache());
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        Options schema = new Options();
        schema.set("data", (Object)Options.asString((String)"results"));
        schema.set("total", (Object)Options.asString((String)"__count"));
        this.onConfigure(this.dataSource);
        this.setOption("dataSource", this.getDataSourceName());
        this.dataSource.set("schema", schema);
        this.dataSource.set("pageSize", this.getRowCount());
        this.dataSource.set("serverPaging", true);
        this.dataSource.setTransportRead(this.getReadCallbackFunction());
        this.dataSource.setTransportCreate(this.onCreateAjaxBehavior.getCallbackFunction());
        this.dataSource.setTransportUpdate(this.onUpdateAjaxBehavior.getCallbackFunction());
        this.dataSource.setTransportDelete(this.onDeleteAjaxBehavior.getCallbackFunction());
        if (this.onChangeAjaxBehavior != null) {
            this.setOption("change", this.onChangeAjaxBehavior.getCallbackFunction());
        }
    }

    protected void onConfigure(KendoDataSource dataSource) {
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof DataSourceEvent.CreateEvent) {
            this.listener.onCreate(target, ((DataSourceEvent.CreateEvent)event).getObject());
        }
        if (event instanceof DataSourceEvent.UpdateEvent) {
            this.listener.onUpdate(target, ((DataSourceEvent.UpdateEvent)event).getObject());
        }
        if (event instanceof DataSourceEvent.DeleteEvent) {
            this.listener.onDelete(target, ((DataSourceEvent.DeleteEvent)event).getObject());
        }
        if (event instanceof ChangeEvent) {
            this.listener.onChange(target, ((ChangeEvent)event).getObjects());
        }
    }

    protected JQueryAjaxBehavior newOnCreateAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new DataSourceEvent.CreateEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnUpdateAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new DataSourceEvent.UpdateEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnDeleteAjaxBehavior(IJQueryAjaxAware source) {
        return new DataSourceAjaxBehavior(source){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new DataSourceEvent.DeleteEvent();
            }
        };
    }

    protected JQueryAjaxBehavior newOnChangeAjaxBehavior(IJQueryAjaxAware source, String datasource) {
        return new OnChangeAjaxBehavior(source, datasource);
    }

    protected static class ChangeEvent
    extends JQueryEvent {
        private static final Pattern PATTERN = Pattern.compile("(\\{.*?\\})");
        private final List<JSONObject> objects = Generics.newArrayList();

        public ChangeEvent() {
            String input = RequestCycleUtils.getQueryParameterValue((String)"items").toString();
            Matcher matcher = PATTERN.matcher(input);
            while (matcher.find()) {
                this.objects.add(new JSONObject(matcher.group()));
            }
        }

        public List<JSONObject> getObjects() {
            return this.objects;
        }
    }

    protected static class OnChangeAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final String datasource;

        public OnChangeAjaxBehavior(IJQueryAjaxAware source, String datasource) {
            super(source);
            this.datasource = datasource;
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.resolved((String)"items", (String)"items")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            String variables = "";
            variables = variables + "var $view = " + this.datasource + ".view();";
            variables = variables + "var items = jQuery.map(this.select(), function(item) { var index = jQuery(item).index(); return kendo.stringify($view[index]); });";
            return variables + super.getCallbackFunctionBody(parameters);
        }

        protected JQueryEvent newEvent() {
            return new ChangeEvent();
        }
    }
}

