/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.interaction.droppable;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.interaction.droppable.IDroppableListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;

public class DroppableBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoDropTarget";
    private final IDroppableListener listener;
    private JQueryAjaxBehavior onDropAjaxBehavior;
    private JQueryAjaxBehavior onDragEnterAjaxBehavior = null;
    private JQueryAjaxBehavior onDragLeaveAjaxBehavior = null;
    private transient Component draggable = null;

    public DroppableBehavior(String selector, IDroppableListener listener) {
        this(selector, new Options(), listener);
    }

    public DroppableBehavior(String selector, Options options, IDroppableListener listener) {
        this(selector, METHOD, options, listener);
    }

    DroppableBehavior(String selector, String method, Options options, IDroppableListener listener) {
        super(selector, method, options);
        this.listener = (IDroppableListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void setDraggable(Component draggable) {
        this.draggable = draggable;
    }

    protected String getOnDragEnterStatement() {
        return "";
    }

    protected String getOnDragLeaveStatement() {
        return "";
    }

    protected String getOnDropStatement() {
        StringBuilder statement = new StringBuilder();
        statement.append("var $hint = jQuery(e.target),");
        statement.append("$element = e.draggable.element;");
        statement.append("$element.removeClass('").append("kendoDraggable-hide").append("');");
        statement.append("$element.offset($hint.offset());");
        return statement.toString();
    }

    public void bind(Component component) {
        super.bind(component);
        this.onDropAjaxBehavior = this.newOnDropAjaxBehavior(this, this.getOnDropStatement());
        component.add(new Behavior[]{this.onDropAjaxBehavior});
        if (this.listener.isDragEnterEventEnabled()) {
            this.onDragEnterAjaxBehavior = this.newOnDragEnterAjaxBehavior(this, this.getOnDragEnterStatement());
            component.add(new Behavior[]{this.onDragEnterAjaxBehavior});
        }
        if (this.listener.isDragLeaveEventEnabled()) {
            this.onDragLeaveAjaxBehavior = this.newOnDragLeaveAjaxBehavior(this, this.getOnDragLeaveStatement());
            component.add(new Behavior[]{this.onDragLeaveAjaxBehavior});
        }
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.setOption("drop", this.onDropAjaxBehavior.getCallbackFunction());
        if (this.onDragEnterAjaxBehavior != null) {
            this.setOption("dragenter", this.onDragEnterAjaxBehavior.getCallbackFunction());
        }
        if (this.onDragLeaveAjaxBehavior != null) {
            this.setOption("dragleave", this.onDragLeaveAjaxBehavior.getCallbackFunction());
        }
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof DropEvent) {
            this.listener.onDrop(target, this.draggable);
        } else if (event instanceof DragEnterEvent) {
            this.listener.onDragEnter(target, this.draggable);
        } else if (event instanceof DragLeaveEvent) {
            this.listener.onDragLeave(target, this.draggable);
        }
    }

    protected JQueryAjaxBehavior newOnDragEnterAjaxBehavior(IJQueryAjaxAware source, String statement) {
        return new OnDragEnterAjaxBehavior(source, statement);
    }

    protected JQueryAjaxBehavior newOnDragLeaveAjaxBehavior(IJQueryAjaxAware source, String statement) {
        return new OnDragLeaveAjaxBehavior(source, statement);
    }

    protected JQueryAjaxBehavior newOnDropAjaxBehavior(IJQueryAjaxAware source, String statement) {
        return new OnDropAjaxBehavior(source, statement);
    }

    protected static class DropEvent
    extends JQueryEvent {
        protected DropEvent() {
        }
    }

    protected static class DragLeaveEvent
    extends JQueryEvent {
        protected DragLeaveEvent() {
        }
    }

    protected static class DragEnterEvent
    extends JQueryEvent {
        protected DragEnterEvent() {
        }
    }

    protected static class OnDropAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final String statement;

        public OnDropAjaxBehavior(IJQueryAjaxAware source, String statement) {
            super(source);
            this.statement = statement;
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            return this.statement + super.getCallbackFunctionBody(parameters);
        }

        protected JQueryEvent newEvent() {
            return new DropEvent();
        }
    }

    protected static class OnDragLeaveAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final String statement;

        public OnDragLeaveAjaxBehavior(IJQueryAjaxAware source, String statement) {
            super(source);
            this.statement = statement;
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            return this.statement + super.getCallbackFunctionBody(parameters);
        }

        protected JQueryEvent newEvent() {
            return new DragLeaveEvent();
        }
    }

    protected static class OnDragEnterAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final String statement;

        public OnDragEnterAjaxBehavior(IJQueryAjaxAware source, String statement) {
            super(source);
            this.statement = statement;
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            return this.statement + super.getCallbackFunctionBody(parameters);
        }

        protected JQueryEvent newEvent() {
            return new DragEnterEvent();
        }
    }
}

