/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.multiselect.lazy;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.event.ISelectionChangedListener;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.ajax.OnChangeAjaxBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.lang.Args;

public abstract class MultiSelectBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoMultiSelect";
    private final ISelectionChangedListener listener;
    private KendoDataSource dataSource;
    private JQueryAjaxBehavior onChangeAjaxBehavior = null;

    public MultiSelectBehavior(String selector, ISelectionChangedListener listener) {
        super(selector, METHOD);
        this.listener = (ISelectionChangedListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.dataSource = new KendoDataSource(component);
        this.add(this.dataSource);
        if (this.listener.isSelectionChangedEventEnabled()) {
            this.onChangeAjaxBehavior = new OnChangeAjaxBehavior(this, new FormComponent[0]);
            component.add(new Behavior[]{this.onChangeAjaxBehavior});
        }
    }

    public boolean isEnabled(Component component) {
        return component.isEnabledInHierarchy();
    }

    protected abstract CharSequence getDataSourceUrl();

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.setOption("autoBind", true);
        if (this.onChangeAjaxBehavior != null) {
            this.setOption("change", this.onChangeAjaxBehavior.getCallbackFunction());
        }
        this.onConfigure(this.dataSource);
        this.setOption("dataSource", this.dataSource.getName());
        if (this.isEnabled(component)) {
            this.dataSource.setTransportRead(Options.asString((Object)this.getDataSourceUrl()));
        }
    }

    protected void onConfigure(KendoDataSource dataSource) {
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof OnChangeAjaxBehavior.ChangeEvent) {
            this.listener.onSelectionChanged(target);
        }
    }
}

