/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.datetime.local;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.utils.LocaleUtils;
import com.googlecode.wicket.kendo.ui.form.datetime.local.LocalTextField;
import java.util.Locale;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.threeten.bp.LocalTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeParseException;

public class TimePicker
extends LocalTextField<LocalTime> {
    private static final long serialVersionUID = 1L;

    public TimePicker(String id) {
        this(id, new Options());
    }

    public TimePicker(String id, Options options) {
        this(id, null, null, "h:mm a", options);
    }

    public TimePicker(String id, Locale locale) {
        this(id, locale, new Options());
    }

    public TimePicker(String id, Locale locale, Options options) {
        this(id, null, locale, LocaleUtils.getLocaleTimePattern((Locale)locale, (String)"h:mm a"), options);
    }

    public TimePicker(String id, String pattern) {
        this(id, pattern, new Options());
    }

    public TimePicker(String id, String pattern, Options options) {
        this(id, null, null, pattern, options);
    }

    public TimePicker(String id, Locale locale, String pattern) {
        this(id, locale, pattern, new Options());
    }

    public TimePicker(String id, Locale locale, String pattern, Options options) {
        this(id, null, locale, pattern, options);
    }

    public TimePicker(String id, IModel<LocalTime> model) {
        this(id, model, new Options());
    }

    public TimePicker(String id, IModel<LocalTime> model, Options options) {
        this(id, model, null, "h:mm a", options);
    }

    public TimePicker(String id, IModel<LocalTime> model, Locale locale) {
        this(id, model, locale, new Options());
    }

    public TimePicker(String id, IModel<LocalTime> model, Locale locale, Options options) {
        this(id, model, locale, LocaleUtils.getLocaleTimePattern((Locale)locale, (String)"h:mm a"), options);
    }

    public TimePicker(String id, IModel<LocalTime> model, String pattern) {
        this(id, model, pattern, new Options());
    }

    public TimePicker(String id, IModel<LocalTime> model, String pattern, Options options) {
        this(id, model, null, pattern, options);
    }

    public TimePicker(String id, IModel<LocalTime> model, Locale locale, String pattern) {
        this(id, model, locale, pattern, new Options());
    }

    public TimePicker(String id, IModel<LocalTime> model, Locale locale, String pattern, Options options) {
        super(id, model, locale, pattern, options, LocalTime.class, TimePicker.newConverter(pattern));
    }

    @Override
    protected String getMethod() {
        return "kendoTimePicker";
    }

    protected String[] getInputTypes() {
        return new String[]{"text", "time"};
    }

    private static IConverter<LocalTime> newConverter(final String pattern) {
        return new IConverter<LocalTime>(){
            private static final long serialVersionUID = 1L;

            public LocalTime convertToObject(String value, Locale locale) throws ConversionException {
                try {
                    return LocalTime.parse((CharSequence)value, (DateTimeFormatter)DateTimeFormatter.ofPattern((String)pattern, (Locale)locale));
                }
                catch (DateTimeParseException e) {
                    throw new ConversionException(e.getMessage(), (Throwable)e);
                }
            }

            public String convertToString(LocalTime time, Locale locale) {
                return time != null ? time.format(DateTimeFormatter.ofPattern((String)pattern, (Locale)locale)) : null;
            }
        };
    }
}

