/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.datetime.local;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.utils.LocaleUtils;
import com.googlecode.wicket.kendo.ui.form.datetime.local.DatePicker;
import com.googlecode.wicket.kendo.ui.form.datetime.local.TimePicker;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.format.DateTimeFormatter;

public class DateTimePicker
extends FormComponentPanel<LocalDateTime>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_NOT_INITIALIZED = "Internal timePicker is not initialized (#onInitialize() has not yet been called).";
    DatePicker datePicker;
    TimePicker timePicker;
    private final Locale locale;
    private final String datePattern;
    private final String timePattern;

    public DateTimePicker(String id) {
        this(id, null, null, "MM/dd/yyyy", "h:mm a");
    }

    public DateTimePicker(String id, Locale locale) {
        this(id, null, locale, LocaleUtils.getLocaleDatePattern((Locale)locale, (String)"MM/dd/yyyy"), LocaleUtils.getLocaleTimePattern((Locale)locale, (String)"h:mm a"));
    }

    public DateTimePicker(String id, String datePattern, String timePattern) {
        this(id, null, null, datePattern, timePattern);
    }

    public DateTimePicker(String id, Locale locale, String datePattern, String timePattern) {
        this(id, null, locale, datePattern, timePattern);
    }

    public DateTimePicker(String id, IModel<LocalDateTime> model) {
        this(id, model, null, "MM/dd/yyyy", "h:mm a");
    }

    public DateTimePicker(String id, IModel<LocalDateTime> model, Locale locale) {
        this(id, model, locale, LocaleUtils.getLocaleDatePattern((Locale)locale, (String)"MM/dd/yyyy"), LocaleUtils.getLocaleTimePattern((Locale)locale, (String)"h:mm a"));
    }

    public DateTimePicker(String id, IModel<LocalDateTime> model, String datePattern, String timePattern) {
        this(id, model, null, datePattern, timePattern);
    }

    public DateTimePicker(String id, IModel<LocalDateTime> model, Locale locale, String datePattern, String timePattern) {
        super(id, model);
        this.locale = locale;
        this.datePattern = datePattern;
        this.timePattern = timePattern;
    }

    public void convertInput() {
        LocalDate date = (LocalDate)this.datePicker.getConvertedInput();
        LocalTime time = (LocalTime)this.timePicker.getConvertedInput();
        this.setConvertedInput(LocalDateTime.of((LocalDate)date, (LocalTime)(time != null ? time : LocalTime.MIDNIGHT)));
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    public final String getTextFormat() {
        if (this.isTimePickerEnabled()) {
            return String.format("%s %s", this.getDatePattern(), this.getTimePattern());
        }
        return this.getDatePattern();
    }

    public String getModelObjectAsString() {
        LocalDateTime date = (LocalDateTime)this.getModelObject();
        if (date != null) {
            return date.format(DateTimeFormatter.ofPattern((String)this.getTextFormat(), (Locale)this.getLocale()));
        }
        return "";
    }

    public final String getDatePattern() {
        return this.datePicker.getTextFormat();
    }

    public final String getTimePattern() {
        return this.timePicker.getTextFormat();
    }

    public final boolean isTimePickerEnabled() {
        if (this.timePicker != null) {
            return this.timePicker.isEnabled();
        }
        throw new WicketRuntimeException(ERROR_NOT_INITIALIZED);
    }

    public final void setTimePickerEnabled(boolean enabled) {
        if (this.timePicker == null) {
            throw new WicketRuntimeException(ERROR_NOT_INITIALIZED);
        }
        this.timePicker.setEnabled(enabled);
    }

    public final void setTimePickerEnabled(IPartialPageRequestHandler handler, boolean enabled) {
        this.setTimePickerEnabled(enabled);
        handler.add(new Component[]{this.timePicker});
    }

    protected void onInitialize() {
        super.onInitialize();
        this.datePicker = this.newDatePicker("datepicker", (IModel<LocalDate>)new PropertyModel((Object)this.getModel(), "date"), this.locale, this.datePattern, new Options());
        this.timePicker = this.newTimePicker("timepicker", (IModel<LocalTime>)new PropertyModel((Object)this.getModel(), "time"), this.locale, this.timePattern, new Options());
        this.add(new Component[]{this.datePicker.setConvertEmptyInputStringToNull(false)});
        this.add(new Component[]{this.timePicker.setConvertEmptyInputStringToNull(false)});
    }

    protected DatePicker newDatePicker(String id, IModel<LocalDate> model, Locale locale, String datePattern, Options options) {
        return new DatePicker(id, model, locale, datePattern, options);
    }

    protected TimePicker newTimePicker(String id, IModel<LocalTime> model, Locale locale, String timePattern, Options options) {
        return new TimePicker(id, model, locale, timePattern, options);
    }
}

