/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.datetime.local;

import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxPostBehavior;
import com.googlecode.wicket.jquery.core.event.IValueChangedListener;
import com.googlecode.wicket.kendo.ui.ajax.OnChangeAjaxBehavior;
import com.googlecode.wicket.kendo.ui.form.datetime.DatePickerBehavior;
import com.googlecode.wicket.kendo.ui.form.datetime.TimePickerBehavior;
import com.googlecode.wicket.kendo.ui.form.datetime.local.AjaxDatePicker;
import com.googlecode.wicket.kendo.ui.form.datetime.local.AjaxTimePicker;
import com.googlecode.wicket.kendo.ui.form.datetime.local.DatePicker;
import com.googlecode.wicket.kendo.ui.form.datetime.local.DateTimePicker;
import com.googlecode.wicket.kendo.ui.form.datetime.local.TimePicker;
import java.util.Locale;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeParseException;

public class AjaxDateTimePicker
extends DateTimePicker
implements IValueChangedListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AjaxDateTimePicker.class);

    public AjaxDateTimePicker(String id) {
        super(id);
    }

    public AjaxDateTimePicker(String id, Locale locale) {
        super(id, locale);
    }

    public AjaxDateTimePicker(String id, String datePattern, String timePattern) {
        super(id, datePattern, timePattern);
    }

    public AjaxDateTimePicker(String id, Locale locale, String datePattern, String timePattern) {
        super(id, locale, datePattern, timePattern);
    }

    public AjaxDateTimePicker(String id, IModel<LocalDateTime> model) {
        super(id, model);
    }

    public AjaxDateTimePicker(String id, IModel<LocalDateTime> model, Locale locale) {
        super(id, model, locale);
    }

    public AjaxDateTimePicker(String id, IModel<LocalDateTime> model, String datePattern, String timePattern) {
        super(id, model, datePattern, timePattern);
    }

    public AjaxDateTimePicker(String id, IModel<LocalDateTime> model, Locale locale, String datePattern, String timePattern) {
        super(id, model, locale, datePattern, timePattern);
    }

    protected String formatInput(String dateInput, String timeInput) {
        if (this.isTimePickerEnabled()) {
            return String.format("%s %s", dateInput, timeInput);
        }
        return dateInput;
    }

    @Override
    public void convertInput() {
        IConverter<LocalDateTime> converter = this.getConverter(LocalDateTime.class);
        String dateInput = this.datePicker.getInput();
        String timeInput = this.timePicker.getInput();
        try {
            String value = this.formatInput(dateInput, timeInput);
            this.setConvertedInput(converter.convertToObject(value, this.getLocale()));
        }
        catch (ConversionException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            ValidationError error = new ValidationError();
            error.addKey("DateTimePicker.ConversionError");
            error.setVariable("date", (Object)dateInput);
            error.setVariable("time", (Object)timeInput);
            this.error((IValidationError)error);
        }
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (LocalDateTime.class.isAssignableFrom(type)) {
            return AjaxDateTimePicker.newConverter(this.getTextFormat());
        }
        return super.getConverter(type);
    }

    public void onValueChanged(IPartialPageRequestHandler handler) {
    }

    private static IConverter<LocalDateTime> newConverter(final String pattern) {
        return new IConverter<LocalDateTime>(){
            private static final long serialVersionUID = 1L;

            public LocalDateTime convertToObject(String value, Locale locale) throws ConversionException {
                try {
                    return LocalDateTime.parse((CharSequence)value, (DateTimeFormatter)DateTimeFormatter.ofPattern((String)pattern, (Locale)locale));
                }
                catch (DateTimeParseException e) {
                    throw new ConversionException(e.getMessage(), (Throwable)e);
                }
            }

            public String convertToString(LocalDateTime datetime, Locale locale) {
                return datetime != null ? datetime.format(DateTimeFormatter.ofPattern((String)pattern, (Locale)locale)) : null;
            }
        };
    }

    @Override
    protected DatePicker newDatePicker(String id, IModel<LocalDate> model, Locale locale, String datePattern, Options options) {
        return new AjaxDatePicker(id, model, locale, datePattern, options){
            private static final long serialVersionUID = 1L;

            @Override
            public JQueryBehavior newWidgetBehavior(String selector) {
                IValueChangedListener listener = new IValueChangedListener(){
                    private static final long serialVersionUID = 1L;

                    public void onValueChanged(IPartialPageRequestHandler handler) {
                        AjaxDateTimePicker.this.processInput();
                        AjaxDateTimePicker.this.onValueChanged(handler);
                    }
                };
                return new DatePickerBehavior(selector, this.options, listener){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected JQueryAjaxPostBehavior newOnChangeAjaxBehavior(IJQueryAjaxAware source) {
                        return new OnChangeAjaxBehavior(source, new FormComponent[]{AjaxDateTimePicker.this.datePicker, AjaxDateTimePicker.this.timePicker});
                    }
                };
            }
        };
    }

    @Override
    protected TimePicker newTimePicker(String id, IModel<LocalTime> model, Locale locale, String timePattern, Options options) {
        return new AjaxTimePicker(id, model, locale, timePattern, options){
            private static final long serialVersionUID = 1L;

            @Override
            public JQueryBehavior newWidgetBehavior(String selector) {
                IValueChangedListener listener = new IValueChangedListener(){
                    private static final long serialVersionUID = 1L;

                    public void onValueChanged(IPartialPageRequestHandler handler) {
                        AjaxDateTimePicker.this.processInput();
                        AjaxDateTimePicker.this.onValueChanged(handler);
                    }
                };
                return new TimePickerBehavior(selector, this.options, listener){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected JQueryAjaxPostBehavior newOnChangeAjaxBehavior(IJQueryAjaxAware source) {
                        return new OnChangeAjaxBehavior(source, new FormComponent[]{AjaxDateTimePicker.this.datePicker, AjaxDateTimePicker.this.timePicker});
                    }
                };
            }
        };
    }
}

