/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.datetime;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxPostBehavior;
import com.googlecode.wicket.jquery.core.event.IValueChangedListener;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.ajax.OnChangeAjaxBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.lang.Args;

public class TimePickerBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoTimePicker";
    private final IValueChangedListener listener;
    private JQueryAjaxBehavior onChangeAjaxBehavior = null;

    public TimePickerBehavior(String selector, IValueChangedListener listener) {
        this(selector, new Options(), listener);
    }

    public TimePickerBehavior(String selector, Options options, IValueChangedListener listener) {
        super(selector, METHOD, options);
        this.listener = (IValueChangedListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.onChangeAjaxBehavior = this.newOnChangeAjaxBehavior(this);
        component.add(new Behavior[]{this.onChangeAjaxBehavior});
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (this.onChangeAjaxBehavior != null) {
            this.setOption("change", this.onChangeAjaxBehavior.getCallbackFunction());
        }
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof OnChangeAjaxBehavior.ChangeEvent) {
            this.listener.onValueChanged((IPartialPageRequestHandler)target);
        }
    }

    protected JQueryAjaxPostBehavior newOnChangeAjaxBehavior(IJQueryAjaxAware source) {
        return new OnChangeAjaxBehavior(source, new FormComponent[0]);
    }
}

