/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.combobox;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import org.apache.wicket.Component;

public abstract class ComboBoxBehavior
extends KendoUIBehavior {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoComboBox";
    private KendoDataSource dataSource;

    public ComboBoxBehavior(String selector) {
        super(selector, METHOD);
    }

    public void bind(Component component) {
        super.bind(component);
        this.dataSource = new KendoDataSource(component);
        this.add(this.dataSource);
    }

    public boolean isEnabled(Component component) {
        return component.isEnabledInHierarchy();
    }

    protected abstract CharSequence getDataSourceUrl();

    public String getDataSourceName() {
        if (this.dataSource != null) {
            return this.dataSource.getName();
        }
        return null;
    }

    public String getDataSourceToken() {
        if (this.dataSource != null) {
            return this.dataSource.getToken();
        }
        return null;
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.setOption("autoBind", true);
        this.setOption("dataSource", this.getDataSourceName());
        if (this.isEnabled(component)) {
            this.dataSource.setTransportRead(Options.asString((Object)this.getDataSourceUrl()));
        }
    }
}

