/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.buttongroup;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.form.buttongroup.IButtonGroupListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;

public class ButtonGroupBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoMobileButtonGroup";
    static final int NONE = -1;
    private final IButtonGroupListener listener;
    private JQueryAjaxBehavior onSelectAjaxBehavior;

    public ButtonGroupBehavior(String selector, IButtonGroupListener listener) {
        this(selector, new Options(), listener);
    }

    public ButtonGroupBehavior(String selector, Options options, IButtonGroupListener listener) {
        super(selector, METHOD, options);
        this.listener = (IButtonGroupListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.onSelectAjaxBehavior = this.newOnSelectAjaxBehavior(this);
        component.add(new Behavior[]{this.onSelectAjaxBehavior});
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.setOption("select", this.onSelectAjaxBehavior.getCallbackFunction());
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof SelectEvent) {
            this.listener.onSelect(target, ((SelectEvent)event).getIndex());
        }
    }

    protected JQueryAjaxBehavior newOnSelectAjaxBehavior(IJQueryAjaxAware source) {
        return new OnSelectAjaxBehavior(source);
    }

    protected static class SelectEvent
    extends JQueryEvent {
        private final int index = RequestCycleUtils.getQueryParameterValue((String)"index").toInt(-1);

        public int getIndex() {
            return this.index;
        }
    }

    protected static class OnSelectAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnSelectAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"index", (String)"e.index")};
        }

        protected JQueryEvent newEvent() {
            return new SelectEvent();
        }
    }
}

